# System.Numerics

``` diff
 namespace System.Numerics {
     public struct Complex : IEquatable<Complex>, IFormattable {
+        public static readonly Complex Infinity;
+        public static readonly Complex NaN;
+        public static Complex Add(double left, Complex right);
+        public static Complex Add(Complex left, double right);
+        public static Complex Divide(double dividend, Complex divisor);
+        public static Complex Divide(Complex dividend, double divisor);
+        public static bool IsFinite(Complex value);
+        public static bool IsInfinity(Complex value);
+        public static bool IsNaN(Complex value);
+        public static Complex Multiply(double left, Complex right);
+        public static Complex Multiply(Complex left, double right);
+        public static Complex operator +(double left, Complex right);
+        public static Complex operator +(Complex left, double right);
+        public static Complex operator /(double left, Complex right);
+        public static Complex operator /(Complex left, double right);
+        public static Complex operator *(double left, Complex right);
+        public static Complex operator *(Complex left, double right);
+        public static Complex operator -(double left, Complex right);
+        public static Complex operator -(Complex left, double right);
+        public static Complex Subtract(double left, Complex right);
+        public static Complex Subtract(Complex left, double right);
     }
 }
```

