# System.Text.Json

``` diff
 namespace System.Text.Json {
+    public sealed class JsonDocument : IDisposable {
+        public JsonElement RootElement { get; }
+        public void Dispose();
+        public static JsonDocument Parse(ReadOnlySequence<byte> utf8Json, JsonReaderOptions readerOptions = default(JsonReaderOptions));
+        public static JsonDocument Parse(Stream utf8Json, JsonReaderOptions readerOptions = default(JsonReaderOptions));
+        public static JsonDocument Parse(ReadOnlyMemory<byte> utf8Json, JsonReaderOptions readerOptions = default(JsonReaderOptions));
+        public static JsonDocument Parse(ReadOnlyMemory<char> json, JsonReaderOptions readerOptions = default(JsonReaderOptions));
+        public static JsonDocument Parse(string json, JsonReaderOptions readerOptions = default(JsonReaderOptions));
+        public static Task<JsonDocument> ParseAsync(Stream utf8Json, JsonReaderOptions readerOptions = default(JsonReaderOptions), CancellationToken cancellationToken = default(CancellationToken));
+    }
+    public readonly struct JsonElement {
+        public JsonElement this[int index] { get; }
+        public JsonValueType Type { get; }
+        public JsonElement.ArrayEnumerator EnumerateArray();
+        public JsonElement.ObjectEnumerator EnumerateObject();
+        public int GetArrayLength();
+        public bool GetBoolean();
+        public decimal GetDecimal();
+        public double GetDouble();
+        public int GetInt32();
+        public long GetInt64();
+        public JsonElement GetProperty(ReadOnlySpan<byte> utf8PropertyName);
+        public JsonElement GetProperty(ReadOnlySpan<char> propertyName);
+        public JsonElement GetProperty(string propertyName);
+        public string GetRawText();
+        public float GetSingle();
+        public string GetString();
+        public uint GetUInt32();
+        public ulong GetUInt64();
+        public override string ToString();
+        public bool TryGetDecimal(out decimal value);
+        public bool TryGetDouble(out double value);
+        public bool TryGetInt32(out int value);
+        public bool TryGetInt64(out long value);
+        public bool TryGetProperty(ReadOnlySpan<byte> utf8PropertyName, out JsonElement value);
+        public bool TryGetProperty(ReadOnlySpan<char> propertyName, out JsonElement value);
+        public bool TryGetProperty(string propertyName, out JsonElement value);
+        public bool TryGetSingle(out float value);
+        public bool TryGetUInt32(out uint value);
+        public bool TryGetUInt64(out ulong value);
+        public struct ArrayEnumerator : IDisposable, IEnumerable, IEnumerable<JsonElement>, IEnumerator, IEnumerator<JsonElement> {
+            public JsonElement Current { get; }
+            object System.Collections.IEnumerator.Current { get; }
+            public void Dispose();
+            public JsonElement.ArrayEnumerator GetEnumerator();
+            public bool MoveNext();
+            public void Reset();
+            IEnumerator<JsonElement> System.Collections.Generic.IEnumerable<System.Text.Json.JsonElement>.GetEnumerator();
+            IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        }
+        public struct ObjectEnumerator : IDisposable, IEnumerable, IEnumerable<JsonProperty>, IEnumerator, IEnumerator<JsonProperty> {
+            public JsonProperty Current { get; }
+            object System.Collections.IEnumerator.Current { get; }
+            public void Dispose();
+            public JsonElement.ObjectEnumerator GetEnumerator();
+            public bool MoveNext();
+            public void Reset();
+            IEnumerator<JsonProperty> System.Collections.Generic.IEnumerable<System.Text.Json.JsonProperty>.GetEnumerator();
+            IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        }
+    }
+    public readonly struct JsonProperty {
+        public string Name { get; }
+        public JsonElement Value { get; }
+        public override string ToString();
+    }
+    public enum JsonValueType : byte {
+        Array = (byte)2,
+        False = (byte)6,
+        Null = (byte)7,
+        Number = (byte)4,
+        Object = (byte)1,
+        String = (byte)3,
+        True = (byte)5,
+        Undefined = (byte)0,
+    }
+    public struct JsonWriterOptions {
+        public bool Indented { get; set; }
+        public bool SkipValidation { get; set; }
+    }
+    public struct JsonWriterState {
+        public JsonWriterState(JsonWriterOptions options = default(JsonWriterOptions));
+        public long BytesCommitted { get; }
+        public long BytesWritten { get; }
+        public JsonWriterOptions Options { get; }
+    }
     public ref struct Utf8JsonReader {
+        public bool GetBoolean();
-        public bool GetBooleanValue();

+        public decimal GetDecimal();
+        public double GetDouble();
+        public int GetInt32();
+        public long GetInt64();
+        public float GetSingle();
+        public string GetString();
-        public string GetStringValue();

+        public uint GetUInt32();
+        public ulong GetUInt64();
+        public bool TryGetDecimal(out decimal value);
-        public bool TryGetDecimalValue(out decimal value);

+        public bool TryGetDouble(out double value);
-        public bool TryGetDoubleValue(out double value);

+        public bool TryGetInt32(out int value);
-        public bool TryGetInt32Value(out int value);

+        public bool TryGetInt64(out long value);
-        public bool TryGetInt64Value(out long value);

+        public bool TryGetSingle(out float value);
-        public bool TryGetSingleValue(out float value);

+        public bool TryGetUInt32(out uint value);
+        public bool TryGetUInt64(out ulong value);
     }
+    public ref struct Utf8JsonWriter {
+        public Utf8JsonWriter(IBufferWriter<byte> bufferWriter, JsonWriterState state = default(JsonWriterState));
+        public long BytesCommitted { get; }
+        public long BytesWritten { get; }
+        public int CurrentDepth { get; }
+        public void Flush(bool isFinalBlock = true);
+        public JsonWriterState GetCurrentState();
+        public void WriteBoolean(ReadOnlySpan<byte> utf8PropertyName, bool value, bool escape = true);
+        public void WriteBoolean(ReadOnlySpan<char> propertyName, bool value, bool escape = true);
+        public void WriteBoolean(string propertyName, bool value, bool escape = true);
+        public void WriteBooleanValue(bool value);
+        public void WriteCommentValue(ReadOnlySpan<byte> utf8Value, bool escape = true);
+        public void WriteCommentValue(ReadOnlySpan<char> value, bool escape = true);
+        public void WriteCommentValue(string value, bool escape = true);
+        public void WriteEndArray();
+        public void WriteEndObject();
+        public void WriteNull(ReadOnlySpan<byte> utf8PropertyName, bool escape = true);
+        public void WriteNull(ReadOnlySpan<char> propertyName, bool escape = true);
+        public void WriteNull(string propertyName, bool escape = true);
+        public void WriteNullValue();
+        public void WriteNumber(ReadOnlySpan<byte> utf8PropertyName, decimal value, bool escape = true);
+        public void WriteNumber(ReadOnlySpan<byte> utf8PropertyName, double value, bool escape = true);
+        public void WriteNumber(ReadOnlySpan<byte> utf8PropertyName, int value, bool escape = true);
+        public void WriteNumber(ReadOnlySpan<byte> utf8PropertyName, long value, bool escape = true);
+        public void WriteNumber(ReadOnlySpan<byte> utf8PropertyName, float value, bool escape = true);
+        public void WriteNumber(ReadOnlySpan<byte> utf8PropertyName, uint value, bool escape = true);
+        public void WriteNumber(ReadOnlySpan<byte> utf8PropertyName, ulong value, bool escape = true);
+        public void WriteNumber(ReadOnlySpan<char> propertyName, decimal value, bool escape = true);
+        public void WriteNumber(ReadOnlySpan<char> propertyName, double value, bool escape = true);
+        public void WriteNumber(ReadOnlySpan<char> propertyName, int value, bool escape = true);
+        public void WriteNumber(ReadOnlySpan<char> propertyName, long value, bool escape = true);
+        public void WriteNumber(ReadOnlySpan<char> propertyName, float value, bool escape = true);
+        public void WriteNumber(ReadOnlySpan<char> propertyName, uint value, bool escape = true);
+        public void WriteNumber(ReadOnlySpan<char> propertyName, ulong value, bool escape = true);
+        public void WriteNumber(string propertyName, decimal value, bool escape = true);
+        public void WriteNumber(string propertyName, double value, bool escape = true);
+        public void WriteNumber(string propertyName, int value, bool escape = true);
+        public void WriteNumber(string propertyName, long value, bool escape = true);
+        public void WriteNumber(string propertyName, float value, bool escape = true);
+        public void WriteNumber(string propertyName, uint value, bool escape = true);
+        public void WriteNumber(string propertyName, ulong value, bool escape = true);
+        public void WriteNumberValue(decimal value);
+        public void WriteNumberValue(double value);
+        public void WriteNumberValue(int value);
+        public void WriteNumberValue(long value);
+        public void WriteNumberValue(float value);
+        public void WriteNumberValue(uint value);
+        public void WriteNumberValue(ulong value);
+        public void WriteStartArray();
+        public void WriteStartArray(ReadOnlySpan<byte> utf8PropertyName, bool escape = true);
+        public void WriteStartArray(ReadOnlySpan<char> propertyName, bool escape = true);
+        public void WriteStartArray(string propertyName, bool escape = true);
+        public void WriteStartObject();
+        public void WriteStartObject(ReadOnlySpan<byte> utf8PropertyName, bool escape = true);
+        public void WriteStartObject(ReadOnlySpan<char> propertyName, bool escape = true);
+        public void WriteStartObject(string propertyName, bool escape = true);
+        public void WriteString(ReadOnlySpan<byte> utf8PropertyName, DateTime value, bool escape = true);
+        public void WriteString(ReadOnlySpan<byte> utf8PropertyName, DateTimeOffset value, bool escape = true);
+        public void WriteString(ReadOnlySpan<byte> utf8PropertyName, Guid value, bool escape = true);
+        public void WriteString(ReadOnlySpan<byte> utf8PropertyName, ReadOnlySpan<byte> utf8Value, bool escape = true);
+        public void WriteString(ReadOnlySpan<byte> utf8PropertyName, ReadOnlySpan<char> value, bool escape = true);
+        public void WriteString(ReadOnlySpan<byte> utf8PropertyName, string value, bool escape = true);
+        public void WriteString(ReadOnlySpan<char> propertyName, DateTime value, bool escape = true);
+        public void WriteString(ReadOnlySpan<char> propertyName, DateTimeOffset value, bool escape = true);
+        public void WriteString(ReadOnlySpan<char> propertyName, Guid value, bool escape = true);
+        public void WriteString(ReadOnlySpan<char> propertyName, ReadOnlySpan<byte> utf8Value, bool escape = true);
+        public void WriteString(ReadOnlySpan<char> propertyName, ReadOnlySpan<char> value, bool escape = true);
+        public void WriteString(ReadOnlySpan<char> propertyName, string value, bool escape = true);
+        public void WriteString(string propertyName, DateTime value, bool escape = true);
+        public void WriteString(string propertyName, DateTimeOffset value, bool escape = true);
+        public void WriteString(string propertyName, Guid value, bool escape = true);
+        public void WriteString(string propertyName, ReadOnlySpan<byte> utf8Value, bool escape = true);
+        public void WriteString(string propertyName, ReadOnlySpan<char> value, bool escape = true);
+        public void WriteString(string propertyName, string value, bool escape = true);
+        public void WriteStringValue(DateTime value);
+        public void WriteStringValue(DateTimeOffset value);
+        public void WriteStringValue(Guid value);
+        public void WriteStringValue(ReadOnlySpan<byte> utf8Value, bool escape = true);
+        public void WriteStringValue(ReadOnlySpan<char> value, bool escape = true);
+        public void WriteStringValue(string value, bool escape = true);
+    }
 }
```

