# System.Diagnostics

``` diff
 namespace System.Diagnostics {
     public class Activity {
+        public ActivityTraceFlags ActivityTraceFlags { get; set; }
+        public static ActivityIdFormat DefaultIdFormat { get; set; }
+        public static bool ForceDefaultIdFormat { get; set; }
+        public ActivityIdFormat IdFormat { get; }
+        public ref readonly ActivitySpanId ParentSpanId { get; }
+        public bool Recorded { get; }
+        public ref readonly ActivitySpanId SpanId { get; }
+        public ref readonly ActivityTraceId TraceId { get; }
+        public string TraceStateString { get; set; }
+        public Activity SetParentId(in ActivityTraceId traceId, in ActivitySpanId spanId, ActivityTraceFlags activityTraceFlags = ActivityTraceFlags.None);
     }
+    public enum ActivityIdFormat {
+        Hierarchical = 1,
+        Unknown = 0,
+        W3C = 2,
+    }
+    public readonly struct ActivitySpanId : IEquatable<ActivitySpanId> {
+        public void CopyTo(Span<byte> destination);
+        public static ActivitySpanId CreateFromBytes(ReadOnlySpan<byte> idData);
+        public static ActivitySpanId CreateFromString(ReadOnlySpan<char> idData);
+        public static ActivitySpanId CreateFromUtf8String(ReadOnlySpan<byte> idData);
+        public static ActivitySpanId CreateRandom();
+        public bool Equals(ActivitySpanId spanId);
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public static bool operator ==(in ActivitySpanId spanId1, in ActivitySpanId spandId2);
+        public static bool operator !=(in ActivitySpanId spanId1, in ActivitySpanId spandId2);
+        public string ToHexString();
+        public override string ToString();
+    }
+    public enum ActivityTraceFlags {
+        None = 0,
+        Recorded = 1,
+    }
+    public readonly struct ActivityTraceId : IEquatable<ActivityTraceId> {
+        public void CopyTo(Span<byte> destination);
+        public static ActivityTraceId CreateFromBytes(ReadOnlySpan<byte> idData);
+        public static ActivityTraceId CreateFromString(ReadOnlySpan<char> idData);
+        public static ActivityTraceId CreateFromUtf8String(ReadOnlySpan<byte> idData);
+        public static ActivityTraceId CreateRandom();
+        public bool Equals(ActivityTraceId traceId);
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public static bool operator ==(in ActivityTraceId traceId1, in ActivityTraceId traceId2);
+        public static bool operator !=(in ActivityTraceId traceId1, in ActivityTraceId traceId2);
+        public string ToHexString();
+        public override string ToString();
+    }
     public class DiagnosticListener : DiagnosticSource, IDisposable, IObservable<KeyValuePair<string, object>> {
+        public override void OnActivityExport(Activity activity, object payload);
+        public override void OnActivityImport(Activity activity, object payload);
+        public virtual IDisposable Subscribe(IObserver<KeyValuePair<string, object>> observer, Func<string, object, object, bool> isEnabled, Action<Activity, object> onActivityImport = null, Action<Activity, object> onActivityExport = null);
     }
     public abstract class DiagnosticSource {
+        public virtual void OnActivityExport(Activity activity, object payload);
+        public virtual void OnActivityImport(Activity activity, object payload);
     }
 }
```

