# .NET Core SDK 2.1.100

This release is in support of Visual Studio 15.6.2 and contains the previously released [.NET Core 2.0.6 Runtime](2.0.6-download.md).

|         | SDK Installer                                         | SDK Binaries                                                         | Runtime Installer                                                  | Runtime Binaries                                                   |
| ------- | :---------------------------------------------------: | :-------------------------------------------------------------------:| :----------------------------------------------------------------: | :----------------------------------------------------------------: |
| Windows | [32-bit](https://download.microsoft.com/download/2/A/2/2A21B61D-4D08-4E25-AB4A-7B9859300B0C/dotnet-sdk-2.1.100-win-x86.exe) / [64-bit](https://download.microsoft.com/download/2/A/2/2A21B61D-4D08-4E25-AB4A-7B9859300B0C/dotnet-sdk-2.1.100-win-x64.exe)  | [32-bit](https://download.microsoft.com/download/2/A/2/2A21B61D-4D08-4E25-AB4A-7B9859300B0C/dotnet-sdk-2.1.100-win-x86.zip) / [64-bit](https://download.microsoft.com/download/2/A/2/2A21B61D-4D08-4E25-AB4A-7B9859300B0C/dotnet-sdk-2.1.100-win-x64.zip) | [32-bit](https://download.microsoft.com/download/8/D/A/8DA04DA7-565B-4372-BBCE-D44C7809A467/dotnet-runtime-2.0.6-win-x86.exe) / [64-bit](https://download.microsoft.com/download/8/D/A/8DA04DA7-565B-4372-BBCE-D44C7809A467/dotnet-runtime-2.0.6-win-x64.exe) | [32-bit](https://download.microsoft.com/download/8/D/A/8DA04DA7-565B-4372-BBCE-D44C7809A467/dotnet-runtime-2.0.6-win-x86.zip) / [64-bit](https://download.microsoft.com/download/8/D/A/8DA04DA7-565B-4372-BBCE-D44C7809A467/dotnet-runtime-2.0.6-win-x64.zip) |
| macOS   | [64-bit](https://download.microsoft.com/download/2/A/2/2A21B61D-4D08-4E25-AB4A-7B9859300B0C/dotnet-sdk-2.1.100-osx-x64.pkg)  | [64-bit](https://download.microsoft.com/download/2/A/2/2A21B61D-4D08-4E25-AB4A-7B9859300B0C/dotnet-sdk-2.1.100-osx-x64.tar.gz)| [64-bit](https://download.microsoft.com/download/8/D/A/8DA04DA7-565B-4372-BBCE-D44C7809A467/dotnet-runtime-2.0.6-osx-x64.pkg)      | [64-bit](https://download.microsoft.com/download/8/D/A/8DA04DA7-565B-4372-BBCE-D44C7809A467/dotnet-runtime-2.0.6-osx-x64.tar.gz)   |
| Linux * | See installations steps below                         | [64-bit](https://download.microsoft.com/download/2/A/2/2A21B61D-4D08-4E25-AB4A-7B9859300B0C/dotnet-sdk-2.1.100-linux-x64.tar.gz)     | -                                                                  | [64-bit](https://download.microsoft.com/download/8/D/A/8DA04DA7-565B-4372-BBCE-D44C7809A467/dotnet-runtime-2.0.6-linux-x64.tar.gz) |

**Checksum** files to verify downloads are available as follows:
* [Checksums_SDK](https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.100-sdk-sha.txt)

## Installing .NET Core on Linux

### Uninstall any Preview versions

If you have .NET Core Previews installed, it will need to be removed before attempting to install .NET Core 2.0. This can be done by running a command such as the following.

`sudo apt remove dotnet-dev-2.0.0-preview2-006497`

### Ubuntu and Debian based systems

Register the Microsoft key, the product repository for your distro and install required system dependencies with the following scripts.

#### Ubuntu 17.10

```bash
wget -q packages-microsoft-prod.deb https://packages.microsoft.com/config/ubuntu/17.10/packages-microsoft-prod.deb
sudo dpkg -i packages-microsoft-prod.deb
```

#### Ubuntu 16.04

```bash
wget -q packages-microsoft-prod.deb https://packages.microsoft.com/config/ubuntu/16.04/packages-microsoft-prod.deb
sudo dpkg -i packages-microsoft-prod.deb
```

#### Ubuntu 14.04

```bash
wget -q packages-microsoft-prod.deb https://packages.microsoft.com/config/ubuntu/14.04/packages-microsoft-prod.deb
sudo dpkg -i packages-microsoft-prod.deb
```

#### Debian 9

```bash
wget -qO- https://packages.microsoft.com/keys/microsoft.asc | gpg --dearmor > microsoft.asc.gpg
sudo mv microsoft.asc.gpg /etc/apt/trusted.gpg.d/
wget -q https://packages.microsoft.com/config/debian/9/prod.list
sudo mv prod.list /etc/apt/sources.list.d/microsoft-prod.list
```

#### Debian 8

```bash
wget -qO- https://packages.microsoft.com/keys/microsoft.asc | gpg --dearmor > microsoft.asc.gpg
sudo mv microsoft.asc.gpg /etc/apt/trusted.gpg.d/
wget -q https://packages.microsoft.com/config/debian/8/prod.list
sudo mv prod.list /etc/apt/sources.list.d/microsoft-prod.list
 ```

Then, update the package cache and install .NET Core

```bash
sudo apt-get install apt-transport-https
sudo apt-get update
sudo apt-get install dotnet-sdk-2.1.100
```

### RHEL and Fedora based systems

Register the Microsoft key, the product repository for your distro and install required system dependencies with the following scripts.

#### Red Hat, Fedora, CentOS, Oracle Linux

```bash
sudo rpm -Uvh https://packages.microsoft.com/config/rhel/7/packages-microsoft-prod.rpm
```

### SUSE Enterprise Linux, OpenSUSE

#### SUSE Enterprise Linux

```bash
sudo rpm -Uvh https://packages.microsoft.com/config/sles/12/packages-microsoft-prod.rpm
```

#### OpenSUSE

```bash
sudo rpm --import https://packages.microsoft.com/keys/microsoft.asc
wget -q https://packages.microsoft.com/config/opensuse/42.2/prod.repo
sudo mv prod.repo /etc/zypp/repos.d/microsoft-prod.repo
```

Then, update the package cache and install .NET Core

#### Fedora, CentOS and Oracle Linux

```bash
sudo yum update
sudo yum install dotnet-sdk-2.1.100
```

#### SUSE Enterprise Linux and OpenSUSE

```bash
sudo zypper update
sudo zypper install dotnet-sdk-2.1.100
```

**Note:** When installing the SDK, SUSE and OpenSUSE may report that nothing provides libcurl. libcurl should already be installed on supported versions of both distros. Run zypper search libcurl to confirm. The error will present 2 "solutions". Choose "Solution 2" to continue installing .NET Core.

## Installation from a binary archive

Installing from the packages detailed above is recommended and you can also install from binary archive. When using binary archives to install, the contents must be extracted to a user location such as `$HOME/dotnet` and a symbolic link created for `dotnet`.

```bash
mkdir -p $HOME/dotnet && tar zxf dotnet.tar.gz -C $HOME/dotnet
export PATH=$PATH:$HOME/dotnet
```
