# Changelog

## [v0.1.6-alpha.5](https://github.com/ai16z/eliza/tree/v0.1.6-alpha.5) (2024-12-21)

[Full Changelog](https://github.com/ai16z/eliza/compare/v0.1.6-alpha.4...v0.1.6-alpha.5)

**Implemented enhancements:**

- Add @eliza/agent to npm registry [\#1281](https://github.com/ai16z/eliza/issues/1281)
- Implement Redis Caching for Performance [\#1277](https://github.com/ai16z/eliza/issues/1277)
- Improve logging for the Coinbase plugin [\#1261](https://github.com/ai16z/eliza/issues/1261)
- doc: Add Twitter automation label requirement to quickstart guide [\#1253](https://github.com/ai16z/eliza/issues/1253)
- Enhance Logging in /packages/plugin-coinbase/src/plugins Using elizaLogger [\#1192](https://github.com/ai16z/eliza/issues/1192)
- Improve Logging in /packages/plugin-coinbase/src/plugins [\#1189](https://github.com/ai16z/eliza/issues/1189)
- Feat: add github client to core agent [\#1130](https://github.com/ai16z/eliza/issues/1130)

**Fixed bugs:**

- SCAM project [\#1286](https://github.com/ai16z/eliza/issues/1286)
- pnpm start --character="characters/trump.character.json" [\#1161](https://github.com/ai16z/eliza/issues/1161)
- REQUIRED\_NODE\_VERSION: No such file [\#1151](https://github.com/ai16z/eliza/issues/1151)
- Discord agents knock each other out of VC [\#1145](https://github.com/ai16z/eliza/issues/1145)
- Missing required secret OPENAI\_API\_KEY in PR workflow [\#1027](https://github.com/ai16z/eliza/issues/1027)

**Closed issues:**

- Bug: Application crashes on startup [\#1173](https://github.com/ai16z/eliza/issues/1173)
- Bug: Application crashes on startup [\#1172](https://github.com/ai16z/eliza/issues/1172)

**Merged pull requests:**

- fix: default character model to LLAMALOCAL [\#1299](https://github.com/ai16z/eliza/pull/1299) ([shakkernerd](https://github.com/shakkernerd))
- fix: remove clients from default character [\#1297](https://github.com/ai16z/eliza/pull/1297) ([shakkernerd](https://github.com/shakkernerd))
- chore: bump version to 0.1.6-alpha.5 [\#1296](https://github.com/ai16z/eliza/pull/1296) ([shakkernerd](https://github.com/shakkernerd))
- feat: Add caching support for Redis [\#1295](https://github.com/ai16z/eliza/pull/1295) ([shakkernerd](https://github.com/shakkernerd))
- fix: output checkable variable for conditional [\#1294](https://github.com/ai16z/eliza/pull/1294) ([twilwa](https://github.com/twilwa))
- fix: add missing claude vertex case to handleProvider [\#1293](https://github.com/ai16z/eliza/pull/1293) ([shakkernerd](https://github.com/shakkernerd))
- fix: pnpm lock file [\#1292](https://github.com/ai16z/eliza/pull/1292) ([shakkernerd](https://github.com/shakkernerd))
- fix: integration tests fix [\#1291](https://github.com/ai16z/eliza/pull/1291) ([twilwa](https://github.com/twilwa))
- feat: Update main for v0.1.6-alpha.5 [\#1290](https://github.com/ai16z/eliza/pull/1290) ([odilitime](https://github.com/odilitime))
- chore: clean up merged PR1168 [\#1289](https://github.com/ai16z/eliza/pull/1289) ([odilitime](https://github.com/odilitime))
- fix: fix lockfile [\#1283](https://github.com/ai16z/eliza/pull/1283) ([odilitime](https://github.com/odilitime))
- feat: Redis Cache Implementation [\#1279](https://github.com/ai16z/eliza/pull/1279) ([shakkernerd](https://github.com/shakkernerd))
- chore: Revert "fix: pnpm lockfile" [\#1275](https://github.com/ai16z/eliza/pull/1275) ([shakkernerd](https://github.com/shakkernerd))
- fix: pnpm lockfile [\#1273](https://github.com/ai16z/eliza/pull/1273) ([shakkernerd](https://github.com/shakkernerd))
- fix: fix ENABLE\_ACTION\_PROCESSING logic [\#1268](https://github.com/ai16z/eliza/pull/1268) ([oxSaturn](https://github.com/oxSaturn))
- feat: add README\_DE.md in docs directory [\#1262](https://github.com/ai16z/eliza/pull/1262) ([derRizzMeister](https://github.com/derRizzMeister))
- fix: unsupported model provider: claude\_vertex [\#1258](https://github.com/ai16z/eliza/pull/1258) ([tcm390](https://github.com/tcm390))
- doc: add Twitter automation label notice \(\#1253\) [\#1254](https://github.com/ai16z/eliza/pull/1254) ([julienbrs](https://github.com/julienbrs))
- Update trump.character.json [\#1252](https://github.com/ai16z/eliza/pull/1252) ([lalalune](https://github.com/lalalune))
- fix: Fix local\_llama key warning [\#1250](https://github.com/ai16z/eliza/pull/1250) ([odilitime](https://github.com/odilitime))
- feat: upgrade Tavily API with comprehensive input and constrain the token consumption [\#1246](https://github.com/ai16z/eliza/pull/1246) ([tomguluson92](https://github.com/tomguluson92))
- feat: make express payload limit configurable [\#1245](https://github.com/ai16z/eliza/pull/1245) ([renlulu](https://github.com/renlulu))
- feat: make twitter login retry times as env [\#1244](https://github.com/ai16z/eliza/pull/1244) ([renlulu](https://github.com/renlulu))
- Fix visibility issue github image cicd [\#1243](https://github.com/ai16z/eliza/pull/1243) ([luisalrp](https://github.com/luisalrp))
- fix: twitterShouldRespondTemplate Fails When Defined as a String in JSON Character Config [\#1242](https://github.com/ai16z/eliza/pull/1242) ([tcm390](https://github.com/tcm390))
- fix: Sync UI Client with server port env [\#1239](https://github.com/ai16z/eliza/pull/1239) ([jonathangus](https://github.com/jonathangus))
- Update trump.character.json - Enhance terminology in the project for clarity and inclusivity [\#1237](https://github.com/ai16z/eliza/pull/1237) ([yjshi2015](https://github.com/yjshi2015))
- Update README for french, spanish and italian language [\#1236](https://github.com/ai16z/eliza/pull/1236) ([azurwastaken](https://github.com/azurwastaken))
- feat: add parse mode=Markdown, enhance telegram bot output [\#1229](https://github.com/ai16z/eliza/pull/1229) ([simpletrontdip](https://github.com/simpletrontdip))
- fix: CircuitBreaker.ts [\#1226](https://github.com/ai16z/eliza/pull/1226) ([tomguluson92](https://github.com/tomguluson92))
- fix: Allow the bot to post messages with images generated by the imageGenerationPlugin on Telegram. [\#1220](https://github.com/ai16z/eliza/pull/1220) ([tcm390](https://github.com/tcm390))
- fix: postgres needs the user to exist before you can add a participant [\#1219](https://github.com/ai16z/eliza/pull/1219) ([odilitime](https://github.com/odilitime))
- chore: clean up scripts [\#1218](https://github.com/ai16z/eliza/pull/1218) ([danbednarski](https://github.com/danbednarski))
- fix: improve twitter post generation prompt [\#1217](https://github.com/ai16z/eliza/pull/1217) ([cygaar](https://github.com/cygaar))
- fix: fail when cannot get token, add Akash to generateText switch [\#1214](https://github.com/ai16z/eliza/pull/1214) ([vpavlin](https://github.com/vpavlin))
- chore: New docs [\#1211](https://github.com/ai16z/eliza/pull/1211) ([madjin](https://github.com/madjin))
- docs: Update README.md [\#1209](https://github.com/ai16z/eliza/pull/1209) ([marcNY](https://github.com/marcNY))
- fix: gitpod cicd bug [\#1207](https://github.com/ai16z/eliza/pull/1207) ([v1xingyue](https://github.com/v1xingyue))
- fix: write summary file before trying to cache it [\#1205](https://github.com/ai16z/eliza/pull/1205) ([tobbelobb](https://github.com/tobbelobb))
- fix: optional chaining on search to avoid startup errors when search is not enabled [\#1202](https://github.com/ai16z/eliza/pull/1202) ([netdragonx](https://github.com/netdragonx))
- docs\(cn\): add python 3.7 [\#1201](https://github.com/ai16z/eliza/pull/1201) ([9547](https://github.com/9547))
- docs: Update "CN README" with more details [\#1196](https://github.com/ai16z/eliza/pull/1196) ([tomguluson92](https://github.com/tomguluson92))
- docs: fixed CONTRIBUTING.md file Issue: 1048 [\#1191](https://github.com/ai16z/eliza/pull/1191) ([ileana-pr](https://github.com/ileana-pr))
- test: adding tests for runtime.ts. Modified README since we switched to vitest [\#1190](https://github.com/ai16z/eliza/pull/1190) ([ai16z-demirix](https://github.com/ai16z-demirix))
- fix: Fix client.push issue and update README for Slack client verification [\#1182](https://github.com/ai16z/eliza/pull/1182) ([SumeetChougule](https://github.com/SumeetChougule))
- feat: integration tests fixes + library improvements [\#1177](https://github.com/ai16z/eliza/pull/1177) ([jzvikart](https://github.com/jzvikart))
- docs: Update "What Did You Get Done This Week? 5" spaces notes [\#1174](https://github.com/ai16z/eliza/pull/1174) ([YoungPhlo](https://github.com/YoungPhlo))
- fix: Fix typo in multiversx plugin prompt for creating token [\#1170](https://github.com/ai16z/eliza/pull/1170) ([thomasWos](https://github.com/thomasWos))
- feat: make script dash compatible [\#1165](https://github.com/ai16z/eliza/pull/1165) ([shakkernerd](https://github.com/shakkernerd))
- chore: print commands to start the client and remove unused --non-itera… [\#1163](https://github.com/ai16z/eliza/pull/1163) ([yang-han](https://github.com/yang-han))
- fix: Enable multiple bots to join Discord voice channels [\#1156](https://github.com/ai16z/eliza/pull/1156) ([tcm390](https://github.com/tcm390))

## [v0.1.6-alpha.4](https://github.com/ai16z/eliza/tree/v0.1.6-alpha.4) (2024-12-17)

[Full Changelog](https://github.com/ai16z/eliza/compare/v0.1.6-alpha.3...v0.1.6-alpha.4)

**Fixed bugs:**

- pnpm install fails on m1 mac \[Fixed with xcode-select reinstall\] [\#1146](https://github.com/ai16z/eliza/issues/1146)

**Merged pull requests:**

- chore: bump version to 0.1.6-alpha.4 [\#1159](https://github.com/ai16z/eliza/pull/1159) ([shakkernerd](https://github.com/shakkernerd))
- fix: client twitter login and auth handler [\#1158](https://github.com/ai16z/eliza/pull/1158) ([shakkernerd](https://github.com/shakkernerd))

## [v0.1.6-alpha.3](https://github.com/ai16z/eliza/tree/v0.1.6-alpha.3) (2024-12-17)

[Full Changelog](https://github.com/ai16z/eliza/compare/v0.1.6-alpha.2...v0.1.6-alpha.3)

**Merged pull requests:**

- chore: develop into main [\#1155](https://github.com/ai16z/eliza/pull/1155) ([shakkernerd](https://github.com/shakkernerd))
- fix: fix direct-client ability to start agents [\#1154](https://github.com/ai16z/eliza/pull/1154) ([odilitime](https://github.com/odilitime))
- fix: fetch log level to debug [\#1153](https://github.com/ai16z/eliza/pull/1153) ([shakkernerd](https://github.com/shakkernerd))
- chore: bump version to 0.1.6-alpha.3 [\#1152](https://github.com/ai16z/eliza/pull/1152) ([shakkernerd](https://github.com/shakkernerd))
- feat: update packages version script [\#1150](https://github.com/ai16z/eliza/pull/1150) ([shakkernerd](https://github.com/shakkernerd))

## [v0.1.6-alpha.2](https://github.com/ai16z/eliza/tree/v0.1.6-alpha.2) (2024-12-17)

[Full Changelog](https://github.com/ai16z/eliza/compare/v0.1.6-alpha.1...v0.1.6-alpha.2)

**Implemented enhancements:**

- Add a Hebrew Translation for the readme. [\#1022](https://github.com/ai16z/eliza/issues/1022)
- GenLayer Plugin [\#972](https://github.com/ai16z/eliza/issues/972)
- Feature Request: Add Aptos and Move Support to the Eliza Framework for Autonomous Agents [\#790](https://github.com/ai16z/eliza/issues/790)
- enhancement: Improve message threading and handling to reduce repetition [\#783](https://github.com/ai16z/eliza/issues/783)
- fal.ai image generation [\#648](https://github.com/ai16z/eliza/issues/648)
- Upgrade to turborepo for monorepo management [\#639](https://github.com/ai16z/eliza/issues/639)
- Add a plugin for storing data using the 0G protocol. [\#415](https://github.com/ai16z/eliza/issues/415)
- way for bots to have cool down periods \(dynamic tempature adjusts\) & only direct reply setting [\#399](https://github.com/ai16z/eliza/issues/399)
- Create an Eliza Trained on Dev Documentation [\#352](https://github.com/ai16z/eliza/issues/352)
- Get to a place where we can reliably create release tags [\#317](https://github.com/ai16z/eliza/issues/317)
- Managing Divergence Across the Eliza Ecosystem \(Multiple Forks\) [\#305](https://github.com/ai16z/eliza/issues/305)
- EVM Integration [\#303](https://github.com/ai16z/eliza/issues/303)
- Farcaster Client / Plugin [\#300](https://github.com/ai16z/eliza/issues/300)
- Allow twitter client to configure who to reply to based on following relationship [\#264](https://github.com/ai16z/eliza/issues/264)
- Agent is reposting images from other parts of conversation as its own image [\#260](https://github.com/ai16z/eliza/issues/260)
- Fix queueing in Twitter so messages are not rate limited constantly [\#259](https://github.com/ai16z/eliza/issues/259)
- Fix Twitter Multi-agent, Characters respond to each other's messages [\#258](https://github.com/ai16z/eliza/issues/258)
- Add shouldRespond handler to voice [\#244](https://github.com/ai16z/eliza/issues/244)
- Move cache to database [\#243](https://github.com/ai16z/eliza/issues/243)
- Store all local models in /models folder, with overridable model path [\#242](https://github.com/ai16z/eliza/issues/242)
- Add storeCredential and getCredential key value store, store secrets in db [\#241](https://github.com/ai16z/eliza/issues/241)
- Move embeddings to a service and a service and add ServiceType.EMBEDDING [\#240](https://github.com/ai16z/eliza/issues/240)
- Fix function calling, repetition and local action calling [\#161](https://github.com/ai16z/eliza/issues/161)
- Make image generation very nice and spicy [\#158](https://github.com/ai16z/eliza/issues/158)
- Add AI Code Reviewing application from GitHub Marketplace [\#81](https://github.com/ai16z/eliza/issues/81)
- Abstract image descriptions / recognition to use any model provider [\#72](https://github.com/ai16z/eliza/issues/72)
- 💡 Have silly tavern compatibility [\#56](https://github.com/ai16z/eliza/issues/56)
- User Interface Enhancement [\#54](https://github.com/ai16z/eliza/issues/54)
- "Private" Actions [\#29](https://github.com/ai16z/eliza/issues/29)
- Pump Fun Token Creation [\#28](https://github.com/ai16z/eliza/issues/28)
- Awareness of Twitter bio and username [\#27](https://github.com/ai16z/eliza/issues/27)

**Fixed bugs:**

- pnpm install updates pnpm lockfile when it should not [\#1121](https://github.com/ai16z/eliza/issues/1121)
- Not respecting OpenAI model selection [\#1105](https://github.com/ai16z/eliza/issues/1105)
- Scrapper login [\#1066](https://github.com/ai16z/eliza/issues/1066)
- code2prompt Not Functioning with WSL [\#1060](https://github.com/ai16z/eliza/issues/1060)
- Unexpected token 'A', "Agent not found" is not valid JSON [\#1059](https://github.com/ai16z/eliza/issues/1059)
- bug: setting auto in character file fails to load client-auto [\#1049](https://github.com/ai16z/eliza/issues/1049)
- TypeError - LinkedIn constructor error [\#990](https://github.com/ai16z/eliza/issues/990)
- Twitter/X Cache Login not staying logged in [\#939](https://github.com/ai16z/eliza/issues/939)
- Can't start project. Got `ERR_PNPM_RECURSIVE_RUN_FIRST_FAIL` error [\#925](https://github.com/ai16z/eliza/issues/925)
- Client Twitter Login issue: Error: {"errors":\[{"code":399,"message":"Incorrect. Please try again."}\]} [\#905](https://github.com/ai16z/eliza/issues/905)
- Implement Retry Mechanism for Twitter Login with Cookie Validation [\#855](https://github.com/ai16z/eliza/issues/855)
- How to deal with Twitter login issues [\#841](https://github.com/ai16z/eliza/issues/841)
- This command: pnpm start --characters="characters/tate.character.json" results in an error [\#817](https://github.com/ai16z/eliza/issues/817)
- Characters Do Not Actually Use ExamplePost or ExampleMessage [\#791](https://github.com/ai16z/eliza/issues/791)
- `pnpm run dev` does not work out of the box [\#780](https://github.com/ai16z/eliza/issues/780)
- Agent Responds Twice to prompts [\#726](https://github.com/ai16z/eliza/issues/726)
- Twitter Client Breaks out of the box [\#673](https://github.com/ai16z/eliza/issues/673)
- Twitter client only works for one agent when running multiple agents simultaneously [\#656](https://github.com/ai16z/eliza/issues/656)
- Cannot find module '@ai16z/eliza' or its corresponding type declarations. [\#601](https://github.com/ai16z/eliza/issues/601)
- create-eliza-app package doesn't install or exist [\#553](https://github.com/ai16z/eliza/issues/553)
- Non node.js environments have issues building \(workers for instance\) [\#507](https://github.com/ai16z/eliza/issues/507)
- Error: Property 'clients' does not exist on type 'Plugin' in src/index.ts during pnpm start [\#423](https://github.com/ai16z/eliza/issues/423)
- using Groq API \(or RedPill or Google Gen AI\) as model provider [\#422](https://github.com/ai16z/eliza/issues/422)
-  Error when starting Eliza agent: "fs.Stats constructor is deprecated" and "triggerUncaughtException" [\#387](https://github.com/ai16z/eliza/issues/387)
- no action response found in the response content for twitter or tg clients [\#319](https://github.com/ai16z/eliza/issues/319)
- Docs improvements bounty ideas [\#298](https://github.com/ai16z/eliza/issues/298)
- Quickstart guide is missing important info [\#284](https://github.com/ai16z/eliza/issues/284)
- advanced usage section of docs doesn't include instructions for memory management [\#275](https://github.com/ai16z/eliza/issues/275)
- On PNPM Install this happens [\#237](https://github.com/ai16z/eliza/issues/237)
- twitter folder paths for twitter cookies & cache/last tweet point to different places [\#230](https://github.com/ai16z/eliza/issues/230)
- pnpm install fails on Ubuntu [\#215](https://github.com/ai16z/eliza/issues/215)
- Knowledge system is disabled [\#164](https://github.com/ai16z/eliza/issues/164)
- LLM can't be trusted to parse it's own json [\#148](https://github.com/ai16z/eliza/issues/148)

**Closed issues:**

- Update totalMessages Logic in Boredom Scoring [\#408](https://github.com/ai16z/eliza/issues/408)
- Tests are failing [\#64](https://github.com/ai16z/eliza/issues/64)

**Merged pull requests:**

- chore: fix PR \#1147 [\#1148](https://github.com/ai16z/eliza/pull/1148) ([odilitime](https://github.com/odilitime))
- fix: improve fomo integration [\#1147](https://github.com/ai16z/eliza/pull/1147) ([odilitime](https://github.com/odilitime))
- chore: Merge monday, merging develop into main [\#1144](https://github.com/ai16z/eliza/pull/1144) ([odilitime](https://github.com/odilitime))
- chore: remove comment [\#1143](https://github.com/ai16z/eliza/pull/1143) ([shakkernerd](https://github.com/shakkernerd))
- clean newlines for new tweet [\#1141](https://github.com/ai16z/eliza/pull/1141) ([owlcode](https://github.com/owlcode))
- fix: telegram client duplicate function removal [\#1140](https://github.com/ai16z/eliza/pull/1140) ([azep-ninja](https://github.com/azep-ninja))
- fix: remove docker compose command since Docker file already runs [\#1139](https://github.com/ai16z/eliza/pull/1139) ([rarepepi](https://github.com/rarepepi))
- feat: add support for handlebars templating engine as an option [\#1136](https://github.com/ai16z/eliza/pull/1136) ([erise133](https://github.com/erise133))
- feat: allow agents to create/buy/sell tokens on FOMO.fund's bonding curve in plugin-solana [\#1135](https://github.com/ai16z/eliza/pull/1135) ([0xNerd](https://github.com/0xNerd))
- fix: fix the name [\#1133](https://github.com/ai16z/eliza/pull/1133) ([n00b21337](https://github.com/n00b21337))
- feat: Add `chatapi.akash.network` to available list of model providers \(FREE LLAMA API ACCESS!\) [\#1131](https://github.com/ai16z/eliza/pull/1131) ([MbBrainz](https://github.com/MbBrainz))
- fix: discord client duplicate function removal [\#1125](https://github.com/ai16z/eliza/pull/1125) ([azep-ninja](https://github.com/azep-ninja))
- fix: add more heplful default agents \(Dobby and C3PO\) [\#1124](https://github.com/ai16z/eliza/pull/1124) ([n00b21337](https://github.com/n00b21337))
- fix: Refactor to prevent unnecessary lockfile changes [\#1120](https://github.com/ai16z/eliza/pull/1120) ([monilpat](https://github.com/monilpat))
- chore: fix broken pnpm lockfile [\#1115](https://github.com/ai16z/eliza/pull/1115) ([shakkernerd](https://github.com/shakkernerd))
- feat: New docs for community section [\#1114](https://github.com/ai16z/eliza/pull/1114) ([madjin](https://github.com/madjin))
- fix: Revert "Feat: Update community section of docs" [\#1112](https://github.com/ai16z/eliza/pull/1112) ([monilpat](https://github.com/monilpat))
- Feat: Update community section of docs [\#1111](https://github.com/ai16z/eliza/pull/1111) ([madjin](https://github.com/madjin))
- Documentation: Plugin list numbering and titles [\#1107](https://github.com/ai16z/eliza/pull/1107) ([brunocalmels](https://github.com/brunocalmels))
- fix: add missing imports [\#1104](https://github.com/ai16z/eliza/pull/1104) ([shakkernerd](https://github.com/shakkernerd))
- chore: fix broken pnpm lockfile [\#1103](https://github.com/ai16z/eliza/pull/1103) ([shakkernerd](https://github.com/shakkernerd))
- fix: handle no termination message [\#1102](https://github.com/ai16z/eliza/pull/1102) ([shakkernerd](https://github.com/shakkernerd))
- feat: Smoke Test script [\#1101](https://github.com/ai16z/eliza/pull/1101) ([shakkernerd](https://github.com/shakkernerd))
- feat: Lens client [\#1098](https://github.com/ai16z/eliza/pull/1098) ([imthatcarlos](https://github.com/imthatcarlos))
- fix: return types of createAgent & startAgent [\#1097](https://github.com/ai16z/eliza/pull/1097) ([BlockJuic3](https://github.com/BlockJuic3))
- docs: add README.md to plugin-evm [\#1095](https://github.com/ai16z/eliza/pull/1095) ([nicky-ru](https://github.com/nicky-ru))
- chore: debugging start behaviour [\#1094](https://github.com/ai16z/eliza/pull/1094) ([shakkernerd](https://github.com/shakkernerd))
- chore: kill pnpm start [\#1093](https://github.com/ai16z/eliza/pull/1093) ([shakkernerd](https://github.com/shakkernerd))
- chore: increase timeout to 3mins [\#1092](https://github.com/ai16z/eliza/pull/1092) ([shakkernerd](https://github.com/shakkernerd))
- feat: allow users to configure models for grok [\#1091](https://github.com/ai16z/eliza/pull/1091) ([oxSaturn](https://github.com/oxSaturn))
- fix: syntax error: invalid arithmetic operator [\#1088](https://github.com/ai16z/eliza/pull/1088) ([shakkernerd](https://github.com/shakkernerd))
- fix: client slack linting errors [\#1086](https://github.com/ai16z/eliza/pull/1086) ([shakkernerd](https://github.com/shakkernerd))
- chore: remove unused imports and rename runtime variable [\#1085](https://github.com/ai16z/eliza/pull/1085) ([shakkernerd](https://github.com/shakkernerd))
- fix: dynamic import of fs module [\#1084](https://github.com/ai16z/eliza/pull/1084) ([shakkernerd](https://github.com/shakkernerd))
- chore: remove unnecessary packages [\#1083](https://github.com/ai16z/eliza/pull/1083) ([shakkernerd](https://github.com/shakkernerd))
- fix: eslint command [\#1082](https://github.com/ai16z/eliza/pull/1082) ([shakkernerd](https://github.com/shakkernerd))
- chore: fix broken pnpm lockfile [\#1081](https://github.com/ai16z/eliza/pull/1081) ([shakkernerd](https://github.com/shakkernerd))
- chore: add npmignore file [\#1080](https://github.com/ai16z/eliza/pull/1080) ([shakkernerd](https://github.com/shakkernerd))
- fix: transfer action linting errors [\#1079](https://github.com/ai16z/eliza/pull/1079) ([shakkernerd](https://github.com/shakkernerd))
- fix: errors in swap action in plugin-near [\#1078](https://github.com/ai16z/eliza/pull/1078) ([shakkernerd](https://github.com/shakkernerd))
- fix: remove unnecessary devDependencies [\#1077](https://github.com/ai16z/eliza/pull/1077) ([shakkernerd](https://github.com/shakkernerd))
- fix: missing eslint config file [\#1076](https://github.com/ai16z/eliza/pull/1076) ([shakkernerd](https://github.com/shakkernerd))
- fix: remove unnecessary devDependencies [\#1075](https://github.com/ai16z/eliza/pull/1075) ([shakkernerd](https://github.com/shakkernerd))
- fix: incorrect eslint config file path [\#1074](https://github.com/ai16z/eliza/pull/1074) ([shakkernerd](https://github.com/shakkernerd))
- chore: commented out unused variables in solana swap action's plugin [\#1073](https://github.com/ai16z/eliza/pull/1073) ([shakkernerd](https://github.com/shakkernerd))
- fix: Fixed twitter posts include from including `/n` in the text [\#1070](https://github.com/ai16z/eliza/pull/1070) ([Titan-Node](https://github.com/Titan-Node))
- feat: create README\_VI.md [\#1058](https://github.com/ai16z/eliza/pull/1058) ([tqdpham96](https://github.com/tqdpham96))
- feat: add venice.ai image generation [\#1057](https://github.com/ai16z/eliza/pull/1057) ([proteanx](https://github.com/proteanx))
- chore: improve eslint by --cache [\#1056](https://github.com/ai16z/eliza/pull/1056) ([shengxj1](https://github.com/shengxj1))
- fix: Fix pnpm lockfiles [\#1055](https://github.com/ai16z/eliza/pull/1055) ([jzvikart](https://github.com/jzvikart))
- fix: discord client ci issues [\#1054](https://github.com/ai16z/eliza/pull/1054) ([cygaar](https://github.com/cygaar))
- Update docs \(CONTRIBUTING.md\) [\#1053](https://github.com/ai16z/eliza/pull/1053) ([lessuselesss](https://github.com/lessuselesss))
- feat: add/change change through REST api \(client-direct\) [\#1052](https://github.com/ai16z/eliza/pull/1052) ([odilitime](https://github.com/odilitime))
- fix: add auto to clients in types to use client-auto [\#1050](https://github.com/ai16z/eliza/pull/1050) ([HashWarlock](https://github.com/HashWarlock))
- chore: improve smokeTests environment validation and logging [\#1046](https://github.com/ai16z/eliza/pull/1046) ([aramxc](https://github.com/aramxc))
- fix: Allow bot to post tweets with images generated by the imageGenerationPlugin [\#1040](https://github.com/ai16z/eliza/pull/1040) ([tcm390](https://github.com/tcm390))
- feat: add plugin-ton [\#1039](https://github.com/ai16z/eliza/pull/1039) ([jinbangyi](https://github.com/jinbangyi))
- chore: improving client typing [\#1036](https://github.com/ai16z/eliza/pull/1036) ([BalanaguYashwanth](https://github.com/BalanaguYashwanth))
- feat: add README\_TH.md in docs directory [\#1034](https://github.com/ai16z/eliza/pull/1034) ([derRizzMeister](https://github.com/derRizzMeister))
- feat: Add Telegram Team features  [\#1033](https://github.com/ai16z/eliza/pull/1033) ([azep-ninja](https://github.com/azep-ninja))
- chore: Update package.json [\#1031](https://github.com/ai16z/eliza/pull/1031) ([Freytes](https://github.com/Freytes))
- feat: plugin-story [\#1030](https://github.com/ai16z/eliza/pull/1030) ([jacob-tucker](https://github.com/jacob-tucker))
- feat: Add plugin-nft-generation: create Solana NFT collections. [\#1011](https://github.com/ai16z/eliza/pull/1011) ([xwxtwd](https://github.com/xwxtwd))
- test: adding tests. changed files actions.test.ts, messages.test.ts, models.test.ts [\#998](https://github.com/ai16z/eliza/pull/998) ([ai16z-demirix](https://github.com/ai16z-demirix))
- fix: Fix Parameter Parsing in plugin-evm TransferAction and Return Transaction Hash [\#965](https://github.com/ai16z/eliza/pull/965) ([FWangZil](https://github.com/FWangZil))
- feat: Updated characters types, Discord & Telegram enhancements [\#957](https://github.com/ai16z/eliza/pull/957) ([azep-ninja](https://github.com/azep-ninja))
- feat: add plugin-sui [\#934](https://github.com/ai16z/eliza/pull/934) ([jnaulty](https://github.com/jnaulty))
- Adding plugin for ZKsync Era [\#906](https://github.com/ai16z/eliza/pull/906) ([arose00](https://github.com/arose00))
- chore: improve formatting of .env.example for better readability [\#897](https://github.com/ai16z/eliza/pull/897) ([guzus](https://github.com/guzus))
- feat: multiversx plugin [\#860](https://github.com/ai16z/eliza/pull/860) ([mgavrila](https://github.com/mgavrila))
- Add slack plugin [\#859](https://github.com/ai16z/eliza/pull/859) ([AIFlowML](https://github.com/AIFlowML))
- feat: improve X/Twitter login with cookie validation and retry mechanism [\#856](https://github.com/ai16z/eliza/pull/856) ([arslanaybars](https://github.com/arslanaybars))
- Fix/charity [\#852](https://github.com/ai16z/eliza/pull/852) ([awidearray](https://github.com/awidearray))
- feat: Add NEAR Protocol plugin [\#847](https://github.com/ai16z/eliza/pull/847) ([serrrfirat](https://github.com/serrrfirat))
- fix: load image from diff endpoints [\#837](https://github.com/ai16z/eliza/pull/837) ([qgpcybs](https://github.com/qgpcybs))
- FAL image settings escape hatch [\#814](https://github.com/ai16z/eliza/pull/814) ([daojonesceo](https://github.com/daojonesceo))

## [v0.1.6-alpha.1](https://github.com/ai16z/eliza/tree/v0.1.6-alpha.1) (2024-12-13)

[Full Changelog](https://github.com/ai16z/eliza/compare/v0.1.5-alpha.5...v0.1.6-alpha.1)

**Implemented enhancements:**

- Add Venice.ai Model Provider [\#1016](https://github.com/ai16z/eliza/issues/1016)
- Need to add media file upload for posting tweets with image from imageGenerationPlugin. Currently only discord has this implemented [\#969](https://github.com/ai16z/eliza/issues/969)
- Script to create core memories for the agent [\#967](https://github.com/ai16z/eliza/issues/967)
- feat: add hot-reloading for agent dependencies [\#930](https://github.com/ai16z/eliza/issues/930)
- Improve `dev.sh` Script to Enhance Plugin Development Workflow [\#888](https://github.com/ai16z/eliza/issues/888)

**Fixed bugs:**

- How to set the model class for Anthropic? [\#988](https://github.com/ai16z/eliza/issues/988)
- Twitter Search Client Broken [\#943](https://github.com/ai16z/eliza/issues/943)
- Stuck querying when @'ing it in Discord [\#921](https://github.com/ai16z/eliza/issues/921)
- Error pnpm start - Promise.withResolvers\(\): pdfjs-dist [\#902](https://github.com/ai16z/eliza/issues/902)
- Running tests on start and dev? [\#893](https://github.com/ai16z/eliza/issues/893)
- build:  eliza docs build creates 130 files that want to be modified/added to git [\#849](https://github.com/ai16z/eliza/issues/849)
- EVM Plugin can't run any action [\#735](https://github.com/ai16z/eliza/issues/735)
- Bug: plugin-solana crash report [\#467](https://github.com/ai16z/eliza/issues/467)

**Closed issues:**

- Issue: Unable to Post Tweets Using Eliza Integration with Twitter via Cookies or OAuth2 [\#901](https://github.com/ai16z/eliza/issues/901)

**Merged pull requests:**

- chore: release develop into main [\#1045](https://github.com/ai16z/eliza/pull/1045) ([odilitime](https://github.com/odilitime))
- fix: re-enable generateNewTweetLoop / lint fixes [\#1043](https://github.com/ai16z/eliza/pull/1043) ([odilitime](https://github.com/odilitime))
- docs: characterfile.md docs outdated with latest eliza version [\#1042](https://github.com/ai16z/eliza/pull/1042) ([tqdpham96](https://github.com/tqdpham96))
- feat: Add AI Agent Dev School Tutorial Link [\#1038](https://github.com/ai16z/eliza/pull/1038) ([lalalune](https://github.com/lalalune))
- fix: use pull\_request\_target for integration tests [\#1035](https://github.com/ai16z/eliza/pull/1035) ([jnaulty](https://github.com/jnaulty))
- feat: Add Discord Team features [\#1032](https://github.com/ai16z/eliza/pull/1032) ([azep-ninja](https://github.com/azep-ninja))
- feat: client-discord stop implementation / agent improvements [\#1029](https://github.com/ai16z/eliza/pull/1029) ([odilitime](https://github.com/odilitime))
- chore: Push Develop into Main [\#1028](https://github.com/ai16z/eliza/pull/1028) ([odilitime](https://github.com/odilitime))
- feat: improve voice processing and add deepgram transcription option [\#1026](https://github.com/ai16z/eliza/pull/1026) ([tcm390](https://github.com/tcm390))
- docs: Update README.md [\#1025](https://github.com/ai16z/eliza/pull/1025) ([sergical](https://github.com/sergical))
- docs: Update README.md [\#1024](https://github.com/ai16z/eliza/pull/1024) ([sergical](https://github.com/sergical))
- chore: Twitter fetchHomeTimeline rework [\#1021](https://github.com/ai16z/eliza/pull/1021) ([odilitime](https://github.com/odilitime))
- chore: Update CI configuration to enable test coverage and add covera… [\#1019](https://github.com/ai16z/eliza/pull/1019) ([snobbee](https://github.com/snobbee))
- docs: "AI Agent Dev School Part 4" livestream notes [\#1015](https://github.com/ai16z/eliza/pull/1015) ([YoungPhlo](https://github.com/YoungPhlo))
- docs: Add templates documentation to the project [\#1013](https://github.com/ai16z/eliza/pull/1013) ([Lukapetro](https://github.com/Lukapetro))
- feat: Add custom fetch logic for agent [\#1010](https://github.com/ai16z/eliza/pull/1010) ([v1xingyue](https://github.com/v1xingyue))
- feat: Plugin evm multichain [\#1009](https://github.com/ai16z/eliza/pull/1009) ([nicky-ru](https://github.com/nicky-ru))
- feat: add venice.ai api model provider [\#1008](https://github.com/ai16z/eliza/pull/1008) ([proteanx](https://github.com/proteanx))
- feat: improve Twitter client with action processing [\#1007](https://github.com/ai16z/eliza/pull/1007) ([dorianjanezic](https://github.com/dorianjanezic))
- chore: Bring Develop up to date with HEAD [\#1006](https://github.com/ai16z/eliza/pull/1006) ([odilitime](https://github.com/odilitime))
- feat: create example folder with example plugin [\#1004](https://github.com/ai16z/eliza/pull/1004) ([monilpat](https://github.com/monilpat))
- chore: Twitter search switch [\#1003](https://github.com/ai16z/eliza/pull/1003) ([odilitime](https://github.com/odilitime))
- fix: add callback to action in farcaster client [\#1002](https://github.com/ai16z/eliza/pull/1002) ([sin-bufan](https://github.com/sin-bufan))
- fix: typo initialize [\#1000](https://github.com/ai16z/eliza/pull/1000) ([cryptofish7](https://github.com/cryptofish7))
- feat: allow users to configure models for openai and anthropic [\#999](https://github.com/ai16z/eliza/pull/999) ([oxSaturn](https://github.com/oxSaturn))
- add echochambers [\#997](https://github.com/ai16z/eliza/pull/997) ([savageops](https://github.com/savageops))
- test: adding parsing tests. changed files parsing.test.ts [\#996](https://github.com/ai16z/eliza/pull/996) ([ai16z-demirix](https://github.com/ai16z-demirix))
- feat: create README\_DE.md [\#995](https://github.com/ai16z/eliza/pull/995) ([GottliebFreudenreich](https://github.com/GottliebFreudenreich))
- fix: Fix Twitter Search Logic and Add Galadriel Image Model [\#994](https://github.com/ai16z/eliza/pull/994) ([dontAskVI](https://github.com/dontAskVI))
- test: Initial release of smoke/integration tests + testing framework [\#993](https://github.com/ai16z/eliza/pull/993) ([jzvikart](https://github.com/jzvikart))
- fix: a typo in characterfile.md [\#986](https://github.com/ai16z/eliza/pull/986) ([oxSaturn](https://github.com/oxSaturn))
- fix: Goat Plugin + AWS S3 Service error when env vars absent [\#985](https://github.com/ai16z/eliza/pull/985) ([jnaulty](https://github.com/jnaulty))
- docs: add WSL Setup Guide to documentation  [\#983](https://github.com/ai16z/eliza/pull/983) ([ileana-pr](https://github.com/ileana-pr))
- fix: docker trying to filter out missing docs package [\#978](https://github.com/ai16z/eliza/pull/978) ([odilitime](https://github.com/odilitime))
- chore: fix broken lockfile [\#977](https://github.com/ai16z/eliza/pull/977) ([shakkernerd](https://github.com/shakkernerd))
- chore: add how to startup chat ui [\#976](https://github.com/ai16z/eliza/pull/976) ([yodamaster726](https://github.com/yodamaster726))
- feat: Add hyperbolic env vars to override model class [\#974](https://github.com/ai16z/eliza/pull/974) ([meppsilon](https://github.com/meppsilon))
- LinkedIn Client [\#973](https://github.com/ai16z/eliza/pull/973) ([bkellgren](https://github.com/bkellgren))
- Fix farcaster client process action issue [\#963](https://github.com/ai16z/eliza/pull/963) ([sin-bufan](https://github.com/sin-bufan))
- fix\(agent\): correct EVM plugin activation condition [\#962](https://github.com/ai16z/eliza/pull/962) ([0xAsten](https://github.com/0xAsten))
- fix: use MAX\_TWEET\_LENGTH from setting [\#960](https://github.com/ai16z/eliza/pull/960) ([oxSaturn](https://github.com/oxSaturn))
- fix: Revert "docs: add WSL installation guide" [\#959](https://github.com/ai16z/eliza/pull/959) ([monilpat](https://github.com/monilpat))
- feat: add dev script to plugin-aptos [\#956](https://github.com/ai16z/eliza/pull/956) ([asianviking](https://github.com/asianviking))
- chore: rename intiface plugin [\#955](https://github.com/ai16z/eliza/pull/955) ([odilitime](https://github.com/odilitime))
- fix: revert llamacloud endpoint change [\#954](https://github.com/ai16z/eliza/pull/954) ([odilitime](https://github.com/odilitime))
- feat: allow character.json settings models for open router [\#953](https://github.com/ai16z/eliza/pull/953) ([odilitime](https://github.com/odilitime))
- chore: 947 add other evm chains to wallet [\#949](https://github.com/ai16z/eliza/pull/949) ([n00b21337](https://github.com/n00b21337))
- fix: telegram response memory userId to agentId [\#948](https://github.com/ai16z/eliza/pull/948) ([bmgalego](https://github.com/bmgalego))
- docs: add WSL installation guide [\#946](https://github.com/ai16z/eliza/pull/946) ([ileana-pr](https://github.com/ileana-pr))
- feat: Supports upload files to AWS S3. [\#941](https://github.com/ai16z/eliza/pull/941) ([xwxtwd](https://github.com/xwxtwd))
- feat: process all responses actions [\#940](https://github.com/ai16z/eliza/pull/940) ([bmgalego](https://github.com/bmgalego))
- feat: add callback handler to runtime evaluate method [\#938](https://github.com/ai16z/eliza/pull/938) ([bmgalego](https://github.com/bmgalego))
- fix: update package name in faq [\#937](https://github.com/ai16z/eliza/pull/937) ([oxSaturn](https://github.com/oxSaturn))
- fix: update quickstart and .env.example [\#932](https://github.com/ai16z/eliza/pull/932) ([oxSaturn](https://github.com/oxSaturn))
- feat: add dynamic watch paths for agent development [\#931](https://github.com/ai16z/eliza/pull/931) ([samuveth](https://github.com/samuveth))
- feat: flow update generate object [\#929](https://github.com/ai16z/eliza/pull/929) ([btspoony](https://github.com/btspoony))
- feat: Config eternalai model from env [\#927](https://github.com/ai16z/eliza/pull/927) ([genesis-0000](https://github.com/genesis-0000))
- feat: Add NanoGPT provider [\#926](https://github.com/ai16z/eliza/pull/926) ([dylan1951](https://github.com/dylan1951))
- fix: use of Heurist model env vars [\#924](https://github.com/ai16z/eliza/pull/924) ([boxhock](https://github.com/boxhock))
- feat: add readContract / invokeContract functionality to Coinbase plugin [\#923](https://github.com/ai16z/eliza/pull/923) ([monilpat](https://github.com/monilpat))
- chore: deprecate text based way of generating JSON [\#920](https://github.com/ai16z/eliza/pull/920) ([monilpat](https://github.com/monilpat))
- feat: create README\_TH.md  [\#918](https://github.com/ai16z/eliza/pull/918) ([asianviking](https://github.com/asianviking))
- feat: update gaianet config [\#915](https://github.com/ai16z/eliza/pull/915) ([L-jasmine](https://github.com/L-jasmine))
- fix: Farcater client cleanup and fixed response logic [\#914](https://github.com/ai16z/eliza/pull/914) ([sayangel](https://github.com/sayangel))
- feat: twitter client enhancements [\#913](https://github.com/ai16z/eliza/pull/913) ([tharak123455](https://github.com/tharak123455))
- feat: MAX\_TWEET\_LENGTH env implementation [\#912](https://github.com/ai16z/eliza/pull/912) ([onur-saf](https://github.com/onur-saf))
- feat: allow users to configure models for groq [\#910](https://github.com/ai16z/eliza/pull/910) ([oxSaturn](https://github.com/oxSaturn))
- fix: evaluation json parsing [\#907](https://github.com/ai16z/eliza/pull/907) ([cygaar](https://github.com/cygaar))
- fix: twitter actions not triggering [\#903](https://github.com/ai16z/eliza/pull/903) ([cygaar](https://github.com/cygaar))
- chore: Consistent language for Community & Contact link label [\#899](https://github.com/ai16z/eliza/pull/899) ([golryang](https://github.com/golryang))
- chore: pass env variables when setting up GOAT and update GOAT readme [\#898](https://github.com/ai16z/eliza/pull/898) ([0xaguspunk](https://github.com/0xaguspunk))
- docs: Add What Did You Get Done This Week \#4 summaries and timestamps [\#895](https://github.com/ai16z/eliza/pull/895) ([YoungPhlo](https://github.com/YoungPhlo))
- chore: improved dev command [\#892](https://github.com/ai16z/eliza/pull/892) ([shakkernerd](https://github.com/shakkernerd))
- chore: added more help message to the important notice text. [\#891](https://github.com/ai16z/eliza/pull/891) ([shakkernerd](https://github.com/shakkernerd))
- chore: update models for groq [\#890](https://github.com/ai16z/eliza/pull/890) ([oxSaturn](https://github.com/oxSaturn))
- feat : github image cicd [\#889](https://github.com/ai16z/eliza/pull/889) ([v1xingyue](https://github.com/v1xingyue))
- chore: enhance dev script, performance improvement and add help message [\#887](https://github.com/ai16z/eliza/pull/887) ([shakkernerd](https://github.com/shakkernerd))
- chore: disable building docs on build command [\#884](https://github.com/ai16z/eliza/pull/884) ([shakkernerd](https://github.com/shakkernerd))
- fix: re-enable coverage report upload to Codecov in CI workflow [\#880](https://github.com/ai16z/eliza/pull/880) ([snobbee](https://github.com/snobbee))
- feat: Add Flow Blockchain plugin  [\#874](https://github.com/ai16z/eliza/pull/874) ([btspoony](https://github.com/btspoony))
- feat: Add TEE Mode to Solana Plugin [\#835](https://github.com/ai16z/eliza/pull/835) ([HashWarlock](https://github.com/HashWarlock))
- feat: add hyperbolic api to eliza [\#828](https://github.com/ai16z/eliza/pull/828) ([meppsilon](https://github.com/meppsilon))
- loading indicator [\#827](https://github.com/ai16z/eliza/pull/827) ([tcm390](https://github.com/tcm390))
- use github access token [\#825](https://github.com/ai16z/eliza/pull/825) ([tcm390](https://github.com/tcm390))
- fix: refactor contributor page [\#809](https://github.com/ai16z/eliza/pull/809) ([tcm390](https://github.com/tcm390))
- feat: implement advanced coinbase trading [\#725](https://github.com/ai16z/eliza/pull/725) ([monilpat](https://github.com/monilpat))

## [v0.1.5-alpha.5](https://github.com/ai16z/eliza/tree/v0.1.5-alpha.5) (2024-12-07)

[Full Changelog](https://github.com/ai16z/eliza/compare/v0.1.5-alpha.4...v0.1.5-alpha.5)

**Merged pull requests:**

- feat: working farcaster client with neynar [\#570](https://github.com/ai16z/eliza/pull/570) ([sayangel](https://github.com/sayangel))

## [v0.1.5-alpha.4](https://github.com/ai16z/eliza/tree/v0.1.5-alpha.4) (2024-12-06)

[Full Changelog](https://github.com/ai16z/eliza/compare/v0.1.5-alpha.3...v0.1.5-alpha.4)

**Fixed bugs:**

- `pnpm  start` crashes if there is too much data in knowledge [\#866](https://github.com/ai16z/eliza/issues/866)
- Twitter login some function not work.  [\#857](https://github.com/ai16z/eliza/issues/857)

**Merged pull requests:**

- docs: Add AI Agent Dev School Parts 2 and 3 summaries and timestamps [\#877](https://github.com/ai16z/eliza/pull/877) ([YoungPhlo](https://github.com/YoungPhlo))
- Add google model env vars [\#875](https://github.com/ai16z/eliza/pull/875) ([peersky](https://github.com/peersky))
- Update quickstart.md [\#872](https://github.com/ai16z/eliza/pull/872) ([oxSaturn](https://github.com/oxSaturn))
- Remove duplicated coinbase CDP options in .env.example [\#863](https://github.com/ai16z/eliza/pull/863) ([juntao](https://github.com/juntao))
- test: adding environment and knowledge tests [\#862](https://github.com/ai16z/eliza/pull/862) ([ai16z-demirix](https://github.com/ai16z-demirix))
- Updated quickstart.md to contemplate common issue [\#861](https://github.com/ai16z/eliza/pull/861) ([fede2442](https://github.com/fede2442))
- fix: Use LARGE models for responses [\#853](https://github.com/ai16z/eliza/pull/853) ([lalalune](https://github.com/lalalune))
- Update Node version in local-development.md [\#850](https://github.com/ai16z/eliza/pull/850) ([oxSaturn](https://github.com/oxSaturn))
- fix: plugins docs [\#848](https://github.com/ai16z/eliza/pull/848) ([cygaar](https://github.com/cygaar))
- fix: run release workflow after a github release is created [\#846](https://github.com/ai16z/eliza/pull/846) ([cygaar](https://github.com/cygaar))
- fix: Include scripts/postinstall.js in the final NPM package [\#843](https://github.com/ai16z/eliza/pull/843) ([martincik](https://github.com/martincik))
- feat: add Aptos plugin [\#818](https://github.com/ai16z/eliza/pull/818) ([0xaptosj](https://github.com/0xaptosj))
- feat: add coinbase  ERC20, ERC721, and ERC1155 tokenContract deployment / invokement plugin [\#803](https://github.com/ai16z/eliza/pull/803) ([monilpat](https://github.com/monilpat))
- feat: coinbase webhook + add more examples + testing [\#801](https://github.com/ai16z/eliza/pull/801) ([monilpat](https://github.com/monilpat))

## [v0.1.5-alpha.3](https://github.com/ai16z/eliza/tree/v0.1.5-alpha.3) (2024-12-04)

[Full Changelog](https://github.com/ai16z/eliza/compare/v0.1.5-alpha.2...v0.1.5-alpha.3)

**Merged pull requests:**

- chore: bump version to 0.1.5-alpha.3 [\#838](https://github.com/ai16z/eliza/pull/838) ([cygaar](https://github.com/cygaar))
- chore: Revert/viem version and bump @goat-sdk/plugin-erc20 [\#836](https://github.com/ai16z/eliza/pull/836) ([shakkernerd](https://github.com/shakkernerd))
- chore: revert viem package version [\#834](https://github.com/ai16z/eliza/pull/834) ([shakkernerd](https://github.com/shakkernerd))

## [v0.1.5-alpha.2](https://github.com/ai16z/eliza/tree/v0.1.5-alpha.2) (2024-12-04)

[Full Changelog](https://github.com/ai16z/eliza/compare/v0.1.5-alpha.0...v0.1.5-alpha.2)

**Implemented enhancements:**

- feat: Add circuit breaker pattern for database operations [\#712](https://github.com/ai16z/eliza/issues/712)

**Fixed bugs:**

- 404 Localhost port 3000 [\#804](https://github.com/ai16z/eliza/issues/804)
- actions examples selection does not select things properly [\#798](https://github.com/ai16z/eliza/issues/798)
- recentPosts always empty [\#679](https://github.com/ai16z/eliza/issues/679)

**Merged pull requests:**

- chore: bump version to 0.1.5-alpha.1 [\#833](https://github.com/ai16z/eliza/pull/833) ([cygaar](https://github.com/cygaar))
- fix: pin all node dependencies + update @solana/web3.js to safe version [\#832](https://github.com/ai16z/eliza/pull/832) ([cygaar](https://github.com/cygaar))
- fix: docker-setup.md [\#826](https://github.com/ai16z/eliza/pull/826) ([Freytes](https://github.com/Freytes))
- fix: twitter cache expires [\#824](https://github.com/ai16z/eliza/pull/824) ([palsp](https://github.com/palsp))
- feat: \(core\) Add circuit breaker pattern for database operations -… [\#812](https://github.com/ai16z/eliza/pull/812) ([augchan42](https://github.com/augchan42))
- fix: lerna publish command [\#811](https://github.com/ai16z/eliza/pull/811) ([cygaar](https://github.com/cygaar))

## [v0.1.5-alpha.0](https://github.com/ai16z/eliza/tree/v0.1.5-alpha.0) (2024-12-03)

[Full Changelog](https://github.com/ai16z/eliza/compare/v0.1.5...v0.1.5-alpha.0)

**Fixed bugs:**

- Plugin system in character.plugins is not working [\#795](https://github.com/ai16z/eliza/issues/795)

**Closed issues:**

- State should use a cosine similarity of messages in the DB  [\#471](https://github.com/ai16z/eliza/issues/471)

**Merged pull requests:**

- fix: update package version to v0.1.5-alpha.0 [\#808](https://github.com/ai16z/eliza/pull/808) ([cygaar](https://github.com/cygaar))
- fix: release workflow part 3 [\#807](https://github.com/ai16z/eliza/pull/807) ([cygaar](https://github.com/cygaar))
- fix: part 2 of updating the npm publish workflow [\#806](https://github.com/ai16z/eliza/pull/806) ([cygaar](https://github.com/cygaar))
- fix: update npm publication workflow [\#805](https://github.com/ai16z/eliza/pull/805) ([cygaar](https://github.com/cygaar))
- fix: swap type error, create user trust on first message in telegram [\#800](https://github.com/ai16z/eliza/pull/800) ([MarcoMandar](https://github.com/MarcoMandar))
- refactor: Improve actions samples random selection [\#799](https://github.com/ai16z/eliza/pull/799) ([dievardump](https://github.com/dievardump))
- fix: Docker default non-interactive mode for Cloud instances [\#796](https://github.com/ai16z/eliza/pull/796) ([rarepepi](https://github.com/rarepepi))
- fix: dev command [\#793](https://github.com/ai16z/eliza/pull/793) ([shakkernerd](https://github.com/shakkernerd))
- chore: update README\_KOR.md to match latest README.md [\#789](https://github.com/ai16z/eliza/pull/789) ([mike0295](https://github.com/mike0295))
- fix: enviroment -\> environment [\#787](https://github.com/ai16z/eliza/pull/787) ([tomguluson92](https://github.com/tomguluson92))
- Update generation.ts to fix TOGETHER/LLAMACLOUD image generation [\#786](https://github.com/ai16z/eliza/pull/786) ([ProphetX10](https://github.com/ProphetX10))
- fixs: uuid compatible for number [\#785](https://github.com/ai16z/eliza/pull/785) ([tomguluson92](https://github.com/tomguluson92))
- fix: When the plugins field in the .character.json file is configured with plugin name. [\#784](https://github.com/ai16z/eliza/pull/784) ([xwxtwd](https://github.com/xwxtwd))

## [v0.1.5](https://github.com/ai16z/eliza/tree/v0.1.5) (2024-12-02)

[Full Changelog](https://github.com/ai16z/eliza/compare/v0.1.4-alpha.3...v0.1.5)

**Implemented enhancements:**

- feat-Enhanced Voice Configuration Support in Character Cards [\#694](https://github.com/ai16z/eliza/issues/694)
- Optional image model provider to character and runtime [\#647](https://github.com/ai16z/eliza/issues/647)
- I have GROQ\_API\_KEY and telgram's robot token, How should I configure it so that I can interact with Telegram only by using the API without starting a model locally? [\#623](https://github.com/ai16z/eliza/issues/623)
- Add support for local embeddings BGE/384 [\#604](https://github.com/ai16z/eliza/issues/604)
- Need Discord or Telegram Group to Quickly Get Help For Developer [\#563](https://github.com/ai16z/eliza/issues/563)
- feat : whatsapp [\#626](https://github.com/ai16z/eliza/pull/626) ([awidearray](https://github.com/awidearray))

**Fixed bugs:**

- pnpm install error - ELIFECYCLE Exit code 1 [\#720](https://github.com/ai16z/eliza/issues/720)
- Debug/Verbose eliza logging is always shown [\#687](https://github.com/ai16z/eliza/issues/687)
- Failed codecov run [\#663](https://github.com/ai16z/eliza/issues/663)
- Discord Client - gives 0 permissions for invite link on logger [\#661](https://github.com/ai16z/eliza/issues/661)
- TypeError while generating a message response [\#657](https://github.com/ai16z/eliza/issues/657)
- Smol one; Matched fragment log not showing similarity score [\#615](https://github.com/ai16z/eliza/issues/615)
- New knowledge not being ingested into agent memory after first run [\#614](https://github.com/ai16z/eliza/issues/614)
- Tests failing - token.test.ts failing because it is commented out. Cache and goals tests are failing because jest is now switched with vitest [\#519](https://github.com/ai16z/eliza/issues/519)
- Non node.js environments have issues building \(workers for instance\) [\#506](https://github.com/ai16z/eliza/issues/506)
- Error when call `generateObjectV2` [\#469](https://github.com/ai16z/eliza/issues/469)
- Current token.test.ts and videoGeneration.test.ts are throwing errors [\#464](https://github.com/ai16z/eliza/issues/464)
- unable to run defaultcharacter with ModelProviderName.LLAMACLOUD local [\#271](https://github.com/ai16z/eliza/issues/271)
- Incorrect steps in readme for starting eliza [\#270](https://github.com/ai16z/eliza/issues/270)

**Merged pull requests:**

- refactor: refactor dockerfile to reduce image and build time [\#782](https://github.com/ai16z/eliza/pull/782) ([HashWarlock](https://github.com/HashWarlock))
- feat: Update default character [\#781](https://github.com/ai16z/eliza/pull/781) ([lalalune](https://github.com/lalalune))
- fix: Refactor image interface and update to move llama cloud -\> together provider [\#777](https://github.com/ai16z/eliza/pull/777) ([lalalune](https://github.com/lalalune))
- Create docker-setup.md [\#776](https://github.com/ai16z/eliza/pull/776) ([Freytes](https://github.com/Freytes))
- Merge more model providers and fix issues [\#775](https://github.com/ai16z/eliza/pull/775) ([lalalune](https://github.com/lalalune))
- Integrate more LLMs, fix case issue in switch [\#774](https://github.com/ai16z/eliza/pull/774) ([lalalune](https://github.com/lalalune))
- Integrate goat plugin [\#773](https://github.com/ai16z/eliza/pull/773) ([lalalune](https://github.com/lalalune))
- fix: Integrate jin's docs changes and rebuild docs with a16z [\#772](https://github.com/ai16z/eliza/pull/772) ([lalalune](https://github.com/lalalune))
- feat: more dependency updates [\#771](https://github.com/ai16z/eliza/pull/771) ([lalalune](https://github.com/lalalune))
- chore\(deps\): update dependency @vitest/eslint-plugin to v1.1.13 [\#770](https://github.com/ai16z/eliza/pull/770) ([renovate[bot]](https://github.com/apps/renovate))
- chore\(deps\): update dependency @eslint/js to v9.16.0 [\#769](https://github.com/ai16z/eliza/pull/769) ([renovate[bot]](https://github.com/apps/renovate))
- fix\(deps\): update sqlite related [\#768](https://github.com/ai16z/eliza/pull/768) ([renovate[bot]](https://github.com/apps/renovate))
- feat: Pin dependencies and unify tsconfig [\#767](https://github.com/ai16z/eliza/pull/767) ([lalalune](https://github.com/lalalune))
- Update dependency uuid to v11.0.3 [\#766](https://github.com/ai16z/eliza/pull/766) ([renovate[bot]](https://github.com/apps/renovate))
- Update environment, add twitter quality of life updates [\#765](https://github.com/ai16z/eliza/pull/765) ([lalalune](https://github.com/lalalune))
- fix: improve twitter post content quality [\#763](https://github.com/ai16z/eliza/pull/763) ([cygaar](https://github.com/cygaar))
- Add decentralized GenAI backend  [\#762](https://github.com/ai16z/eliza/pull/762) ([L-jasmine](https://github.com/L-jasmine))
- fix\(deps\): update dependency tailwind-merge to v2.5.5 [\#761](https://github.com/ai16z/eliza/pull/761) ([renovate[bot]](https://github.com/apps/renovate))
- Update dependency clsx to v2.1.1 [\#760](https://github.com/ai16z/eliza/pull/760) ([renovate[bot]](https://github.com/apps/renovate))
- feat: donate 1% of coinbase transactions by default [\#759](https://github.com/ai16z/eliza/pull/759) ([monilpat](https://github.com/monilpat))
- Add running with Gitpod [\#758](https://github.com/ai16z/eliza/pull/758) ([v1xingyue](https://github.com/v1xingyue))
- fix: follow-up improvements for ICP token creation \(PR \#357\) [\#757](https://github.com/ai16z/eliza/pull/757) ([asDNSk](https://github.com/asDNSk))
- fix: recentPosts always empty [\#756](https://github.com/ai16z/eliza/pull/756) ([tcm390](https://github.com/tcm390))
- Update dependency @supabase/supabase-js to v2.46.2 [\#754](https://github.com/ai16z/eliza/pull/754) ([renovate[bot]](https://github.com/apps/renovate))
- fix: packagejson updated to latest agent-client 0.0.16 [\#753](https://github.com/ai16z/eliza/pull/753) ([denizekiz](https://github.com/denizekiz))
- fix: Text2Image interface refactored [\#752](https://github.com/ai16z/eliza/pull/752) ([tomguluson92](https://github.com/tomguluson92))
- fix\(deps\): update dependency @ai-sdk/openai to v1.0.5 [\#751](https://github.com/ai16z/eliza/pull/751) ([renovate[bot]](https://github.com/apps/renovate))
- fix\(deps\): replace dependency eslint-plugin-vitest with @vitest/eslint-plugin 1.0.1 [\#749](https://github.com/ai16z/eliza/pull/749) ([renovate[bot]](https://github.com/apps/renovate))
- feat: Add two more providers: Ali Bailian\(Qwen\) and Volengine\(Doubao, Bytedance\) [\#747](https://github.com/ai16z/eliza/pull/747) ([btspoony](https://github.com/btspoony))
- add simulator tutor for plugin-tee docs [\#746](https://github.com/ai16z/eliza/pull/746) ([shelvenzhou](https://github.com/shelvenzhou))
- feat: Create community section [\#745](https://github.com/ai16z/eliza/pull/745) ([madjin](https://github.com/madjin))
- fix\(deps\): pin dependencies [\#744](https://github.com/ai16z/eliza/pull/744) ([renovate[bot]](https://github.com/apps/renovate))
- fix \(core\): message completion footer format [\#742](https://github.com/ai16z/eliza/pull/742) ([CodingTux](https://github.com/CodingTux))
- chore: remove unused env var [\#737](https://github.com/ai16z/eliza/pull/737) ([2pmflow](https://github.com/2pmflow))
- feat: add goat plugin [\#736](https://github.com/ai16z/eliza/pull/736) ([0xaguspunk](https://github.com/0xaguspunk))
- feat: increase knowledge context [\#730](https://github.com/ai16z/eliza/pull/730) ([cygaar](https://github.com/cygaar))
- fix: twitter recent interactions [\#729](https://github.com/ai16z/eliza/pull/729) ([cygaar](https://github.com/cygaar))
- feat: add new pages, update sidebar [\#728](https://github.com/ai16z/eliza/pull/728) ([madjin](https://github.com/madjin))
- refactor: ClientBase to use a map for managing multiple Twitter clients by account identifier [\#722](https://github.com/ai16z/eliza/pull/722) ([tcm390](https://github.com/tcm390))
- fix: simplify linting dependencies [\#721](https://github.com/ai16z/eliza/pull/721) ([cygaar](https://github.com/cygaar))
- fix: move `fastembed` import to the isnode condition check [\#709](https://github.com/ai16z/eliza/pull/709) ([antpb](https://github.com/antpb))
- fix: Switch from tiktoken to js-tiktoken for worker compatibility [\#703](https://github.com/ai16z/eliza/pull/703) ([antpb](https://github.com/antpb))
- fix: update docker image to support turbo and reduce build time [\#702](https://github.com/ai16z/eliza/pull/702) ([HashWarlock](https://github.com/HashWarlock))
- chore: Remove web-agent folder - duplicate of client folder [\#699](https://github.com/ai16z/eliza/pull/699) ([shakkernerd](https://github.com/shakkernerd))
- feat: \(voice\) enhance character card voice configuration support [\#698](https://github.com/ai16z/eliza/pull/698) ([augchan42](https://github.com/augchan42))
- chore: remove unused packages introduced in \#677 [\#693](https://github.com/ai16z/eliza/pull/693) ([shakkernerd](https://github.com/shakkernerd))
- Fix/logging issues [\#688](https://github.com/ai16z/eliza/pull/688) ([augchan42](https://github.com/augchan42))
- feat: make twitter client polling configurable [\#683](https://github.com/ai16z/eliza/pull/683) ([cygaar](https://github.com/cygaar))
- fix: getEmbeddingZeroVector calls [\#682](https://github.com/ai16z/eliza/pull/682) ([cygaar](https://github.com/cygaar))
- fix: Make TEE Plugin available to launch agent & fix previous launch error [\#678](https://github.com/ai16z/eliza/pull/678) ([HashWarlock](https://github.com/HashWarlock))
- feat: improve embeddings, models and connectivity [\#677](https://github.com/ai16z/eliza/pull/677) ([augchan42](https://github.com/augchan42))
- Fix: run tests with coverage [\#676](https://github.com/ai16z/eliza/pull/676) ([pgoos](https://github.com/pgoos))
- fix: add missing viem dependency [\#674](https://github.com/ai16z/eliza/pull/674) ([HashWarlock](https://github.com/HashWarlock))
- fix: eslint not working [\#672](https://github.com/ai16z/eliza/pull/672) ([cygaar](https://github.com/cygaar))
- fix: embeddings for messages with urls [\#671](https://github.com/ai16z/eliza/pull/671) ([cygaar](https://github.com/cygaar))
- feat: add Turborepo [\#670](https://github.com/ai16z/eliza/pull/670) ([lalalune](https://github.com/lalalune))
- incorrect package install location Update plugins.md [\#669](https://github.com/ai16z/eliza/pull/669) ([cryptoradagast](https://github.com/cryptoradagast))
- redpill custom models [\#668](https://github.com/ai16z/eliza/pull/668) ([v1xingyue](https://github.com/v1xingyue))
- feat: evm pubkey derivation [\#667](https://github.com/ai16z/eliza/pull/667) ([St4rgarden](https://github.com/St4rgarden))
- fix: add missing commands to quickstart [\#665](https://github.com/ai16z/eliza/pull/665) ([0xaguspunk](https://github.com/0xaguspunk))
- fix: pnpm-lock.yaml [\#664](https://github.com/ai16z/eliza/pull/664) ([monilpat](https://github.com/monilpat))
- fix: discord permissions and duplicate reactions, new /joinchannel command [\#662](https://github.com/ai16z/eliza/pull/662) ([augchan42](https://github.com/augchan42))
- fix: embedding search for non-openai models [\#660](https://github.com/ai16z/eliza/pull/660) ([cygaar](https://github.com/cygaar))
- feat: add minimal config file for code cov [\#659](https://github.com/ai16z/eliza/pull/659) ([pgoos](https://github.com/pgoos))
- feat: Add wallet history \(transactions, balances\) to coinbase providers [\#658](https://github.com/ai16z/eliza/pull/658) ([monilpat](https://github.com/monilpat))
- CS - adding better errors and readme. [\#654](https://github.com/ai16z/eliza/pull/654) ([justabot](https://github.com/justabot))
- feat: improve browser service [\#653](https://github.com/ai16z/eliza/pull/653) ([cygaar](https://github.com/cygaar))
- Update ci.yaml [\#652](https://github.com/ai16z/eliza/pull/652) ([snobbee](https://github.com/snobbee))
- Add Galadriel LLM Inference Provider [\#651](https://github.com/ai16z/eliza/pull/651) ([dontAskVI](https://github.com/dontAskVI))
- feat: add image text model provider separation and fal.ai integration [\#650](https://github.com/ai16z/eliza/pull/650) ([yoniebans](https://github.com/yoniebans))
- added support for LlamaLocal's path outside plugin-node/dist [\#649](https://github.com/ai16z/eliza/pull/649) ([dr-fusion](https://github.com/dr-fusion))
- updates postgres setup instructions in docs [\#645](https://github.com/ai16z/eliza/pull/645) ([DataRelic](https://github.com/DataRelic))
- feat: Merge EVM and add character override [\#643](https://github.com/ai16z/eliza/pull/643) ([lalalune](https://github.com/lalalune))
- Feat/simulation sell types [\#642](https://github.com/ai16z/eliza/pull/642) ([MarcoMandar](https://github.com/MarcoMandar))
- add connection instruction for connecting with X [\#641](https://github.com/ai16z/eliza/pull/641) ([zjasper666](https://github.com/zjasper666))
- fix: Add docs, update providers for TEE Plugin [\#640](https://github.com/ai16z/eliza/pull/640) ([HashWarlock](https://github.com/HashWarlock))
- Notes for AI Agent Dev School \#1 [\#638](https://github.com/ai16z/eliza/pull/638) ([YoungPhlo](https://github.com/YoungPhlo))
- fix: node package builds [\#636](https://github.com/ai16z/eliza/pull/636) ([cygaar](https://github.com/cygaar))
- refactor: better db connection handling [\#635](https://github.com/ai16z/eliza/pull/635) ([cygaar](https://github.com/cygaar))
- dicord bot voice [\#633](https://github.com/ai16z/eliza/pull/633) ([tcm390](https://github.com/tcm390))
- feat: Initial TEE Plugin [\#632](https://github.com/ai16z/eliza/pull/632) ([HashWarlock](https://github.com/HashWarlock))
- feat: support starkname [\#628](https://github.com/ai16z/eliza/pull/628) ([irisdv](https://github.com/irisdv))
- Feat/sell simulation [\#627](https://github.com/ai16z/eliza/pull/627) ([MarcoMandar](https://github.com/MarcoMandar))
- fix: small improvements to agent process exits [\#625](https://github.com/ai16z/eliza/pull/625) ([cygaar](https://github.com/cygaar))
- fix:  running a character.json fails when running per docs [\#624](https://github.com/ai16z/eliza/pull/624) ([yodamaster726](https://github.com/yodamaster726))
- fix: Add Tweet Response Deduplication Check [\#622](https://github.com/ai16z/eliza/pull/622) ([tsubasakong](https://github.com/tsubasakong))
- fix: handle when tweet\_results is empty better [\#620](https://github.com/ai16z/eliza/pull/620) ([odilitime](https://github.com/odilitime))
- fix: memory similarity log & new knowledge ingestion [\#616](https://github.com/ai16z/eliza/pull/616) ([yoniebans](https://github.com/yoniebans))
- fix: Update and add Conflux [\#613](https://github.com/ai16z/eliza/pull/613) ([lalalune](https://github.com/lalalune))
- fix: Fix buttplug.io integration and merge [\#612](https://github.com/ai16z/eliza/pull/612) ([lalalune](https://github.com/lalalune))
- chore\(nvmrc\): update Node.js version from v23.1.0 to v23.3.0 [\#611](https://github.com/ai16z/eliza/pull/611) ([wolfcito](https://github.com/wolfcito))
- fix: add client farcaster templates to character type [\#610](https://github.com/ai16z/eliza/pull/610) ([bmgalego](https://github.com/bmgalego))
- fix: knowledge module exporting process [\#609](https://github.com/ai16z/eliza/pull/609) ([bmgalego](https://github.com/bmgalego))
- feat: implement coinbase trading [\#608](https://github.com/ai16z/eliza/pull/608) ([monilpat](https://github.com/monilpat))
- fix: use correct getCachedEmbeddings query\_field\_sub\_name [\#607](https://github.com/ai16z/eliza/pull/607) ([bmgalego](https://github.com/bmgalego))
- fix: db queries in sqljs database adapter not using agentId [\#606](https://github.com/ai16z/eliza/pull/606) ([bmgalego](https://github.com/bmgalego))
- fix: agent DirectClient is not a type [\#605](https://github.com/ai16z/eliza/pull/605) ([odilitime](https://github.com/odilitime))
- fix: time prompt to include UTC, convert to verbose english to help prompting [\#603](https://github.com/ai16z/eliza/pull/603) ([odilitime](https://github.com/odilitime))
- fix: add Memory Manager getMemoriesByRoomIds missing tableName param [\#602](https://github.com/ai16z/eliza/pull/602) ([bmgalego](https://github.com/bmgalego))
- feat: add knowledge to state [\#600](https://github.com/ai16z/eliza/pull/600) ([bmgalego](https://github.com/bmgalego))
- feat: make node-plugin lazy-loaded for faster boot times [\#599](https://github.com/ai16z/eliza/pull/599) ([bmgalego](https://github.com/bmgalego))
- fix: discord crash on sending message to null channel [\#598](https://github.com/ai16z/eliza/pull/598) ([odilitime](https://github.com/odilitime))
- feat: sell simulation service [\#597](https://github.com/ai16z/eliza/pull/597) ([MarcoMandar](https://github.com/MarcoMandar))
- Pr 33 [\#596](https://github.com/ai16z/eliza/pull/596) ([MarcoMandar](https://github.com/MarcoMandar))
- feat: starknet portfolio provider [\#595](https://github.com/ai16z/eliza/pull/595) ([milancermak](https://github.com/milancermak))
- Download updates [\#594](https://github.com/ai16z/eliza/pull/594) ([justabot](https://github.com/justabot))
- feat: update sidebars [\#593](https://github.com/ai16z/eliza/pull/593) ([madjin](https://github.com/madjin))
- feat: Adding tests for actions and generation. Skiping test step in defaultCharacters [\#591](https://github.com/ai16z/eliza/pull/591) ([ai16z-demirix](https://github.com/ai16z-demirix))
- fix: enable test run in CI for core package [\#590](https://github.com/ai16z/eliza/pull/590) ([pgoos](https://github.com/pgoos))
- fix: Shaw/fix zerog [\#589](https://github.com/ai16z/eliza/pull/589) ([lalalune](https://github.com/lalalune))
- fix: React Client fixes [\#588](https://github.com/ai16z/eliza/pull/588) ([lalalune](https://github.com/lalalune))
- Shaw/logger fixes [\#587](https://github.com/ai16z/eliza/pull/587) ([lalalune](https://github.com/lalalune))
- feat: Shaw/realityspiral/coinbase fixes [\#586](https://github.com/ai16z/eliza/pull/586) ([lalalune](https://github.com/lalalune))
- feat: More package updates [\#585](https://github.com/ai16z/eliza/pull/585) ([lalalune](https://github.com/lalalune))
- feat: Update packages [\#584](https://github.com/ai16z/eliza/pull/584) ([lalalune](https://github.com/lalalune))
- fix: Devex Fixes [\#583](https://github.com/ai16z/eliza/pull/583) ([lalalune](https://github.com/lalalune))
- feat: update api docs [\#582](https://github.com/ai16z/eliza/pull/582) ([madjin](https://github.com/madjin))
- feat: add new pages [\#581](https://github.com/ai16z/eliza/pull/581) ([madjin](https://github.com/madjin))
- Add community stream notes for WDYGDTW 2 [\#580](https://github.com/ai16z/eliza/pull/580) ([YoungPhlo](https://github.com/YoungPhlo))
- fix: remove postinstall script from plugin-coinbase [\#573](https://github.com/ai16z/eliza/pull/573) ([bmgalego](https://github.com/bmgalego))
- fix: add missing documents and knowledge memory managers to runtime interface [\#572](https://github.com/ai16z/eliza/pull/572) ([bmgalego](https://github.com/bmgalego))
- fix: remove db adapters depencies from core and remove plugin-node from telegram  [\#571](https://github.com/ai16z/eliza/pull/571) ([bmgalego](https://github.com/bmgalego))
- feat: implement coinbase mass payments across base/sol/eth/pol/arb [\#569](https://github.com/ai16z/eliza/pull/569) ([monilpat](https://github.com/monilpat))
- CS - first api hookups. [\#564](https://github.com/ai16z/eliza/pull/564) ([justabot](https://github.com/justabot))
- fix: bump echogarden to fix case sensitive issue [\#561](https://github.com/ai16z/eliza/pull/561) ([0xFlicker](https://github.com/0xFlicker))
- fix: sql command [\#560](https://github.com/ai16z/eliza/pull/560) ([0xFlicker](https://github.com/0xFlicker))
- Improved Twitter Documentation [\#559](https://github.com/ai16z/eliza/pull/559) ([grallc](https://github.com/grallc))
- fix: postgres [\#557](https://github.com/ai16z/eliza/pull/557) ([ponderingdemocritus](https://github.com/ponderingdemocritus))
- fix: Use BigInt for tweet IDs in client-twitter [\#552](https://github.com/ai16z/eliza/pull/552) ([wraitii](https://github.com/wraitii))
- fix: generateText format consistency [\#550](https://github.com/ai16z/eliza/pull/550) ([tomguluson92](https://github.com/tomguluson92))
- Update dependency dompurify to v3.2.2 [\#548](https://github.com/ai16z/eliza/pull/548) ([renovate[bot]](https://github.com/apps/renovate))
- fix: Token provider getHighestLiquidityPair [\#547](https://github.com/ai16z/eliza/pull/547) ([bmgalego](https://github.com/bmgalego))
- fix: add try catch to process action [\#546](https://github.com/ai16z/eliza/pull/546) ([bmgalego](https://github.com/bmgalego))
- fix: error in getGoals and remove coinbase package-lock.json  [\#545](https://github.com/ai16z/eliza/pull/545) ([bmgalego](https://github.com/bmgalego))
- Update dependency clsx to v2.1.1 [\#544](https://github.com/ai16z/eliza/pull/544) ([renovate[bot]](https://github.com/apps/renovate))
- Update docusaurus monorepo to v3.6.3 [\#543](https://github.com/ai16z/eliza/pull/543) ([renovate[bot]](https://github.com/apps/renovate))
- Update dependency agent-twitter-client to v0.0.14 [\#542](https://github.com/ai16z/eliza/pull/542) ([renovate[bot]](https://github.com/apps/renovate))
- fix: discord voice memory id not unique [\#540](https://github.com/ai16z/eliza/pull/540) ([bmgalego](https://github.com/bmgalego))
- fix: db queries not using agentId in all memory queries [\#539](https://github.com/ai16z/eliza/pull/539) ([bmgalego](https://github.com/bmgalego))
- Update dependency @opendocsg/pdf2md to v0.1.32 [\#538](https://github.com/ai16z/eliza/pull/538) ([renovate[bot]](https://github.com/apps/renovate))
- Update dependency @echogarden/espeak-ng-emscripten to v0.3.3 [\#537](https://github.com/ai16z/eliza/pull/537) ([renovate[bot]](https://github.com/apps/renovate))
- feat: add agent selection, router and sidebar layout in React client [\#536](https://github.com/ai16z/eliza/pull/536) ([vivoidos](https://github.com/vivoidos))
- fix: pass runtime to video service [\#535](https://github.com/ai16z/eliza/pull/535) ([0xFlicker](https://github.com/0xFlicker))
- fix\(deps\): update dependency @ai-sdk/openai to v1.0.4 [\#533](https://github.com/ai16z/eliza/pull/533) ([renovate[bot]](https://github.com/apps/renovate))
- fix\(deps\): update dependency @ai-sdk/google-vertex to ^0.0.43 [\#532](https://github.com/ai16z/eliza/pull/532) ([renovate[bot]](https://github.com/apps/renovate))
- fix: Fix/telegram [\#530](https://github.com/ai16z/eliza/pull/530) ([ponderingdemocritus](https://github.com/ponderingdemocritus))
- fix\(deps\): pin dependencies [\#529](https://github.com/ai16z/eliza/pull/529) ([renovate[bot]](https://github.com/apps/renovate))
- fix\(deps\): update dependency @ai-sdk/anthropic to ^0.0.56 [\#528](https://github.com/ai16z/eliza/pull/528) ([renovate[bot]](https://github.com/apps/renovate))
- Pin dependency vue to 3.5.13 [\#527](https://github.com/ai16z/eliza/pull/527) ([renovate[bot]](https://github.com/apps/renovate))
- chore\(deps\): pin dependencies [\#526](https://github.com/ai16z/eliza/pull/526) ([renovate[bot]](https://github.com/apps/renovate))
- fix: missing updates for logger.ts [\#525](https://github.com/ai16z/eliza/pull/525) ([yodamaster726](https://github.com/yodamaster726))
- fix: Ollama fix [\#524](https://github.com/ai16z/eliza/pull/524) ([yodamaster726](https://github.com/yodamaster726))
- fix: fixing failing goals, cache and token tests [\#522](https://github.com/ai16z/eliza/pull/522) ([ai16z-demirix](https://github.com/ai16z-demirix))
- fix: ollama local and llama local [\#521](https://github.com/ai16z/eliza/pull/521) ([yodamaster726](https://github.com/yodamaster726))
- integrate tavily [\#518](https://github.com/ai16z/eliza/pull/518) ([tcm390](https://github.com/tcm390))
- feat: Add buttplug.io integration [\#517](https://github.com/ai16z/eliza/pull/517) ([8times4](https://github.com/8times4))
- feat: Add decentralized inferencing for Eliza \(LLAMA, Hermes, Flux\) [\#516](https://github.com/ai16z/eliza/pull/516) ([genesis-0000](https://github.com/genesis-0000))
- fix: lint [\#515](https://github.com/ai16z/eliza/pull/515) ([ponderingdemocritus](https://github.com/ponderingdemocritus))
- fix: husky and pre-commit [\#514](https://github.com/ai16z/eliza/pull/514) ([ponderingdemocritus](https://github.com/ponderingdemocritus))
- feat: add coinbase plugin starting with cb commerce functionality [\#513](https://github.com/ai16z/eliza/pull/513) ([monilpat](https://github.com/monilpat))
- docs: add template and client configuration guide [\#510](https://github.com/ai16z/eliza/pull/510) ([oguzserdar](https://github.com/oguzserdar))
- Wrap `fastembed` in try catch to allow non node environments to build [\#508](https://github.com/ai16z/eliza/pull/508) ([antpb](https://github.com/antpb))
- fix: Gracefully Handle Add Participants Unique Constraint Error in Postgres [\#495](https://github.com/ai16z/eliza/pull/495) ([VarKrishin](https://github.com/VarKrishin))
- test: add linter to all packages and enable vitest [\#490](https://github.com/ai16z/eliza/pull/490) ([snobbee](https://github.com/snobbee))
- feat: add Conflux plugin [\#481](https://github.com/ai16z/eliza/pull/481) ([darwintree](https://github.com/darwintree))
- bugfix: Modify docker run error after agent folder move [\#458](https://github.com/ai16z/eliza/pull/458) ([THtianhao](https://github.com/THtianhao))
- feat: Add 0G plugin for file storage [\#416](https://github.com/ai16z/eliza/pull/416) ([Wilbert957](https://github.com/Wilbert957))
- feat: Farcaster Client [\#386](https://github.com/ai16z/eliza/pull/386) ([bmgalego](https://github.com/bmgalego))
- feat: add ICP token creation support [\#357](https://github.com/ai16z/eliza/pull/357) ([asDNSk](https://github.com/asDNSk))

## [v0.1.4-alpha.3](https://github.com/ai16z/eliza/tree/v0.1.4-alpha.3) (2024-11-22)

[Full Changelog](https://github.com/ai16z/eliza/compare/v0.1.4-alpha.2...v0.1.4-alpha.3)

**Merged pull requests:**

- fix: speech service fix [\#512](https://github.com/ai16z/eliza/pull/512) ([ponderingdemocritus](https://github.com/ponderingdemocritus))

## [v0.1.4-alpha.2](https://github.com/ai16z/eliza/tree/v0.1.4-alpha.2) (2024-11-22)

[Full Changelog](https://github.com/ai16z/eliza/compare/v0.1.4-alpha.1...v0.1.4-alpha.2)

**Merged pull requests:**

- fix: services fix [\#509](https://github.com/ai16z/eliza/pull/509) ([ponderingdemocritus](https://github.com/ponderingdemocritus))

## [v0.1.4-alpha.1](https://github.com/ai16z/eliza/tree/v0.1.4-alpha.1) (2024-11-22)

[Full Changelog](https://github.com/ai16z/eliza/compare/v0.1.4-alpha.0...v0.1.4-alpha.1)

**Merged pull requests:**

- fix: issue with npm [\#505](https://github.com/ai16z/eliza/pull/505) ([ponderingdemocritus](https://github.com/ponderingdemocritus))

## [v0.1.4-alpha.0](https://github.com/ai16z/eliza/tree/v0.1.4-alpha.0) (2024-11-22)

[Full Changelog](https://github.com/ai16z/eliza/compare/v0.1.3...v0.1.4-alpha.0)

**Implemented enhancements:**

- Run using Bun.sh [\#492](https://github.com/ai16z/eliza/issues/492)
- Move Trust DB into package [\#342](https://github.com/ai16z/eliza/issues/342)
- Core Unit Tests [\#340](https://github.com/ai16z/eliza/issues/340)

**Fixed bugs:**

- Twitter Dry Run not working [\#451](https://github.com/ai16z/eliza/issues/451)
- getCachedEmbeddings broken for sqlite adapter  [\#251](https://github.com/ai16z/eliza/issues/251)

**Merged pull requests:**

- fix: remove sol dep [\#504](https://github.com/ai16z/eliza/pull/504) ([ponderingdemocritus](https://github.com/ponderingdemocritus))
- fix: deps [\#503](https://github.com/ai16z/eliza/pull/503) ([ponderingdemocritus](https://github.com/ponderingdemocritus))
- chore: add contributor license [\#502](https://github.com/ai16z/eliza/pull/502) ([awidearray](https://github.com/awidearray))
- node-v [\#501](https://github.com/ai16z/eliza/pull/501) ([ponderingdemocritus](https://github.com/ponderingdemocritus))
- fix: improve embeddings [\#496](https://github.com/ai16z/eliza/pull/496) ([ponderingdemocritus](https://github.com/ponderingdemocritus))
- feat: improve type saftey [\#494](https://github.com/ai16z/eliza/pull/494) ([ponderingdemocritus](https://github.com/ponderingdemocritus))
- fix: added missing packages to tsup configs' externals [\#488](https://github.com/ai16z/eliza/pull/488) ([massivefermion](https://github.com/massivefermion))
- fix: fix character path loading [\#487](https://github.com/ai16z/eliza/pull/487) ([bmgalego](https://github.com/bmgalego))
- fix: agent loadCharacters file resolver [\#486](https://github.com/ai16z/eliza/pull/486) ([bmgalego](https://github.com/bmgalego))
- fix: agent type error and sqlite file env [\#484](https://github.com/ai16z/eliza/pull/484) ([bmgalego](https://github.com/bmgalego))
- feat: Improvements [\#482](https://github.com/ai16z/eliza/pull/482) ([bmgalego](https://github.com/bmgalego))
- refactor: add template types [\#479](https://github.com/ai16z/eliza/pull/479) ([vivoidos](https://github.com/vivoidos))
- feat: Twitter Refactor [\#478](https://github.com/ai16z/eliza/pull/478) ([bmgalego](https://github.com/bmgalego))
- feat: Added TWITTER\_COOKIE example on quickstart.md [\#476](https://github.com/ai16z/eliza/pull/476) ([haeunchin](https://github.com/haeunchin))
- fix: ci [\#475](https://github.com/ai16z/eliza/pull/475) ([ponderingdemocritus](https://github.com/ponderingdemocritus))
- ollama generate case was using console.debug.  [\#474](https://github.com/ai16z/eliza/pull/474) ([drew-royster](https://github.com/drew-royster))
- feat: Improve knowledge embeddings [\#472](https://github.com/ai16z/eliza/pull/472) ([tarrencev](https://github.com/tarrencev))
- docs: Update Contributors to bring inline with PR468 [\#470](https://github.com/ai16z/eliza/pull/470) ([odilitime](https://github.com/odilitime))
- docs: Add Discord username question [\#468](https://github.com/ai16z/eliza/pull/468) ([odilitime](https://github.com/odilitime))
- feat: adds check [\#466](https://github.com/ai16z/eliza/pull/466) ([ponderingdemocritus](https://github.com/ponderingdemocritus))
- fix: Fixing failling tests token.test.ts and videoGeneration.test.ts [\#465](https://github.com/ai16z/eliza/pull/465) ([ai16z-demirix](https://github.com/ai16z-demirix))
- docs: Create best-practices.md documentation [\#463](https://github.com/ai16z/eliza/pull/463) ([snobbee](https://github.com/snobbee))
- feat: create-eliza-app [\#462](https://github.com/ai16z/eliza/pull/462) ([coffeeorgreentea](https://github.com/coffeeorgreentea))
- fix: Add missing fuzzystrmatch extension for levenshtein\(\) method to postgresql schema.sql definition [\#460](https://github.com/ai16z/eliza/pull/460) ([martincik](https://github.com/martincik))
- Add npm install instructions to homepage header [\#459](https://github.com/ai16z/eliza/pull/459) ([null-hax](https://github.com/null-hax))
- feat: init github client [\#456](https://github.com/ai16z/eliza/pull/456) ([tarrencev](https://github.com/tarrencev))
- fix: X dry run [\#452](https://github.com/ai16z/eliza/pull/452) ([laser-riot](https://github.com/laser-riot))
- feat: readme and linting [\#449](https://github.com/ai16z/eliza/pull/449) ([ponderingdemocritus](https://github.com/ponderingdemocritus))
- fix: ignored modelEndpointOverride in generation [\#446](https://github.com/ai16z/eliza/pull/446) ([darwintree](https://github.com/darwintree))
- docs: Fix my name in stream notes [\#442](https://github.com/ai16z/eliza/pull/442) ([odilitime](https://github.com/odilitime))
- fix: postgres embedding issues [\#425](https://github.com/ai16z/eliza/pull/425) ([tarrencev](https://github.com/tarrencev))
- feat: Cache Manager [\#378](https://github.com/ai16z/eliza/pull/378) ([bmgalego](https://github.com/bmgalego))
- feat: adding back the renovate file for automated security scanning [\#358](https://github.com/ai16z/eliza/pull/358) ([sirkitree](https://github.com/sirkitree))

## [v0.1.3](https://github.com/ai16z/eliza/tree/v0.1.3) (2024-11-20)

[Full Changelog](https://github.com/ai16z/eliza/compare/v0.1.3-alpha.2...v0.1.3)

**Implemented enhancements:**

- ⚙️Take Order Action Integration [\#53](https://github.com/ai16z/eliza/issues/53)
- 🔍 Trust Score Calculator [\#52](https://github.com/ai16z/eliza/issues/52)
- 📊 Order Book System [\#49](https://github.com/ai16z/eliza/issues/49)
- daos.fun integration [\#33](https://github.com/ai16z/eliza/issues/33)

**Merged pull requests:**

- fix: voice perms [\#447](https://github.com/ai16z/eliza/pull/447) ([ponderingdemocritus](https://github.com/ponderingdemocritus))
- fix: unrug [\#444](https://github.com/ai16z/eliza/pull/444) ([ponderingdemocritus](https://github.com/ponderingdemocritus))
- feat:  add all the style guidelines to the context [\#441](https://github.com/ai16z/eliza/pull/441) ([o-on-x](https://github.com/o-on-x))
- fix: fixes some console logs [\#440](https://github.com/ai16z/eliza/pull/440) ([ponderingdemocritus](https://github.com/ponderingdemocritus))
- fix: The bot is by default deafened and we don't want that [\#437](https://github.com/ai16z/eliza/pull/437) ([martincik](https://github.com/martincik))
- fix: path [\#436](https://github.com/ai16z/eliza/pull/436) ([ponderingdemocritus](https://github.com/ponderingdemocritus))
- fix: since agent is moved out of packages, adjust default path [\#432](https://github.com/ai16z/eliza/pull/432) ([odilitime](https://github.com/odilitime))
- fix: Fix linter issues [\#397](https://github.com/ai16z/eliza/pull/397) ([martincik](https://github.com/martincik))

## [v0.1.3-alpha.2](https://github.com/ai16z/eliza/tree/v0.1.3-alpha.2) (2024-11-20)

[Full Changelog](https://github.com/ai16z/eliza/compare/v0.1.3-alpha.1...v0.1.3-alpha.2)

**Merged pull requests:**

- fix: imports [\#435](https://github.com/ai16z/eliza/pull/435) ([ponderingdemocritus](https://github.com/ponderingdemocritus))

## [v0.1.3-alpha.1](https://github.com/ai16z/eliza/tree/v0.1.3-alpha.1) (2024-11-20)

[Full Changelog](https://github.com/ai16z/eliza/compare/v0.1.3-alpha.0...v0.1.3-alpha.1)

**Merged pull requests:**

- chore: Update pr.yaml to show actual condition so easier to follow [\#429](https://github.com/ai16z/eliza/pull/429) ([monilpat](https://github.com/monilpat))
- feat: don't require .env to exist [\#427](https://github.com/ai16z/eliza/pull/427) ([odilitime](https://github.com/odilitime))

## [v0.1.3-alpha.0](https://github.com/ai16z/eliza/tree/v0.1.3-alpha.0) (2024-11-20)

[Full Changelog](https://github.com/ai16z/eliza/compare/v0.1.2...v0.1.3-alpha.0)

**Merged pull requests:**

- fix: linting and imports ready for npm [\#433](https://github.com/ai16z/eliza/pull/433) ([ponderingdemocritus](https://github.com/ponderingdemocritus))
- docs: Update contributing.md to incorporate Contribution Guidelines [\#430](https://github.com/ai16z/eliza/pull/430) ([monilpat](https://github.com/monilpat))

## [v0.1.2](https://github.com/ai16z/eliza/tree/v0.1.2) (2024-11-20)

[Full Changelog](https://github.com/ai16z/eliza/compare/v0.1.1...v0.1.2)

**Merged pull requests:**

- fix: configs [\#431](https://github.com/ai16z/eliza/pull/431) ([ponderingdemocritus](https://github.com/ponderingdemocritus))

## [v0.1.1](https://github.com/ai16z/eliza/tree/v0.1.1) (2024-11-20)

[Full Changelog](https://github.com/ai16z/eliza/compare/v0.0.10...v0.1.1)

**Implemented enhancements:**

- توکن های داگز ناتکویین تتر کتوز کویین به حسام واریز شود [\#420](https://github.com/ai16z/eliza/issues/420)
- New Plugin Idea: log discord and summarize channels [\#318](https://github.com/ai16z/eliza/issues/318)
- Add GROK Model Provider Key Support in `getTokenForProvider` Function [\#295](https://github.com/ai16z/eliza/issues/295)
- Feature Request: Automated Bot Registry and Private Communication Protocol [\#291](https://github.com/ai16z/eliza/issues/291)
- Unify ImageGen into ModelClass.IMAGE [\#223](https://github.com/ai16z/eliza/issues/223)
- Move services to plugins [\#222](https://github.com/ai16z/eliza/issues/222)
- Make sure system directive passed to vercel sdk [\#217](https://github.com/ai16z/eliza/issues/217)
- .env not loading? [\#213](https://github.com/ai16z/eliza/issues/213)
- Anthropic API key not loading correctly [\#212](https://github.com/ai16z/eliza/issues/212)
- Templates are wrong [\#209](https://github.com/ai16z/eliza/issues/209)
- Changelog generator [\#181](https://github.com/ai16z/eliza/issues/181)
- Prompt template overrides [\#166](https://github.com/ai16z/eliza/issues/166)
- Plugin System [\#159](https://github.com/ai16z/eliza/issues/159)
- Chattiness Slider/Respond to Bots setting in Discord [\#157](https://github.com/ai16z/eliza/issues/157)
- Abstract transcript provider [\#73](https://github.com/ai16z/eliza/issues/73)
- 🤖 Confidence Level Implementation [\#50](https://github.com/ai16z/eliza/issues/50)
- 📈 Trading Assistant Implementation [\#48](https://github.com/ai16z/eliza/issues/48)
- swap Dao action initital [\#196](https://github.com/ai16z/eliza/pull/196) ([MarcoMandar](https://github.com/MarcoMandar))

**Fixed bugs:**

- DTS Build error [\#401](https://github.com/ai16z/eliza/issues/401)
- build.sh crash [\#379](https://github.com/ai16z/eliza/issues/379)
- Node module version 127 vs 131 sqlite issue [\#337](https://github.com/ai16z/eliza/issues/337)
- Severe Bug - The program fails to start with the command 'pnpm start', urgent fix required [\#326](https://github.com/ai16z/eliza/issues/326)
- pnpm start reports an error and cannot be started. Why is this? I installed it according to the documentation steps. [\#288](https://github.com/ai16z/eliza/issues/288)
- Qucikstart guide doesn [\#283](https://github.com/ai16z/eliza/issues/283)
- inconsistent version of node  [\#269](https://github.com/ai16z/eliza/issues/269)
- ai16z.github.io/eliza page doesn't display properly in darkmode [\#268](https://github.com/ai16z/eliza/issues/268)
- Fresh install from main will not start with a characterfile [\#265](https://github.com/ai16z/eliza/issues/265)
- Issue with "cannot read properties of undefined" [\#238](https://github.com/ai16z/eliza/issues/238)
- .env is not being loaded or picked up in settings [\#229](https://github.com/ai16z/eliza/issues/229)
- agent & plugin-image-generation failed to build [\#227](https://github.com/ai16z/eliza/issues/227)
- Model provider loaded from char file should force lowercase, claude or anthropic should both work [\#211](https://github.com/ai16z/eliza/issues/211)
- AI provider API keys should work from character files [\#210](https://github.com/ai16z/eliza/issues/210)
- build docs locally gives errors [\#202](https://github.com/ai16z/eliza/issues/202)
- Telegram bot not returning responses [\#178](https://github.com/ai16z/eliza/issues/178)
- build docs doesn't seem to be working [\#176](https://github.com/ai16z/eliza/issues/176)
- Can't Update Character Personality After Modifications in defaultCharacter.ts [\#95](https://github.com/ai16z/eliza/issues/95)
- Time Interval of generateNewTweetLoop is not consistent with the comment [\#92](https://github.com/ai16z/eliza/issues/92)
- Execution gets stuck in a loop [\#70](https://github.com/ai16z/eliza/issues/70)
- Voice is not working, "null" from incoming messages [\#55](https://github.com/ai16z/eliza/issues/55)
- Fix name confusion [\#32](https://github.com/ai16z/eliza/issues/32)
- Fix memory mixing in Twitter generate [\#23](https://github.com/ai16z/eliza/issues/23)

**Closed issues:**

- Move cache into DB [\#403](https://github.com/ai16z/eliza/issues/403)
- Docs review [\#201](https://github.com/ai16z/eliza/issues/201)
- Commands for starting agents without character profiles [\#47](https://github.com/ai16z/eliza/issues/47)

**Merged pull requests:**

- feat: lerna an npm [\#428](https://github.com/ai16z/eliza/pull/428) ([ponderingdemocritus](https://github.com/ponderingdemocritus))
- fix: don't continue to load if a specified file is not found [\#426](https://github.com/ai16z/eliza/pull/426) ([odilitime](https://github.com/odilitime))
- fix: Update adapters.md psql schema [\#424](https://github.com/ai16z/eliza/pull/424) ([tarrencev](https://github.com/tarrencev))
- Readme update WSL  2 link added. [\#419](https://github.com/ai16z/eliza/pull/419) ([denizekiz](https://github.com/denizekiz))
- feat: unruggable on starknet [\#418](https://github.com/ai16z/eliza/pull/418) ([RedBeardEth](https://github.com/RedBeardEth))
- fix: removed ollama embeddings. fastembeddings or openai only [\#413](https://github.com/ai16z/eliza/pull/413) ([o-on-x](https://github.com/o-on-x))
- feat: services [\#412](https://github.com/ai16z/eliza/pull/412) ([ponderingdemocritus](https://github.com/ponderingdemocritus))
- Add italian README.md translation [\#411](https://github.com/ai16z/eliza/pull/411) ([fabrizioff](https://github.com/fabrizioff))
- docs: add GROK\_API\_KEY [\#409](https://github.com/ai16z/eliza/pull/409) ([whalelephant](https://github.com/whalelephant))
- fix: Fixes [\#407](https://github.com/ai16z/eliza/pull/407) ([ponderingdemocritus](https://github.com/ponderingdemocritus))
- fix: console [\#405](https://github.com/ai16z/eliza/pull/405) ([ponderingdemocritus](https://github.com/ponderingdemocritus))
- fix: Lint [\#404](https://github.com/ai16z/eliza/pull/404) ([ponderingdemocritus](https://github.com/ponderingdemocritus))
- fix: tsup build error \(client-twitter\) [\#402](https://github.com/ai16z/eliza/pull/402) ([leomercier](https://github.com/leomercier))
- feat: Create README\_ES.md [\#400](https://github.com/ai16z/eliza/pull/400) ([metadiver](https://github.com/metadiver))
- feat: unruggable [\#398](https://github.com/ai16z/eliza/pull/398) ([ponderingdemocritus](https://github.com/ponderingdemocritus))
- Register memory managers if passed to runtime [\#396](https://github.com/ai16z/eliza/pull/396) ([martincik](https://github.com/martincik))
- feat: video generation plugin [\#394](https://github.com/ai16z/eliza/pull/394) ([dorianjanezic](https://github.com/dorianjanezic))
- feat: Logging improvements [\#393](https://github.com/ai16z/eliza/pull/393) ([ponderingdemocritus](https://github.com/ponderingdemocritus))
- fix: client null [\#390](https://github.com/ai16z/eliza/pull/390) ([ponderingdemocritus](https://github.com/ponderingdemocritus))
- docs: refresh eliza's tagline, fix broken links, unify formatting for core concepts [\#389](https://github.com/ai16z/eliza/pull/389) ([wahndo](https://github.com/wahndo))
- Fix tweet truncation issue by truncating at complete sentences [\#388](https://github.com/ai16z/eliza/pull/388) ([boyaloxer](https://github.com/boyaloxer))
- feat: Contextual Twitter Threads + Spam Reduction [\#383](https://github.com/ai16z/eliza/pull/383) ([ropresearch](https://github.com/ropresearch))
- feat: client [\#382](https://github.com/ai16z/eliza/pull/382) ([ponderingdemocritus](https://github.com/ponderingdemocritus))
- fix: adds Groq to getTokenForProvider [\#381](https://github.com/ai16z/eliza/pull/381) ([bmgalego](https://github.com/bmgalego))
- docs: add Russian\(RU\) translation of README  [\#380](https://github.com/ai16z/eliza/pull/380) ([whonion](https://github.com/whonion))
- docs: Update README\_FR.md [\#377](https://github.com/ai16z/eliza/pull/377) ([xclicx](https://github.com/xclicx))
- docs: add Turkish \(TR\) translation of README [\#376](https://github.com/ai16z/eliza/pull/376) ([oguzserdar](https://github.com/oguzserdar))
- feat: Enhance Heurist Image Generation Settings and Image Handling [\#375](https://github.com/ai16z/eliza/pull/375) ([tsubasakong](https://github.com/tsubasakong))
- fix: ca for btc was spam/fake [\#374](https://github.com/ai16z/eliza/pull/374) ([thearyanag](https://github.com/thearyanag))
- feat: starknet token transfer [\#373](https://github.com/ai16z/eliza/pull/373) ([enitrat](https://github.com/enitrat))
- feat: install clients from plugin [\#371](https://github.com/ai16z/eliza/pull/371) ([ponderingdemocritus](https://github.com/ponderingdemocritus))
- feat: readme [\#370](https://github.com/ai16z/eliza/pull/370) ([ponderingdemocritus](https://github.com/ponderingdemocritus))
- default set to new standard  post time 90-180 type: post time [\#369](https://github.com/ai16z/eliza/pull/369) ([o-on-x](https://github.com/o-on-x))
- post time set in env [\#368](https://github.com/ai16z/eliza/pull/368) ([o-on-x](https://github.com/o-on-x))
- feat: Adding unit tests for start - Covering goals, defaultCharacters, relationships, evaulators, posts, database, messages [\#367](https://github.com/ai16z/eliza/pull/367) ([ai16z-demirix](https://github.com/ai16z-demirix))
- fix: bug in getRecentMessageInteractions not awating for promisses before formating [\#366](https://github.com/ai16z/eliza/pull/366) ([bmgalego](https://github.com/bmgalego))
- feat: \[Issue-185\] Token Provider Tests  [\#365](https://github.com/ai16z/eliza/pull/365) ([normand1](https://github.com/normand1))
- feat: update docs with new stream notes [\#364](https://github.com/ai16z/eliza/pull/364) ([madjin](https://github.com/madjin))
- update tweet interval to 90-180 mins [\#360](https://github.com/ai16z/eliza/pull/360) ([oguzserdar](https://github.com/oguzserdar))
- fix: openrouter 70b don't support 128000, changed to 405b in model.ts [\#356](https://github.com/ai16z/eliza/pull/356) ([denizekiz](https://github.com/denizekiz))
- feat: Complete Starknet DB Trust [\#355](https://github.com/ai16z/eliza/pull/355) ([ponderingdemocritus](https://github.com/ponderingdemocritus))
- fix: solana [\#354](https://github.com/ai16z/eliza/pull/354) ([ponderingdemocritus](https://github.com/ponderingdemocritus))
- Add Community & contact and Star History [\#353](https://github.com/ai16z/eliza/pull/353) ([thejoven](https://github.com/thejoven))
- feat: trust db [\#349](https://github.com/ai16z/eliza/pull/349) ([ponderingdemocritus](https://github.com/ponderingdemocritus))
- change default configuration of Heurist [\#348](https://github.com/ai16z/eliza/pull/348) ([wjw12](https://github.com/wjw12))
- trust fixes [\#347](https://github.com/ai16z/eliza/pull/347) ([MarcoMandar](https://github.com/MarcoMandar))
- fix: some trust fixes [\#346](https://github.com/ai16z/eliza/pull/346) ([lalalune](https://github.com/lalalune))
- getOrCreateRecommenderWithTelegramId [\#345](https://github.com/ai16z/eliza/pull/345) ([MarcoMandar](https://github.com/MarcoMandar))
- fix: imports and cleanups [\#344](https://github.com/ai16z/eliza/pull/344) ([ponderingdemocritus](https://github.com/ponderingdemocritus))
- fix: dev build [\#343](https://github.com/ai16z/eliza/pull/343) ([ponderingdemocritus](https://github.com/ponderingdemocritus))
-  Update Heurist Integration Documentation and Examples [\#339](https://github.com/ai16z/eliza/pull/339) ([tsubasakong](https://github.com/tsubasakong))
- added clientConfig to optionally ignore bots and DMs [\#336](https://github.com/ai16z/eliza/pull/336) ([vivoidos](https://github.com/vivoidos))
- feat: Add Heurist API Integration as New Model Provider [\#335](https://github.com/ai16z/eliza/pull/335) ([tsubasakong](https://github.com/tsubasakong))
- Docs: additional Quickstart clarification and improvements [\#334](https://github.com/ai16z/eliza/pull/334) ([odilitime](https://github.com/odilitime))
- Docs: README.md improvements: clarify testing, add additional docker information [\#333](https://github.com/ai16z/eliza/pull/333) ([odilitime](https://github.com/odilitime))
- fix: Build error for packages requiring @ai16z/eliza [\#331](https://github.com/ai16z/eliza/pull/331) ([shakkernerd](https://github.com/shakkernerd))
- claude vertex configs added to generation.ts \(was missing\) [\#330](https://github.com/ai16z/eliza/pull/330) ([denizekiz](https://github.com/denizekiz))
- README\_KOR.md Korean version edited by a Korean  [\#329](https://github.com/ai16z/eliza/pull/329) ([zo-eth](https://github.com/zo-eth))
- Save Trade on creation to the backend [\#328](https://github.com/ai16z/eliza/pull/328) ([MarcoMandar](https://github.com/MarcoMandar))
- Update Quickstart Guide [\#325](https://github.com/ai16z/eliza/pull/325) ([odilitime](https://github.com/odilitime))
- utils.ts example tweet splitting [\#323](https://github.com/ai16z/eliza/pull/323) ([o-on-x](https://github.com/o-on-x))
- Fix broken docs [\#321](https://github.com/ai16z/eliza/pull/321) ([madjin](https://github.com/madjin))
- docs: add a new Portuguese README version [\#320](https://github.com/ai16z/eliza/pull/320) ([gabrielsants](https://github.com/gabrielsants))
- added working pumpfun.ts [\#313](https://github.com/ai16z/eliza/pull/313) ([o-on-x](https://github.com/o-on-x))
- Add Korean and French README [\#312](https://github.com/ai16z/eliza/pull/312) ([BugByClaude](https://github.com/BugByClaude))
- fix service call patterns but needs testing [\#311](https://github.com/ai16z/eliza/pull/311) ([lalalune](https://github.com/lalalune))
- Increased llama and llama based model temperatures [\#310](https://github.com/ai16z/eliza/pull/310) ([alanneary17](https://github.com/alanneary17))
- \[LLM Object Generation\]\[1/2\] Leverage AI Lib's Generate Object instead of parsing strings [\#309](https://github.com/ai16z/eliza/pull/309) ([monilpat](https://github.com/monilpat))
- Telegram client refactor for bot info availability [\#308](https://github.com/ai16z/eliza/pull/308) ([ropresearch](https://github.com/ropresearch))
- docs: add a new Japanese README [\#307](https://github.com/ai16z/eliza/pull/307) ([eltociear](https://github.com/eltociear))
- telegram: start agent after client initialization [\#304](https://github.com/ai16z/eliza/pull/304) ([o-on-x](https://github.com/o-on-x))
- add node version check [\#299](https://github.com/ai16z/eliza/pull/299) ([thearyanag](https://github.com/thearyanag))
- Added Transfer / Send Token Action [\#297](https://github.com/ai16z/eliza/pull/297) ([o-on-x](https://github.com/o-on-x))
- Added missing GROK model provider key initialization [\#296](https://github.com/ai16z/eliza/pull/296) ([FabriceIRANKUNDA](https://github.com/FabriceIRANKUNDA))
- Dockerized application for local development, testing and deployment [\#293](https://github.com/ai16z/eliza/pull/293) ([pindaroso](https://github.com/pindaroso))
- feat: Starknet plugin [\#287](https://github.com/ai16z/eliza/pull/287) ([ponderingdemocritus](https://github.com/ponderingdemocritus))
- Loaf stuff [\#286](https://github.com/ai16z/eliza/pull/286) ([lalalune](https://github.com/lalalune))
- Bundles [\#285](https://github.com/ai16z/eliza/pull/285) ([ponderingdemocritus](https://github.com/ponderingdemocritus))
- Don't blow up if the wallet is missing [\#281](https://github.com/ai16z/eliza/pull/281) ([ferric-sol](https://github.com/ferric-sol))
- docs homepage rework [\#280](https://github.com/ai16z/eliza/pull/280) ([mrpspring](https://github.com/mrpspring))
- fix docs: add python as a prerequisite \(needed for node-gyp\) [\#277](https://github.com/ai16z/eliza/pull/277) ([metadiver](https://github.com/metadiver))
- Fix: compute unit increasein swapts, default is too low to make trans… [\#276](https://github.com/ai16z/eliza/pull/276) ([denizekiz](https://github.com/denizekiz))
- add modelProvider to json to resolve embeddings error [\#274](https://github.com/ai16z/eliza/pull/274) ([twilwa](https://github.com/twilwa))
- Improve Docs [\#273](https://github.com/ai16z/eliza/pull/273) ([madjin](https://github.com/madjin))
- fix: docs features darkmode color [\#266](https://github.com/ai16z/eliza/pull/266) ([fabianhug](https://github.com/fabianhug))
- twitter-profile-remake [\#263](https://github.com/ai16z/eliza/pull/263) ([alextitonis](https://github.com/alextitonis))
- cachedEmbeddings fix [\#262](https://github.com/ai16z/eliza/pull/262) ([dorianjanezic](https://github.com/dorianjanezic))
- Fix embedding calculation for sqlite [\#261](https://github.com/ai16z/eliza/pull/261) ([ferric-sol](https://github.com/ferric-sol))
- Fix: changed claude-3-5-haiku to claude-3-5-haiku-20241022 for fixing… [\#257](https://github.com/ai16z/eliza/pull/257) ([denizekiz](https://github.com/denizekiz))
- bigint support in logger [\#256](https://github.com/ai16z/eliza/pull/256) ([o-on-x](https://github.com/o-on-x))
- embedding set to use openai endpoint when using openai embeddings [\#255](https://github.com/ai16z/eliza/pull/255) ([o-on-x](https://github.com/o-on-x))
- refactor embeddings  [\#254](https://github.com/ai16z/eliza/pull/254) ([o-on-x](https://github.com/o-on-x))
- Update docs [\#253](https://github.com/ai16z/eliza/pull/253) ([madjin](https://github.com/madjin))
- use openai embeddings setting [\#252](https://github.com/ai16z/eliza/pull/252) ([o-on-x](https://github.com/o-on-x))
- recommendations, token info, client auto [\#250](https://github.com/ai16z/eliza/pull/250) ([MarcoMandar](https://github.com/MarcoMandar))
- add verbose config with logger [\#249](https://github.com/ai16z/eliza/pull/249) ([v1xingyue](https://github.com/v1xingyue))
- trust integration [\#248](https://github.com/ai16z/eliza/pull/248) ([MarcoMandar](https://github.com/MarcoMandar))
- Working PostGres Adapter [\#247](https://github.com/ai16z/eliza/pull/247) ([cvartanian](https://github.com/cvartanian))
- Support google models in generation [\#246](https://github.com/ai16z/eliza/pull/246) ([parzival418](https://github.com/parzival418))
- Added OpenRouter model provider [\#245](https://github.com/ai16z/eliza/pull/245) ([o-on-x](https://github.com/o-on-x))
- update docs [\#233](https://github.com/ai16z/eliza/pull/233) ([madjin](https://github.com/madjin))
- Update Docs [\#231](https://github.com/ai16z/eliza/pull/231) ([madjin](https://github.com/madjin))
- plugin-image-generation tsconfig.json fix & ollama error handling [\#228](https://github.com/ai16z/eliza/pull/228) ([o-on-x](https://github.com/o-on-x))
- move code out to plugins, adapters and clients [\#225](https://github.com/ai16z/eliza/pull/225) ([lalalune](https://github.com/lalalune))
- models.gguf stored in models file, & tsconfig changes for ref @eliza/core & other things [\#224](https://github.com/ai16z/eliza/pull/224) ([o-on-x](https://github.com/o-on-x))
- Add OLLAMA as Model Provider  [\#221](https://github.com/ai16z/eliza/pull/221) ([o-on-x](https://github.com/o-on-x))
- lazy load llama [\#220](https://github.com/ai16z/eliza/pull/220) ([lalalune](https://github.com/lalalune))
- Implement grok beta [\#216](https://github.com/ai16z/eliza/pull/216) ([MeDott29](https://github.com/MeDott29))
- Abstracts Eliza into a Package to enble publishing onto NPM along with plugin system [\#214](https://github.com/ai16z/eliza/pull/214) ([ponderingdemocritus](https://github.com/ponderingdemocritus))
- add the template overrides [\#207](https://github.com/ai16z/eliza/pull/207) ([lalalune](https://github.com/lalalune))
- Shaw fix characters paths, .ts requirement and missings args [\#204](https://github.com/ai16z/eliza/pull/204) ([lalalune](https://github.com/lalalune))
- Fix Discord Voice and DMs [\#203](https://github.com/ai16z/eliza/pull/203) ([lalalune](https://github.com/lalalune))
- Major documentation updates [\#199](https://github.com/ai16z/eliza/pull/199) ([madjin](https://github.com/madjin))
- Add RedPill API Support [\#198](https://github.com/ai16z/eliza/pull/198) ([HashWarlock](https://github.com/HashWarlock))
- Swap functionality [\#197](https://github.com/ai16z/eliza/pull/197) ([lalalune](https://github.com/lalalune))
- Updated documentation [\#195](https://github.com/ai16z/eliza/pull/195) ([atvonsc](https://github.com/atvonsc))
- Groq api integration [\#194](https://github.com/ai16z/eliza/pull/194) ([juke](https://github.com/juke))

## [v0.0.10](https://github.com/ai16z/eliza/tree/v0.0.10) (2024-11-04)

[Full Changelog](https://github.com/ai16z/eliza/compare/v0.0.9...v0.0.10)

## [v0.0.9](https://github.com/ai16z/eliza/tree/v0.0.9) (2024-11-04)

[Full Changelog](https://github.com/ai16z/eliza/compare/v0.0.8...v0.0.9)

## [v0.0.8](https://github.com/ai16z/eliza/tree/v0.0.8) (2024-11-04)

[Full Changelog](https://github.com/ai16z/eliza/compare/v0.0.7...v0.0.8)

## [v0.0.7](https://github.com/ai16z/eliza/tree/v0.0.7) (2024-11-04)

[Full Changelog](https://github.com/ai16z/eliza/compare/v0.0.6...v0.0.7)

## [v0.0.6](https://github.com/ai16z/eliza/tree/v0.0.6) (2024-11-04)

[Full Changelog](https://github.com/ai16z/eliza/compare/v0.0.5...v0.0.6)

## [v0.0.5](https://github.com/ai16z/eliza/tree/v0.0.5) (2024-11-04)

[Full Changelog](https://github.com/ai16z/eliza/compare/v0.0.4...v0.0.5)

## [v0.0.4](https://github.com/ai16z/eliza/tree/v0.0.4) (2024-11-04)

[Full Changelog](https://github.com/ai16z/eliza/compare/v0.0.3...v0.0.4)

## [v0.0.3](https://github.com/ai16z/eliza/tree/v0.0.3) (2024-11-04)

[Full Changelog](https://github.com/ai16z/eliza/compare/v0.0.2...v0.0.3)

**Closed issues:**

- Get CI/CD working [\#174](https://github.com/ai16z/eliza/issues/174)

**Merged pull requests:**

- Update generate-changelog.yml [\#192](https://github.com/ai16z/eliza/pull/192) ([sirkitree](https://github.com/sirkitree))

## [v0.0.2](https://github.com/ai16z/eliza/tree/v0.0.2) (2024-11-03)

[Full Changelog](https://github.com/ai16z/eliza/compare/v0.0.1...v0.0.2)

**Implemented enhancements:**

- Set Port Number in Env to Run Multiple Instances [\#156](https://github.com/ai16z/eliza/issues/156)
- Renovate bot for automated updates on dependencies [\#58](https://github.com/ai16z/eliza/issues/58)
- How to chat directly with agent [\#40](https://github.com/ai16z/eliza/issues/40)
- Telegram Improvements [\#35](https://github.com/ai16z/eliza/issues/35)
- Make sure app runs purely on char files, no process.env, and vice versa [\#30](https://github.com/ai16z/eliza/issues/30)
- Image Generation [\#22](https://github.com/ai16z/eliza/issues/22)
- Telegram Bot [\#21](https://github.com/ai16z/eliza/issues/21)
- Multi-model abstraction [\#19](https://github.com/ai16z/eliza/issues/19)
- updates to order book and trust score, virtual confidence, last active, decay score, validation trust, multiple recommenders [\#175](https://github.com/ai16z/eliza/pull/175) ([MarcoMandar](https://github.com/MarcoMandar))
- Trustscore, token-performance, token performance simulation [\#101](https://github.com/ai16z/eliza/pull/101) ([MarcoMandar](https://github.com/MarcoMandar))

**Fixed bugs:**

- TypeError: Cannot read properties of null \(reading 'queueTextCompletion'\) [\#168](https://github.com/ai16z/eliza/issues/168)
- TypeError: Promise.withResolvers is not a function [\#76](https://github.com/ai16z/eliza/issues/76)
- sqlite\_vss unsupported on win32-x64 [\#37](https://github.com/ai16z/eliza/issues/37)

**Closed issues:**

- Make sure 100% works with local models [\#69](https://github.com/ai16z/eliza/issues/69)
- shouldRespond handler for twitter interactions [\#68](https://github.com/ai16z/eliza/issues/68)
- docs [\#34](https://github.com/ai16z/eliza/issues/34)

**Merged pull requests:**

- 181  generate changelog [\#182](https://github.com/ai16z/eliza/pull/182) ([sirkitree](https://github.com/sirkitree))
- server port in env [\#179](https://github.com/ai16z/eliza/pull/179) ([alextitonis](https://github.com/alextitonis))
- prettier log setup, minor cleanups [\#177](https://github.com/ai16z/eliza/pull/177) ([ponderingdemocritus](https://github.com/ponderingdemocritus))
- postgres updates [\#173](https://github.com/ai16z/eliza/pull/173) ([minghinmatthewlam](https://github.com/minghinmatthewlam))
- adjusting test setup and adding a basic test [\#172](https://github.com/ai16z/eliza/pull/172) ([sirkitree](https://github.com/sirkitree))
- feat: Shorten response verbosity [\#170](https://github.com/ai16z/eliza/pull/170) ([bigsky77](https://github.com/bigsky77))
- clean up index [\#163](https://github.com/ai16z/eliza/pull/163) ([ponderingdemocritus](https://github.com/ponderingdemocritus))
- Import work and cleanup [\#162](https://github.com/ai16z/eliza/pull/162) ([ponderingdemocritus](https://github.com/ponderingdemocritus))
- type export structure [\#160](https://github.com/ai16z/eliza/pull/160) ([ponderingdemocritus](https://github.com/ponderingdemocritus))
- Update ci.yaml [\#155](https://github.com/ai16z/eliza/pull/155) ([sirkitree](https://github.com/sirkitree))
- Create pull\_request\_template.md [\#154](https://github.com/ai16z/eliza/pull/154) ([sirkitree](https://github.com/sirkitree))
- fixed issue with openai [\#153](https://github.com/ai16z/eliza/pull/153) ([ponderingdemocritus](https://github.com/ponderingdemocritus))
- update docs [\#152](https://github.com/ai16z/eliza/pull/152) ([madjin](https://github.com/madjin))
- fix name of ImageGeneration.ts [\#151](https://github.com/ai16z/eliza/pull/151) ([twilwa](https://github.com/twilwa))
- Feat/mono [\#150](https://github.com/ai16z/eliza/pull/150) ([ponderingdemocritus](https://github.com/ponderingdemocritus))
- update docs [\#149](https://github.com/ai16z/eliza/pull/149) ([madjin](https://github.com/madjin))
- Dependency update testing [\#147](https://github.com/ai16z/eliza/pull/147) ([sirkitree](https://github.com/sirkitree))
- chore\(deps\): Upgrade uuid to v11 and TypeScript to v8 [\#143](https://github.com/ai16z/eliza/pull/143) ([5c0](https://github.com/5c0))
- fix\(deps\): update dependency uuid to v11 [\#142](https://github.com/ai16z/eliza/pull/142) ([renovate[bot]](https://github.com/apps/renovate))
- chore\(deps\): update typescript and related to v8 \(major\) [\#141](https://github.com/ai16z/eliza/pull/141) ([renovate[bot]](https://github.com/apps/renovate))
- chore\(deps\): update eslint and formatting \(major\) [\#139](https://github.com/ai16z/eliza/pull/139) ([renovate[bot]](https://github.com/apps/renovate))
- chore\(deps\): update dependency typedoc-plugin-markdown to v4 [\#138](https://github.com/ai16z/eliza/pull/138) ([renovate[bot]](https://github.com/apps/renovate))
- chore\(deps\): update dependency rimraf to v6 - autoclosed [\#137](https://github.com/ai16z/eliza/pull/137) ([renovate[bot]](https://github.com/apps/renovate))
- chore\(deps\): update dependency npm-run-all2 to v7 [\#136](https://github.com/ai16z/eliza/pull/136) ([renovate[bot]](https://github.com/apps/renovate))
- chore\(deps\): update dependency itty-router to v5 [\#135](https://github.com/ai16z/eliza/pull/135) ([renovate[bot]](https://github.com/apps/renovate))
- chore\(deps\): update dependency docusaurus-plugin-typedoc to v1 [\#134](https://github.com/ai16z/eliza/pull/134) ([renovate[bot]](https://github.com/apps/renovate))
- chore\(deps\): update dependency @types/node to v22 [\#133](https://github.com/ai16z/eliza/pull/133) ([renovate[bot]](https://github.com/apps/renovate))
- chore\(deps\): update dependency @types/jest to v29 [\#132](https://github.com/ai16z/eliza/pull/132) ([renovate[bot]](https://github.com/apps/renovate))
- fix\(deps\): update react monorepo to v18.3.1 [\#131](https://github.com/ai16z/eliza/pull/131) ([renovate[bot]](https://github.com/apps/renovate))
- fix\(deps\): update docusaurus monorepo to v3.5.2 [\#130](https://github.com/ai16z/eliza/pull/130) ([renovate[bot]](https://github.com/apps/renovate))
- fix\(deps\): update dependency sql.js to v1.12.0 [\#129](https://github.com/ai16z/eliza/pull/129) ([renovate[bot]](https://github.com/apps/renovate))
- fix\(deps\): update dependency react-router-dom to v6.27.0 [\#128](https://github.com/ai16z/eliza/pull/128) ([renovate[bot]](https://github.com/apps/renovate))
- fix\(deps\): update dependency prism-react-renderer to v2.4.0 [\#127](https://github.com/ai16z/eliza/pull/127) ([renovate[bot]](https://github.com/apps/renovate))
- fix\(deps\): update dependency playwright to v1.48.2 [\#126](https://github.com/ai16z/eliza/pull/126) ([renovate[bot]](https://github.com/apps/renovate))
- fix\(deps\): update dependency pdfjs-dist to v4.7.76 [\#125](https://github.com/ai16z/eliza/pull/125) ([renovate[bot]](https://github.com/apps/renovate))
- fix\(deps\): update dependency onnxruntime-node to v1.20.0 - autoclosed [\#124](https://github.com/ai16z/eliza/pull/124) ([renovate[bot]](https://github.com/apps/renovate))
- fix\(deps\): update dependency node-llama-cpp to v3.1.1 [\#123](https://github.com/ai16z/eliza/pull/123) ([renovate[bot]](https://github.com/apps/renovate))
- fix\(deps\): update dependency jieba-wasm to v2.2.0 [\#122](https://github.com/ai16z/eliza/pull/122) ([renovate[bot]](https://github.com/apps/renovate))
- fix\(deps\): update dependency figlet to v1.8.0 [\#121](https://github.com/ai16z/eliza/pull/121) ([renovate[bot]](https://github.com/apps/renovate))
- fix\(deps\): update dependency better-sqlite3 to v11.5.0 [\#120](https://github.com/ai16z/eliza/pull/120) ([renovate[bot]](https://github.com/apps/renovate))
- fix\(deps\): update dependency @supabase/supabase-js to v2.46.1 [\#119](https://github.com/ai16z/eliza/pull/119) ([renovate[bot]](https://github.com/apps/renovate))
- fix\(deps\): update dependency @mdx-js/react to v3.1.0 [\#118](https://github.com/ai16z/eliza/pull/118) ([renovate[bot]](https://github.com/apps/renovate))
- fix\(deps\): update dependency @echogarden/speex-resampler-wasm to v0.2.1 [\#117](https://github.com/ai16z/eliza/pull/117) ([renovate[bot]](https://github.com/apps/renovate))
- fix\(deps\): update dependency @echogarden/kissfft-wasm to v0.2.0 [\#116](https://github.com/ai16z/eliza/pull/116) ([renovate[bot]](https://github.com/apps/renovate))
- fix\(deps\): update dependency @echogarden/espeak-ng-emscripten to v0.3.0 [\#115](https://github.com/ai16z/eliza/pull/115) ([renovate[bot]](https://github.com/apps/renovate))
- fix\(deps\): update dependency @cliqz/adblocker-playwright to v1.34.0 [\#114](https://github.com/ai16z/eliza/pull/114) ([renovate[bot]](https://github.com/apps/renovate))
- fix\(deps\): pin dependencies [\#113](https://github.com/ai16z/eliza/pull/113) ([renovate[bot]](https://github.com/apps/renovate))
- chore\(deps\): update dependency @rollup/plugin-terser to v0.4.4 [\#112](https://github.com/ai16z/eliza/pull/112) ([renovate[bot]](https://github.com/apps/renovate))
- chore\(deps\): update dependency wrangler to v3.84.0 [\#111](https://github.com/ai16z/eliza/pull/111) ([renovate[bot]](https://github.com/apps/renovate))
- chore\(deps\): update dependency typedoc to v0.26.10 [\#110](https://github.com/ai16z/eliza/pull/110) ([renovate[bot]](https://github.com/apps/renovate))
- chore\(deps\): update dependency @types/node to v20.17.3 [\#109](https://github.com/ai16z/eliza/pull/109) ([renovate[bot]](https://github.com/apps/renovate))
- fix\(deps\): update dependency socket.io to v4.8.1 [\#108](https://github.com/ai16z/eliza/pull/108) ([renovate[bot]](https://github.com/apps/renovate))
- fix\(deps\): update dependency nodemon to v3.1.7 [\#107](https://github.com/ai16z/eliza/pull/107) ([renovate[bot]](https://github.com/apps/renovate))
- fix\(deps\): update dependency clsx to v2.1.1 [\#106](https://github.com/ai16z/eliza/pull/106) ([renovate[bot]](https://github.com/apps/renovate))
- fix\(deps\): update dependency @diffusionstudio/vits-web to v1.0.3 [\#105](https://github.com/ai16z/eliza/pull/105) ([renovate[bot]](https://github.com/apps/renovate))
- chore\(deps\): update dependency npm-run-all2 to v5.0.2 [\#104](https://github.com/ai16z/eliza/pull/104) ([renovate[bot]](https://github.com/apps/renovate))
- Postgres DB Adapter [\#102](https://github.com/ai16z/eliza/pull/102) ([leomercier](https://github.com/leomercier))
- chore\(deps\): update dependency @types/fluent-ffmpeg to v2.1.27 [\#100](https://github.com/ai16z/eliza/pull/100) ([renovate[bot]](https://github.com/apps/renovate))
- fix\(deps\): pin dependency socket.io to 4.8.0 [\#99](https://github.com/ai16z/eliza/pull/99) ([renovate[bot]](https://github.com/apps/renovate))
- fix\(deps\): pin dependencies [\#98](https://github.com/ai16z/eliza/pull/98) ([renovate[bot]](https://github.com/apps/renovate))
- fix\(deps\): update dependency discord.js to v14.16.3 [\#97](https://github.com/ai16z/eliza/pull/97) ([renovate[bot]](https://github.com/apps/renovate))
- chore\(deps\): update dependency eslint to v8.57.1 [\#96](https://github.com/ai16z/eliza/pull/96) ([renovate[bot]](https://github.com/apps/renovate))
- fix\(deps\): pin dependencies [\#94](https://github.com/ai16z/eliza/pull/94) ([renovate[bot]](https://github.com/apps/renovate))
- fix\(deps\): pin dependencies [\#93](https://github.com/ai16z/eliza/pull/93) ([renovate[bot]](https://github.com/apps/renovate))
- chore\(deps\): pin dependencies [\#90](https://github.com/ai16z/eliza/pull/90) ([renovate[bot]](https://github.com/apps/renovate))
- chore\(deps\): update dependency tslib to v2.8.0 [\#89](https://github.com/ai16z/eliza/pull/89) ([renovate[bot]](https://github.com/apps/renovate))
- fix\(deps\): pin dependencies [\#88](https://github.com/ai16z/eliza/pull/88) ([renovate[bot]](https://github.com/apps/renovate))
- chore\(deps\): pin dependencies [\#87](https://github.com/ai16z/eliza/pull/87) ([renovate[bot]](https://github.com/apps/renovate))
- chore\(deps\): pin dependencies [\#86](https://github.com/ai16z/eliza/pull/86) ([renovate[bot]](https://github.com/apps/renovate))
- chore\(deps\): update rollup and plugins [\#85](https://github.com/ai16z/eliza/pull/85) ([renovate[bot]](https://github.com/apps/renovate))
- chore\(deps\): pin dependencies [\#84](https://github.com/ai16z/eliza/pull/84) ([renovate[bot]](https://github.com/apps/renovate))
- chore\(deps\): pin dependencies [\#83](https://github.com/ai16z/eliza/pull/83) ([renovate[bot]](https://github.com/apps/renovate))
- chore\(deps\): replace dependency npm-run-all with npm-run-all2 5.0.0 [\#82](https://github.com/ai16z/eliza/pull/82) ([renovate[bot]](https://github.com/apps/renovate))
- chore\(config\): migrate renovate config [\#80](https://github.com/ai16z/eliza/pull/80) ([renovate[bot]](https://github.com/apps/renovate))
- fix\(deps\): update dependency pdfjs-dist to v4.2.67 \[security\] [\#78](https://github.com/ai16z/eliza/pull/78) ([renovate[bot]](https://github.com/apps/renovate))
- chore\(deps\): update dependency rollup to v2.79.2 \[security\] [\#77](https://github.com/ai16z/eliza/pull/77) ([renovate[bot]](https://github.com/apps/renovate))
- Model provider abstraction [\#74](https://github.com/ai16z/eliza/pull/74) ([lalalune](https://github.com/lalalune))
- Image gen [\#44](https://github.com/ai16z/eliza/pull/44) ([alextitonis](https://github.com/alextitonis))

## [v0.0.1](https://github.com/ai16z/eliza/tree/v0.0.1) (2024-10-29)

[Full Changelog](https://github.com/ai16z/eliza/compare/e5a15663d7d083f4c9b82634a0696b80b9ecd0b2...v0.0.1)

**Closed issues:**

- cleanup remnants of sqlite\_vss [\#66](https://github.com/ai16z/eliza/issues/66)
- Create issue templates [\#61](https://github.com/ai16z/eliza/issues/61)
- Contributing [\#45](https://github.com/ai16z/eliza/issues/45)
- How to specify a character file [\#39](https://github.com/ai16z/eliza/issues/39)
- Easy switching between openai and llama [\#15](https://github.com/ai16z/eliza/issues/15)
- Get image media from Discord and describe it [\#14](https://github.com/ai16z/eliza/issues/14)
- Summarize links from Discord and Twitter [\#13](https://github.com/ai16z/eliza/issues/13)
- Get image media from tweets and describe it [\#11](https://github.com/ai16z/eliza/issues/11)
- Feed Twitter Client [\#10](https://github.com/ai16z/eliza/issues/10)
- Replace Elevenlabs with faster TTS [\#6](https://github.com/ai16z/eliza/issues/6)
- Integrate Moondream into Twitter and Discord [\#5](https://github.com/ai16z/eliza/issues/5)
- Replace GPT-3.5 with Node Llama3 [\#3](https://github.com/ai16z/eliza/issues/3)
- Replace OpenAI Whisper with Whisper Turbo [\#2](https://github.com/ai16z/eliza/issues/2)
- Integrate agent-twitter-client [\#1](https://github.com/ai16z/eliza/issues/1)

**Merged pull requests:**

- chore: fix typo [\#71](https://github.com/ai16z/eliza/pull/71) ([eltociear](https://github.com/eltociear))
- cleanup from \#60, resolves \#66 [\#67](https://github.com/ai16z/eliza/pull/67) ([sirkitree](https://github.com/sirkitree))
- Telegram Integration with shouldRespond handler + image recognition [\#65](https://github.com/ai16z/eliza/pull/65) ([dreaminglucid](https://github.com/dreaminglucid))
- Initial commit for adding Renovate autoupdater. [\#63](https://github.com/ai16z/eliza/pull/63) ([mrdavidburns](https://github.com/mrdavidburns))
- adding github issue templates [\#62](https://github.com/ai16z/eliza/pull/62) ([sirkitree](https://github.com/sirkitree))
- sqlite\_vss issue [\#60](https://github.com/ai16z/eliza/pull/60) ([MarcoMandar](https://github.com/MarcoMandar))
- Clarifying instructions to run locally [\#59](https://github.com/ai16z/eliza/pull/59) ([ferric-sol](https://github.com/ferric-sol))
- corrected node-llama-cpp command [\#57](https://github.com/ai16z/eliza/pull/57) ([Honkware](https://github.com/Honkware))
- Adding a CONTRIBUTING.md [\#46](https://github.com/ai16z/eliza/pull/46) ([sirkitree](https://github.com/sirkitree))
- pumpfun [\#43](https://github.com/ai16z/eliza/pull/43) ([MarcoMandar](https://github.com/MarcoMandar))
- provide a way to chat directly with the agent via the command line  [\#42](https://github.com/ai16z/eliza/pull/42) ([sirkitree](https://github.com/sirkitree))
- Update README.md [\#41](https://github.com/ai16z/eliza/pull/41) ([sirkitree](https://github.com/sirkitree))
- Update README.md [\#36](https://github.com/ai16z/eliza/pull/36) ([wahndo](https://github.com/wahndo))
- Telegram [\#31](https://github.com/ai16z/eliza/pull/31) ([lalalune](https://github.com/lalalune))
- token provider [\#24](https://github.com/ai16z/eliza/pull/24) ([MarcoMandar](https://github.com/MarcoMandar))
- minor fixes to base.ts and llama.ts, resolved missing package.json im… [\#20](https://github.com/ai16z/eliza/pull/20) ([twilwa](https://github.com/twilwa))
- More twitter upgrades and refactoring [\#18](https://github.com/ai16z/eliza/pull/18) ([lalalune](https://github.com/lalalune))
- Refactor, Plumbing, Twitter Agent [\#17](https://github.com/ai16z/eliza/pull/17) ([lalalune](https://github.com/lalalune))
- Integrate Moondream into Twitter and Discord [\#16](https://github.com/ai16z/eliza/pull/16) ([vladkashka56](https://github.com/vladkashka56))
- New Twitter Client [\#8](https://github.com/ai16z/eliza/pull/8) ([lalalune](https://github.com/lalalune))



\* *This Changelog was automatically generated by [github_changelog_generator](https://github.com/github-changelog-generator/github-changelog-generator)*
