# @ai16z/eliza v0.1.6-alpha.4

## Enumerations

- [GoalStatus](enumerations/GoalStatus.md)
- [ModelClass](enumerations/ModelClass.md)
- [ModelProviderName](enumerations/ModelProviderName.md)
- [Clients](enumerations/Clients.md)
- [ServiceType](enumerations/ServiceType.md)
- [LoggingLevel](enumerations/LoggingLevel.md)

## Classes

- [MemoryCacheAdapter](classes/MemoryCacheAdapter.md)
- [FsCacheAdapter](classes/FsCacheAdapter.md)
- [DbCacheAdapter](classes/DbCacheAdapter.md)
- [CacheManager](classes/CacheManager.md)
- [DatabaseAdapter](classes/DatabaseAdapter.md)
- [MemoryManager](classes/MemoryManager.md)
- [AgentRuntime](classes/AgentRuntime.md)
- [Service](classes/Service.md)

## Interfaces

- [ICacheAdapter](interfaces/ICacheAdapter.md)
- [GenerationOptions](interfaces/GenerationOptions.md)
- [Content](interfaces/Content.md)
- [ActionExample](interfaces/ActionExample.md)
- [ConversationExample](interfaces/ConversationExample.md)
- [Actor](interfaces/Actor.md)
- [Objective](interfaces/Objective.md)
- [Goal](interfaces/Goal.md)
- [State](interfaces/State.md)
- [Memory](interfaces/Memory.md)
- [MessageExample](interfaces/MessageExample.md)
- [Action](interfaces/Action.md)
- [EvaluationExample](interfaces/EvaluationExample.md)
- [Evaluator](interfaces/Evaluator.md)
- [Provider](interfaces/Provider.md)
- [Relationship](interfaces/Relationship.md)
- [Account](interfaces/Account.md)
- [Participant](interfaces/Participant.md)
- [Room](interfaces/Room.md)
- [IAgentConfig](interfaces/IAgentConfig.md)
- [IDatabaseAdapter](interfaces/IDatabaseAdapter.md)
- [IDatabaseCacheAdapter](interfaces/IDatabaseCacheAdapter.md)
- [IMemoryManager](interfaces/IMemoryManager.md)
- [ICacheManager](interfaces/ICacheManager.md)
- [IAgentRuntime](interfaces/IAgentRuntime.md)
- [IImageDescriptionService](interfaces/IImageDescriptionService.md)
- [ITranscriptionService](interfaces/ITranscriptionService.md)
- [IVideoService](interfaces/IVideoService.md)
- [ITextGenerationService](interfaces/ITextGenerationService.md)
- [IBrowserService](interfaces/IBrowserService.md)
- [ISpeechService](interfaces/ISpeechService.md)
- [IPdfService](interfaces/IPdfService.md)
- [IAwsS3Service](interfaces/IAwsS3Service.md)
- [ActionResponse](interfaces/ActionResponse.md)
- [ISlackService](interfaces/ISlackService.md)

## Type Aliases

- [EnvConfig](type-aliases/EnvConfig.md)
- [CharacterConfig](type-aliases/CharacterConfig.md)
- [UUID](type-aliases/UUID.md)
- [Model](type-aliases/Model.md)
- [Models](type-aliases/Models.md)
- [Handler](type-aliases/Handler.md)
- [HandlerCallback](type-aliases/HandlerCallback.md)
- [Validator](type-aliases/Validator.md)
- [Media](type-aliases/Media.md)
- [Client](type-aliases/Client.md)
- [Plugin](type-aliases/Plugin.md)
- [Character](type-aliases/Character.md)
- [CacheOptions](type-aliases/CacheOptions.md)
- [SearchResult](type-aliases/SearchResult.md)
- [SearchResponse](type-aliases/SearchResponse.md)
- [KnowledgeItem](type-aliases/KnowledgeItem.md)

## Variables

- [defaultCharacter](variables/defaultCharacter.md)
- [envSchema](variables/envSchema.md)
- [CharacterSchema](variables/CharacterSchema.md)
- [evaluationTemplate](variables/evaluationTemplate.md)
- [knowledge](variables/knowledge.md)
- [elizaLogger](variables/elizaLogger.md)
- [models](variables/models.md)
- [messageCompletionFooter](variables/messageCompletionFooter.md)
- [shouldRespondFooter](variables/shouldRespondFooter.md)
- [booleanFooter](variables/booleanFooter.md)
- [stringArrayFooter](variables/stringArrayFooter.md)
- [postActionResponseFooter](variables/postActionResponseFooter.md)
- [settings](variables/settings.md)

## Functions

- [composeActionExamples](functions/composeActionExamples.md)
- [formatActionNames](functions/formatActionNames.md)
- [formatActions](functions/formatActions.md)
- [composeContext](functions/composeContext.md)
- [addHeader](functions/addHeader.md)
- [getEmbeddingConfig](functions/getEmbeddingConfig.md)
- [getEmbeddingType](functions/getEmbeddingType.md)
- [getEmbeddingZeroVector](functions/getEmbeddingZeroVector.md)
- [embed](functions/embed.md)
- [validateEnv](functions/validateEnv.md)
- [validateCharacterConfig](functions/validateCharacterConfig.md)
- [formatEvaluatorNames](functions/formatEvaluatorNames.md)
- [formatEvaluators](functions/formatEvaluators.md)
- [formatEvaluatorExamples](functions/formatEvaluatorExamples.md)
- [formatEvaluatorExampleDescriptions](functions/formatEvaluatorExampleDescriptions.md)
- [generateText](functions/generateText.md)
- [trimTokens](functions/trimTokens.md)
- [generateShouldRespond](functions/generateShouldRespond.md)
- [splitChunks](functions/splitChunks.md)
- [generateTrueOrFalse](functions/generateTrueOrFalse.md)
- [generateTextArray](functions/generateTextArray.md)
- [generateObjectDeprecated](functions/generateObjectDeprecated.md)
- [generateObjectArray](functions/generateObjectArray.md)
- [generateMessageResponse](functions/generateMessageResponse.md)
- [generateImage](functions/generateImage.md)
- [generateCaption](functions/generateCaption.md)
- [generateWebSearch](functions/generateWebSearch.md)
- [generateObject](functions/generateObject.md)
- [handleProvider](functions/handleProvider.md)
- [generateTweetActions](functions/generateTweetActions.md)
- [getGoals](functions/getGoals.md)
- [formatGoalsAsString](functions/formatGoalsAsString.md)
- [updateGoal](functions/updateGoal.md)
- [createGoal](functions/createGoal.md)
- [getActorDetails](functions/getActorDetails.md)
- [formatActors](functions/formatActors.md)
- [formatMessages](functions/formatMessages.md)
- [formatTimestamp](functions/formatTimestamp.md)
- [getModel](functions/getModel.md)
- [getEndpoint](functions/getEndpoint.md)
- [parseShouldRespondFromText](functions/parseShouldRespondFromText.md)
- [parseBooleanFromText](functions/parseBooleanFromText.md)
- [parseJsonArrayFromText](functions/parseJsonArrayFromText.md)
- [parseJSONObjectFromText](functions/parseJSONObjectFromText.md)
- [parseActionResponseFromText](functions/parseActionResponseFromText.md)
- [formatPosts](functions/formatPosts.md)
- [getProviders](functions/getProviders.md)
- [createRelationship](functions/createRelationship.md)
- [getRelationship](functions/getRelationship.md)
- [getRelationships](functions/getRelationships.md)
- [formatRelationships](functions/formatRelationships.md)
- [findNearestEnvFile](functions/findNearestEnvFile.md)
- [configureSettings](functions/configureSettings.md)
- [loadEnvConfig](functions/loadEnvConfig.md)
- [getEnvVariable](functions/getEnvVariable.md)
- [hasEnvVariable](functions/hasEnvVariable.md)
- [stringToUuid](functions/stringToUuid.md)
