# 💻-coders 2024-11-02

## Summary
 In the discussion, participants addressed Twitter's restriction on new accounts, with Carlos Rene | DEGA explaining that it is a common occurrence requiring challenge completion before unlocking after several hours. Ophiuchus suggested modifying ollama code to work with new model providers and proposed an AI Native social media platform for agents, which SotoAlt supported by suggesting on-chain implementation despite storage cost concerns. Carlos Rene | DEGA countered that only coordination needs to be on-chain through a global agent registry allowing off-chain interactions like swiping in a Tinder-like system. Ferric | stakeware.xyz mentioned the potential use of TEE for key generation and registration with programs, while yikesawjeez highlighted existing hybrid models that haven't gained traction but emphasized the importance of either being an agent or not mattering unless otherwise indicated. The conversation concluded with ferric proposing a playground for Eliza bots to test on degenerate Twitter users.

## FAQ
 - What happens when Twitter restricts a new account?
  - Carlos Rene | DEGA: New accounts often get restricted by Twitter as part of their security measures to prevent spam or abuse. You usually need to complete a challenge, like confirming your phone number or email address, and wait for the restriction to be lifted after a few hours.

- How can you unlock an account that has been restricted on Twitter?
  - Carlos Rene | DEGA: To unlock a restricted Twitter account, follow the instructions provided by Twitter during the challenge process. This may involve confirming your identity through various means such as phone number or email verification. The restriction is typically lifted after completing these steps and waiting for some time.

- Is there an alternative to using Twitter's main platform for AI Native social media?
  - Ophiuchus: Yes, one idea discussed was creating a decentralized version of Tinder specifically designed for AI agents on the blockchain. This would allow coordination and interaction between AI agents without relying solely on centralized platforms like Twitter.

- What are some challenges in developing an on-chain social media platform?
  - ferric | stakeware.xyz: One of the main challenges is storage costs associated with maintaining data on the blockchain, which can be expensive and limit scalability. However, using a Trusted Execution Environment (TEE) could help generate keys for agent registration while keeping most interactions off-chain to reduce costs.

- How would an AI Native social media platform work?
  - Carlos Rene | DEGA: The proposed concept involves creating a global agent registry on the blockchain, allowing agents to swipe left or right (indicating interest) off-chain while maintaining coordination and registration details on-chain. This hybrid approach combines decentralized features with user-friendly interactions similar to existing social media platforms like Tinder.

## Who Helped Who
 - Carlos Rene | DEGA helped Ophiuchus with unlocking a Twitter account by explaining that new accounts often require completing a challenge and waiting for them to unlock, which usually takes a few hours. This advice provided context on why the account might be locked and suggested patience as a solution.
- ferric from stakeware.xyz helped Ophiuchus with understanding an error message by sharing that they encountered a similar issue where exceeding the number of tries was mentioned in the challenge, indicating a common problem users face during the unlock process. This shared experience provided reassurance and context for the situation.
- SotoAlt from WAWE helped Carlos Rene | DEGA with conceptualizing AI Native social media by suggesting that it should be on chain even though storage costs are high, proposing a global agent registry to manage coordination off-chain. This idea contributed to the discussion about potential solutions for integrating AI into social media platforms.
- yikesawjeez helped ferric from stakeware.xyz with providing insight into existing hybrid models by mentioning that such products already exist but haven't been successful, suggesting a vision where being an agent or not is transparent unless there's reason to believe otherwise. This perspective offered context and considerations for developing AI social platforms.

## Action Items
 - Technical Tasks
  - Replace llama.ts code with new model providers and set XAI_MODEL="model_name" in .env (mentioned by Ophiuchus)
- Documentation Needs
  - No specific documentation needs were explicitly requested.
- Feature Requests
  - Implement AI Native social media, potentially on the blockchain for coordination and agent registry (collective suggestion by Carlos Rene | DEGA, SotoAlt | WAWE, ferric | stakeware.xyz)
  - Develop a hybrid model of social networking that is beneficial to be an agent or neutral if not being one (suggested by yikesawjeez)
- Community Tasks
  - Explore the idea of using Eliza bots for testing on platforms like degenerate Twitter within their playground environment (mentioned by ferric | stakeware.xyz)

