# 💻-coders 2024-11-03

## Summary
 In the chat, SotoAlt provided guidance on editing tweets for spacing using Twitter's generate.ts feature to address an issue linked in a GitHub repository. They also discussed modifying interaction intervals within their codebase, specifically mentioning checks between 10-20 minutes and adjustments to search and engagement routines every 2-3 hours. SMA expressed gratitude for the collaborative environment, while big dookie shared insights on tweaking boredom statistics in AI models. Denko sought advice on building an AI agent, prompting responses from pmairca and Ruby suggesting starting with frameworks like TensorFlow or PyTorch and using Python with Flask for backend development. Ferric offered a resource link to Discord for further assistance and encouraged asking questions as needed.

## FAQ
 - How can I edit the time interval between interactions in a Twitter bot?
  - SotoAlt | WAWE: You can modify the time intervals by editing the code on `src/clients/twitter/interactions.ts`. The current setup checks for interactions every 10-20 minutes, focusing only on direct replies and mentions. For search and engagement tasks, you'll find related settings in the TwitterSearchClient with adjustable intervals (e.g., every 2-3 hours).

- Where can I learn to build an AI agent from scratch?
  - pmairca: Building an AI agent requires understanding both architecture and deployment. Start by learning a solid framework like TensorFlow or PyTorch, then explore cloud services such as AWS or Google Cloud for hosting your bot. Online tutorials are available that provide step-by-step guidance to help you through the process.
  - Ruby: Begin with Python and Flask for creating the backend of your AI agent. Once comfortable, look into deploying it using Docker by following some online tutorials. It's a matter of learning coding practices rather than complex concepts.

- Where can I find resources to learn about hosting an AI bot?
  - ferric | stakeware.xyz: You can start your journey on this Discord channel (https://discord.com/channels/1253563208833433701/1300025221834739744/1302408954374000712). Feel free to ask questions as you progress. This community can provide guidance and support for your learning process, including hosting an AI bot on various platforms.

## Who Helped Who
 - SMA helped YODȺ26 with understanding their presence in a community by expressing familiarity and comfort, indicating they've been part of it for some time.
- SotoAlt | WAWE assisted multiple users (YODȺ26, big dookie) by providing guidance on editing Twitter interaction intervals and addressing issues related to the Eliza project, ensuring their contributions were helpful in managing tweet spacing and integrating features into model providers.
- pmairca helped Denko with starting AI agent development by recommending foundational frameworks like TensorFlow or PyTorch for building the architecture and suggesting cloud services such as AWS or Google Cloud for deployment, providing a clear path forward.

## Action Items
 - Technical Tasks
  - Edit on Twitter/generate.ts for more spaced tweets (mentioned by SotoAlt | WAWE)
  - Modify the time interval between interactions in src/clients/twitter/interactions.ts to check between 10-20 mins, only direct replies, mentions, etc (mentioned by SotoAlt | WAWE)
  - Adjust intervals for search and engagement on TwitterSearchClient every 2-3 hours as needed (mentioned by SotoAlt | WAWE)

- Documentation Needs
  - No specific documentation needs were explicitly requested.

- Feature Requests
  - Implement a feature to edit tweets for more spaced intervals and adjust interaction times based on direct replies, mentions, etc (requested by SotoAlt | WAWE)
  - Consider integrating the functionality into model providers as part of future development (implied request by YODȺ26)

- Community Tasks
  - Provide step-by-step guidance for building an AI agent, hosting it, etc. (requested by Denko)

