# 💻-coders 2024-11-04

## Summary
 During the technical discussion, several key points emerged regarding Eliza's development process. The community agreed that reading the README is more straightforward than navigating GitHub documentation. Agent Joshua ₱ expressed interest in testing a Docker image for Eliza to facilitate real TEE Server tests with his next.js example app capable of remote attestations and deriving ECDSA keypairs, which he demonstrated through a video using random data inputs. Fuzzy highlighted the challenges of setting up on Windows but also mentioned utilizing CUDA on their gaming PC for development purposes. ATH🥭Hivo shared efforts to analyze bot message data and inquired about incorporating liteLLM, seeking information on supported endpoints via npm packages. Ophiuchus proposed replacing llama.ts with an ollama version as a solution but also suggested adding the model provider for local settings without overriding LlamaService class functionality entirely. BigSky sought guidance on switching to the Claude bot model and received confirmation from Ophiuchus that running 'pnpm dev run u' would indicate usage of the new model, although testing with Chat had not been conducted yet.

## FAQ
 - How can I make the installation of Eliza easier and less confusing?
  - SotoAlt: The README is way easier and less confusing than other sources like GitHub.
- Has anyone built a Docker image for Eliza yet?
  - Agent Joshua ₱: Plans to add a Dockerfile are in progress, which will allow testing on a real TEE Server.
- Is there any model provider that can anticipate where code changes will be needed?
  - Ophiuchus: No specific model provider mentioned for anticipating code changes; however, the user is working on making changes to various files and plans to continue this work.
- How do I switch the bot model to Claude in Eliza?
  - BigSky: To switch the bot model to Claude, ensure you have the API key in .env and change the model in the character file. Running `pnpm dev run u` should show logs confirming the use of the new model.

## Who Helped Who
 - Agent Joshua ₱ helped Ophiuchus with testing a Docker image for Eliza by planning to add a Dockerfile, which would allow him to test it in a real TEE Server environment. He also shared his progress on building a next.js example app that can make remote attestations and derive ecdsa keypairs.
- Fuzzy helped Ophiuchus with setting up the development environment by working on making the setup less annoying, especially since he was switching from mac to Windows for utilizing cuda on his gaming PC.
- ATH🥭Hivo sought help from Ophiuchus regarding incorporating liteLLM and analyzing bot message data. Although it's not clear if a solution was provided in this conversation, the interaction shows an attempt at seeking assistance for specific tasks related to datascience on bot messages.
- BigSky received guidance from Ophiuchus about switching the bot model to claude by checking logs during development and confirming that the API key is correctly set up in the .env file.

## Action Items
 - Technical Tasks
  - Build a docker image for Eliza (mentioned by Agent Joshua)
  - Add model provider anticipating code changes (mentioned by Ophiuchus)
  - Test on latest build after pushing changes to models, embeddings, generations, and types files (mentioned by Ophiuchus)
- Documentation Needs
  - Readme update for easier understanding (requested by Agent Joshua)
- Feature Requests
  - Replace llama.ts with ollama version or add a setting for LOCAL_LLAMA_PROVIDER ("ollam" or "llama-cpp") as an alternative solution (mentioned by Ophiuchus)
  - Incorporate liteLLM and clarify endpoints support (requested by ATH🥭Hivo)
- Community Tasks
  - Share a video of the test with remote attestations and derived ecdsa keypairs using next.js example app (mentioned by Agent Joshua)

