# 💻-coders 2024-11-07

## Summary
 In the chat, Ophiuchus installs npm packages for development purposes and initiates a build process. Jin expresses uncertainty but later appreciates DocuShards after learning about its PDF builds feature. HiroP encounters difficulties running a Discord bot due to conflicting token names in documentation. The team discusses the importance of integrating cursor support into their project, with SotoAlt and WAWE advocating for using code editors over switching operating systems like claude. They also address Playwright's compatibility issues on Arch Linux and suggest modifying shell scripts for better node expertise. Jin plans to implement 'code2prompt', a tool that uses grep -r to find strings, indicating an effort towards improving the project's codebase and debugging capabilities.

## FAQ
 - Are DISCORD_API_TOKEN and DISCORD_TOKEN the same in the .env file?
  - Ophiuchus: The two tokens are not necessarily the same; one is for API usage, while the other might be specific to a bot's operation. It depends on how your application uses them.
- How can I debug DocuShare issues and stream it for assistance?
  - Jin (19:18:46): You can try streaming your debugging process using tools like VS Code Live Share or screen sharing with colleagues to get real-time help.
- Is there a way to make Playwright work on Arch Linux, given the error message about missing apt-get?
  - Coinwitch (ai16z intern) (20:18:28): You can try using alternative package managers like pacman or manually installing dependencies. However, since Arch Linux is not officially supported by Playwright, you might encounter issues that require workarounds.

## Who Helped Who
 - Ophiuchus helped Jin with setting up a PDF version for documentation by suggesting to use Docusaurus's pdf build feature once it is working. This implies guidance on improving documentation accessibility and format.

- Ophiuchus assisted HiroP in understanding the setup process for Discord bot integration by clarifying that both `DISCORD_API_TOKEN` and `DISCORD_TOKEN` are correct but serve different purposes, with one being used generally and the other specifically within character files. This helped resolve confusion regarding token usage in their project's configuration.

- SotoAlt | WAWE provided advice to Jin on improving Linux setup by suggesting that it should automatically detect the OS and use the default package manager accordingly. This recommendation aimed at streamlining the installation process for different operating systems, enhancing user experience.

## Action Items
 - Technical Tasks
  - Implement PDF version of documentation and website chat QA feature using Eliza agent runtime (mentioned by Ophiuchus)
- Documentation Needs
  - Create a PDF version of the documentation (requested by Jin, supported by Ophiuchus)
- Feature Requests
  - Add support for DISCORD_TOKEN in addition to DISCORD_API_TOKEN (mentioned by hiroP and discussed among others)
  - Improve Linux setup detection and package manager auto-selection (requested by Jin)
- Community Tasks
  - Debugging assistance for DocuSaurus (led by Jin, with community involvement from Ophiuchus, SotoAlt | WAWE, coinwitch, etc.)

