# 💻-coders 2024-11-08

## Summary
 During the chat, participants engaged in technical discussions regarding token swap functionality issues, with a TypeError reported when attempting to read '_bn' properties of undefined objects. Ophiuchus confirmed that despite these challenges, the swap feature operates correctly. The community explored various APIs like Helius and Birdeye for potential integration into their projects, as evidenced by Jin's inquiries about GitHub repositories related to code2prompt. Slim suggested a loading or network issue might be causing delays in dashboard UV map rendering, while Tenji sought clarification on initiating token swaps using Eliza's sister feature. Ophiuchus confirmed the process and mentioned testing transaction functionality with pull request #239 from AI16z/eliza. Bless expressed interest in documenting an end-to-end setup for an Eliza Twitter bot, including a bounty offer to cover comprehensive tutorials on using Eliza across different platforms like Twitter, Discord, and Telegram. Ophiuchus agreed to create the tutorial with a focus on thoroughness, especially regarding Twitter integration.

## FAQ
 - What is the error encountered during token swap?
  - Ophiuchus: The error "TypeError: Cannot read properties of undefined (reading '_bn')" occurs when trying to perform a token swap. This issue might be related to an incomplete or incorrect implementation in the codebase, which needs further investigation.
- How can one set up an Eliza Twitter bot from start to finish?
  - Ophiuchus: To document and create a setup guide for an Eliza Twitter bot on the latest build, you would need to cover aspects like initializing the project, adding twitting cookies (which should be obtained during the first run), and setting up end-to-end integration with Twitter. The process can also include other platforms such as Discord and Telegram if desired.
- What is the difference between helius and birdeye APIs?
  - Ophiuchus: Both Helius and Birdeye are Solana wallet extensions, but they have different features and user interfaces. While specific differences were not mentioned in the conversation, it's recommended to explore their respective documentation or GitHub repositories for more information on how they differ from each other.

## Who Helped Who
 - Ophiuchus helped Rick with a token swap by initiating it for an amount right now, indicating the swap actions feature works.
- Jin sought assistance from others in creating a dashboard UV map and received guidance on using `node screenshot.js` followed by sharing links to code2prompt repositories for further help.
- Ophiuchus offered to document the process of setting up an Eliza Twitter bot, including potential challenges like adding tweeting cookies, and expressed willingness to create a thorough video tutorial in response to Bless's request.

## Action Items
 - Technical Tasks
  - Investigate and resolve the error during token swap: TypeError: Cannot read properties of undefined (reading '_bn') (mentioned by Ophiuchus)
  - Look more into the Helius and Birdeye API, understand their functionalities (mentioned by Ophiuchus)
- Documentation Needs
  - Document the process for setting up an Eliza Twitter bot from start to finish on the latest build, including adding tweeting cookies (requested by Bless; agreed to be documented by Ophiuchus)
- Feature Requests
  - Create a video tutorial covering the setup of Eliza for various platforms like Twitter, Discord, and Telegram, explaining everything in an easy-to-understand manner (suggested by Bless; agreed to be done by Ophiuchus with bounty)
- Community Tasks
  - Prepare a thorough video tutorial on setting up Eliza for various platforms as part of the community learning resources (led by Ophiuchus, supported by Bless's bounty offer)

