# 💻-coders 2024-11-11

## Summary
 In the chat, users engaged in technical discussions regarding API configurations for integrating AI models into their projects, specifically focusing on setting up environment variables like `X_SERVER_URL`, `XAI_API_KEY`, and `XAI_MODEL`. They also discussed debugging knowledge usage within agents, with one user mentioning an empty `"knowledge": []` array in the character file. Contributions to documentation were encouraged, particularly for Eliza-related content, as a developer sought guidance on where to start contributing effectively. The community celebrated milestones such as joining virtual channels and expressed interest in paid assistance for setting up agents. A key technical decision was made by weizguy regarding the use of together API keys while considering blurring out other providers like OpenAI and Anthropic, indicating a preference to focus on one provider's capabilities.

## FAQ
 - What is the X_SERVER_URL needed for in setting up an API?
  - weizguy (23:30:42): The X_SERVER_URL is used to specify the server URL where the API can be accessed, such as https://api.openai.com/v1/ for OpenAI's API.

- How do you set up an environment variable for the together API?
  - weizguy (23:58:32): To use the Together AI API, you need to set X_SERVER_URL as https://api.together.com/v1/, and provide your own API key with XAI_API_KEY=your_key. The default model is gpt-4o-mini, but it can be changed by setting the XAI_MODEL variable to a different value if needed.

- What should you do when encountering issues while using knowledge in Eliza?
  - hiroP (23:37:03): If your characterfile has `"knowledge": []`, it means that no knowledge is being used by the agent. You can try checking for any updates or changes to the codebase, and reach out to other developers on the platform's community channels for assistance in debugging this issue.

- How can someone contribute to Eliza's development?
  - hiroP (23:41:15): To contribute to Eliza's development, you should first join the repository and browse through existing issues. Pick an issue that interests you or aligns with your skills, work on it, and then submit a pull request for review by other developers.

- What is the best way to get help with documentation?
  - jin (23:43:08): To seek assistance with Eliza's documentation, consider joining community channels or discussions where you can ask questions directly to experienced contributors and developers who are familiar with the project.

## Who Helped Who
 - weizguy helped himself with setting up API credentials for Together AI by sharing his current configuration in a .env file format.
- hiroP sought debugging assistance regarding knowledge usage in an agent, but no direct solution or advice was provided within this conversation snippet.
- ShakkerNerd offered to help Jin with Eliza documentation and expressed willingness to contribute more after joining the voice channel for discussion.
- ferric | stakeware.xyz clarified that a key is needed when setting up an agent, correcting weizguy's assumption about not needing one.

## Action Items
 - Technical Tasks
  - Set up API credentials and model settings for the together API (mentioned by weizguy)
- Documentation Needs
  - Help with documentation related to Eliza (requested by jin)
- Feature Requests
  - Discussion on algotrading components of Eliza (suggested by Quanatee)
- Community Tasks
  - Contribute to the repository, pick an issue, and work on it for a pull request (led by hiroP)

