# 💻-coders 2024-11-12

## Summary
 In the discussion, participants focused on optimizing their project by considering defaulting to the cl100k_base model over mbxai due to size concerns for switching models in Ollama. They also discussed implementing an action after getting the agent framework running and aimed at making it fully autonomous soon. A recent push of knowledge-related updates was mentioned, with some humor about being scared to update to main. The group expressed interest in a web interface that could be useful beyond just coin cloner users, welcoming developer freedom within the DAO's framework. Technical issues were acknowledged, such as broken npm start and an internal node error without a clear solution yet.

## FAQ
 - What is the issue with the test code in the facts module?
  - Ferric | stakeware.xyz: The problem seems to be that the output from the facts module isn't being pushed as expected, causing issues when trying to switch models or load embeddings. A possible solution could involve defaulting to a smaller model like cl100k_base instead of mbxai and using fastjs embeddings for efficiency.

- Is there an alternative embedding method that can be used in place of the current one?
  - Ophiuchus: Yes, switching to the new embedding or openai endpoint could solve the problem as it would eliminate the need to unload models in ollama when loading embeddings. This change should make everything from embedding with the ollama endpoint more streamlined and efficient.

- What is causing the error on npm start?
  - Ferric | stakeware.xyz: The specific cause of the error isn't clear, but it seems to be related to a problem in running the main module. A possible solution could involve debugging or finding an alternative debugger that can catch this type of error.

- Would a command and control web interface be useful for users?
  - Ferric | stakeware.xyz: Yes, building a web interface would likely attract more users and potentially win you "shitcoin friends." It's encouraged to build whatever features you want as part of the DAO (Decentralized Autonomous Organization) philosophy.

## Who Helped Who
 - ferric | stakeware.xyz helped with model selection by suggesting to default the ollama embeddings model to cl100k_base instead of mbxai, which could potentially resolve issues related to model size and loading times in Ollama.
- Shannon Code (emblem vault) was considering adding a web interface for command and control but sought opinions on whether it would be useful beyond coin cloner users; ferric | stakeware.xyz encouraged the idea, implying that building such features could lead to positive community engagement and support.
- Ophiuchus helped with debugging by identifying the issue as a missing reference not being found during import, suggesting it might be resolved by running the code inside VSCode debugger for better error tracking.

## Action Items
 - Technical Tasks
  - Switch from mbxai model to cl100k_base in Ollama embeddings (mentioned by ferric | stakeware.xyz)
  - Implement an action after getting the agent framework running (suggested by ferric | stakeware.xyz)
  - Address issues with switching models and unloading/reloading in Ollama (discussed by Ophiuchus)
  - Fix npm start error for a better debugging experience (requested by Ophiuchus)
- Documentation Needs
  - Provide documentation on using fastjs embeddings or similar alternatives (implied need by Ophiuchus's suggestion to use them)
- Feature Requests
  - Develop a command and control web interface for broader accessibility, not just coin cloner users (requested by Shannon Code (emblem vault))
- Community Tasks
  - Share updates on knowledge stuff pushes and encourage main version updates (mentioned by ferric | stakeware.xyz)

