# 💻-coders 2024-11-16

## Summary
 In the discussion, Oguz Serdar shared best practices for customizing Discord system prompts by suggesting modifications to files like `discordShouldRespondTemplate` and `discordMessageHandlerTemplate`, recommending using overrides instead of changing hard-coded content directly. Uber expressed gratitude for this guidance and inquired about automating a Twitter account, eventually finding the option under "Account information" on the standard Twitter site after some confusion. The conversation also touched upon technical issues with pnpm rebuilds and Docker setups, as well as preferences between cursor @codebase and Cody extensions in Visual Studio Code for code coverage analysis.

## FAQ
 - How can you tweak the Discord system prompts or any client file?
  - Oguz Serdar: You can modify files like `discordShouldRespondTemplate` and `discordMessageHandlerTemplate`. It's better to use overrides instead of changing hard-coded stuff.

- What is a possible workaround for running the codebase in Visual Studio Code (VSC)?
  - Oguz Serdar: An alternative could be generating several files that cover the codebase and providing those as context in the Claude project window. Cody on VSC can also work, but it might not read the docs as effectively.

- How to mark an action as automated on Twitter?
  - Oguz Serdar: Login to the bot's Twitter account, go to Account Settings -> Your Account -> Account Information -> Enter Password -> Automation option at the bottom of options -> Insert your main Twitter acc as the managing one.

- How can you run a project in Docker continuously?
  - Kikyo: You could try using Railway for setting up and running it, but if there are errors during build, consider trying another approach like Oguz Serdar's suggestion of generating files to cover the codebase or Griffin's idea of running a script.

## Who Helped Who
 - Oguz Serdar helped uber with understanding where to tweak Discord system prompts by providing file names like `discordShouldRespondTemplate` and `discordMessageHandlerTemplate`. This guidance allowed uber to locate the files for customization.
- Oguz Serdar assisted infinite — ai/16z in setting up sharp, a Node.js image processing library, by suggesting the command `pnpm add sharp --ignore-scripts`, which helped them proceed with their project without issues related to scripts execution.
- Kikyo provided guidance to uber on how to approach codebase contextualization within the Claude project window, recommending using 'First approach' over 'cursor @codebase', thus helping uber find a more effective method for their needs.

## Action Items
 - Technical Tasks
  - Installing sharp library and ignoring scripts during installation (mentioned by Oguz Serdar)
- Documentation Needs
  - Publishing best practices docs related to custom actions, plugins, etc. (requested by Oguz Serdar)
- Feature Requests
  - Using overrides for hardcoded stuff instead of changing them directly (suggested by Oguz Serdar)
  - Generating several files that cover the codebase and providing those as context in the Claude project window (suggested by uber)
- Community Tasks
  - Setting up a Docker environment to run continuously for 24/7 operation (led by collect, with input from Kikyo and griffin on model preferences)

