# 💻-coders 2024-11-19

## Summary
 In the chat, participants discuss various technical issues related to setting up an AI character model using a GitHub repository. Kanye encounters errors when trying to start the project with edited index.js files, while YoungPhlo inquires if others experienced SQLite3 errors during setup and whether they used the main branch or not. Big dookie shares their experience of hitting a "prefix match hit" limit, suggesting that it might be related to token usage in reading character files. Odilitime expresses enthusiasm for hot reloading and makes an official request on GitHub for its implementation. Seb asks if there's a way to train the AI with specific personalities by feeding scripts from movies or other sources, while brownie suggests using Grok or ChatGPT for character conversion without needing additional input. 18 Rabbit reports issues when running pnpm start with different characters and mentions that they tried building locally before encountering errors. Odilitime advises on potential timeouts due to model processing time and encourages retrying the process, while also mentioning local llama usage and GitHub address attempts for accessing content.

## FAQ
 - What is the error message when trying to run index.js with a character file?
  - Kanye: The error message indicates that there's an issue with the agent not being found or invalid JSON, possibly due to hitting prompt limits while reading the character file.
- How can one train the AI to take on a specific personality using a script from a movie for a particular character?
  - Seb (💖/acc) 💹🧲: You could feed the AI with the character's JSON and ask it to convert it into whatever format you want, such as a movie or music. However, this might be more effective once everything is working locally.
- What does "prefix match hit" mean in the context of using the local llama?
  - big dookie: It could indicate that the AI has found a matching prefix for the input it received but isn't entirely sure what it means. This might be related to how the model processes and responds to prompts.
- What should one do if they encounter an error when running pnpm start with a character file?
  - Odilitime: Try again, as timeout errors usually mean that the model is taking too long to process the input. Also, ensure you've built your project using pnpm build before attempting to run it.

## Who Helped Who
 - Kanye helped with troubleshooting an error in index.js by identifying a potential issue related to recursive run failures, but did not provide a direct solution.
- Big dookie provided insight into their own experience with similar issues and suggested that it might be due to the model hitting its prompt limit while reading character files, although this was more of an educated guess than a definitive solution.
- YoungPhlo asked about setup details and potential SQLite3 errors, which could help narrow down the problem but did not offer direct assistance in resolving the issue.
- Odilitime mentioned their experience with hot reloading and made an official request for it on GitHub, indirectly helping by contributing to a feature that might prevent similar issues in the future.
- Seb suggested training the AI to take on specific personalities using character scripts from movies as input, which could be helpful if the issue is related to personality modeling but did not directly address the error at hand.
- Brownie recommended using Grok or ChatGPT for converting character JSON files into desired formats without needing additional inputs, providing a potential workaround rather than solving the original problem.

## Action Items
 Technical Tasks:
- Fix the issue with `ERR_PNPM_RECURSIVE_RUN_FIRST_FAIL` when running index.js (mentioned by Kanye)
  - Investigate and resolve errors related to "Agent not found" in JSON parsing (discussed by big dookie, YoungPhlo, Odilitime)
- Address the issue with hot reload requests (requested by Odilitime)

Documentation Needs:
- Document steps for setting up a project using either main branch or another version to avoid SQLite3 errors (suggested by YoungPhlo)

Feature Requests:
- Train AI to take on specific personalities based on provided scripts from movies, shows, etc. (requested by Seb)

Community Tasks:
- Create an official request for hot reload feature implementation (led by Odilitime)

