# 💻-coders 2024-11-22

## Summary
 In the chat, Ophiuchus updated their Twitter scraper to use cookies for login with email authentication, setting a range of 10-100 scrapes per session before settling on 60 as optimal. The community discussed deployment options for Eliza, with ferric advising against serverless due to potential costs and suggesting running it on a VPS instead. ICJR shared their PostgreSQL setup process but encountered errors related to missing tables after seeding the database. Ophiuchus offered to share detailed instructions for setting up Eliza's environment, while void(null) mentioned past experiences with AWS and GCP before taking a break from cloud services.

## FAQ
 - What is the recommended approach for deploying Eliza using PostgreSQL?
  - Ferric | stakeware.xyz: Avoid serverless options due to potential costs from bot activity; instead, run on a VPS (Virtual Private Server).
- How can one set up PostgreSQL and install necessary extensions for Eliza?
  - ICJR: Provided detailed steps including installing PostgreSQL packages, creating a database named 'eliza', and setting up required extensions like vector, pg_trgm, and fuzzystrmatch. Also mentioned the need to execute schema/seed SQL scripts from the provided paths.
- What could be causing errors when attempting to communicate with the agent in PostgreSQL?
  - Ferric | stakeware.xyz: Suggested that running on a VPS instead of serverless might help avoid issues like cringe loops and edge function costs, which can lead to such errors.
- Are all tables required to be seeded when setting up Eliza with PostgreSQL?
  - ICJR: Raised the question about whether every table needs to be seeded or if only specific ones are covered by the provided seed SQL script. This indicates that there might be a need for additional information on which tables should be created and populated during setup.

## Who Helped Who
 - Ophiuchus helped themselves with Twitter scraping by making changes to use cookies & login through email.
- ferric | stakeware.xyz helped ICJR with serverless deployment advice, recommending against it and suggesting running on a VPS instead.
- Ophiuchus assisted ICJR in setting up Eliza's PostgreSQL environment by providing instructions for installation and seeding the database.

## Action Items
 - Technical Tasks
  - Fixing the PostgreSQL adapter errors, such as "expected unused to be 0, not 10429" (mentioned by ICJR)
  - Ensuring that all necessary tables are created when starting with an empty database and seeding them appropriately (raised by Ophiuchus)
- Documentation Needs
  - Providing instructions for setting up the Eliza project, including installing extensions and initializing databases (requested by ICJR; instructions provided by Ophiuchus in chat)
- Feature Requests
  - Exploring alternative PaaS/serverless compute options to avoid bot edge function costs (suggested by ferric | stakeware.xyz)
- Community Tasks
  - Sharing experiences and recommendations for VPS providers, such as Contabo or Hetzner (led by ferric | stakeware.xyz)

