# 💻-coders 2024-11-23

## Summary
 In the discussion, jmill advised Lambrino on setting up `WALLET_PUBLIC_KEY` in the environment to load the Solana plugin within an agent script hardcoded into index.ts file of the agent's source code. This setup allows the agent to use plugins like solanaPlugin and coinbaseCommercePlugin, which are conditionally included based on character settings or process.env variables. Lambrino sought clarification on how to format these plugins within an array in their .env file but was guided by jmill not to include anything there. Instead, they were instructed to set the necessary environment variables directly. The conversation also touched upon increasing logging levels and clearing agent memory, with moonboi suggesting that global use might not be applicable for the latter concern. Additionally, Lambrino expressed difficulty in getting their agent to utilize the chain correctly when querying coin prices or opinions, indicating a need for further assistance on this topic.

## FAQ
 - What is the correct way to set up `WALLET_PUBLIC_KEY` in .env file?
  - [jmill]: To load the Solana plugin, you need to hardcode `WALLET_PUBLIC_KEY` into your agent script. You don't have to put anything within the `plugins` array; just set `WALLET_PUBLIC_KEY` in your .env file and it will be picked up by the agent runtime.

- How does the agent know to use plugins?
  - [jmill]: The agent knows to load plugins based on the configuration provided in the AgentRuntime object, which includes an array of plugin objects under `plugins`. In this case, you can set your Solana and Coinbase Commerce keys as environment variables or hardcode them into the script.

- How do I clear my agents memory?
  - [moonboi 🌑]: The agent doesn't have a built-in method to clear its memory, but you can try restarting your agent process to reset its state.

- Is it necessary to include `runtime.registerPlugin(solanaPlugin)` and where should I include it?
  - [jmill]: It is not necessary to manually register the Solana plugin using `runtime.registerPlugin()`. The code snippet provided shows that plugins are loaded automatically based on their configuration in the AgentRuntime object, which includes an array of plugin objects under `plugins`.

## Who Helped Who
 - jmill helped Lambrino with setting up solana plugin in agent script by suggesting to set `WALLET_PUBLIC_KEY` in env and providing a code snippet for including plugins. The issue was related to formatting within the "plugins" array, which was resolved successfully.
- AzFlin helped an unnamed user with increasing logging mode to debug by pointing out where they can see debug logs in the code (e.g., `elizaLogger.debug("generate post prompt:\n" + context);`). The context of the problem is not fully clear, but it seems related to debugging agent behavior.
- moonboi 🌑 helped Lambrino by suggesting that the issue with the agent getting caught up on previous stuff might not be a global issue, implying that the problem could lie elsewhere in their setup or usage of the agent.

## Action Items
 - Technical Tasks
  - Extract concrete Solana plugin from the agent script and set `WALLET_PUBLIC_KEY` in .env (mentioned by jmill)
  - Increase logging to debug mode (requested by AzFlin)
  - Clear agents memory when it gets caught up on previous stuff (requested by Lambrino)
  - Ensure the agent uses the chain correctly for price or opinion queries and sends the address accordingly (mentioned by Lambrino)
  - Determine if runtime.registerPlugin(solanaPlugin); is necessary and where to include it, if so (questioned by Lambrino)
- Documentation Needs
  - Provide documentation on how to apply rag (requested by Chiboba)
- Feature Requests
  - Enable the agent to buy coins using the enabled plugin (mentioned by Lambrino)
- Community Tasks
  - Tagging for availability or assistance with specific questions related to AI agents and Solana plugins (requested by Lambrino)

