# 💻-coders 2024-11-24

## Summary
 During the technical discussion, Ophiuchus shared plans to push code for a Twitter scraper by week's end, aiming to capture responses from replies while excluding simple replies, image posts, and threads that the scraper could handle. The team expressed interest in seeing how finetuning on this data would impact results compared to using RAG models. Ferric highlighted the need for GPU time when fine-tuning due to Gemini's extensive token context. Loaf suggested starting from a TypeScript file and mentioned plans to move away from JSON, although implementation is pending. Jmill provided examples of initializing agents with character data in TypeScript files, noting that characters are loaded based on command line arguments or fallback defaults. Tony AI Champ clarified the distinction between fine-tuning for personality adjustments and RAG models for knowledge acquisition, emphasizing that fine-tuning only modifies a small number of weights while keeping most parameters unchanged.

## FAQ
 - What is the difference between fine-tuning and RAG in terms of knowledge acquisition?
  - Tony AI Champ: Fine-tuning can be thought of as adjusting a model's personality, while RAG (Retrieval-Augmented Generation) focuses on acquiring new knowledge. In the case of Eliza, fine-tuning changes only a small number of weights and keeps everything else constant, making it less effective for gaining extensive knowledge compared to RAG.

- How can one resolve an error related to missing modules or type declarations in Node.js projects?
  - Faith: To solve the issue with '@ai16z/eliza' module not found, ensure that you have installed all necessary dependencies using `pnpm i` and check if your project is correctly configured for TypeScript by verifying the presence of a `.tsconfig` file. Additionally, make sure to install type declarations (if available) or define them manually in your project.

- How can one start from a TypeScript (.ts) file when working with Eliza?
  - loaf: To work with Eliza using TypeScript files, you need to load the plugin and parse arguments accordingly. You may also consider moving away from JSON format but note that this feature has not been implemented yet. The `loadCharacters` function expects a string input rather than an object, so ensure your code is compatible with these requirements.

## Who Helped Who
 - Ophiuchus helped Faith with a module error by discussing potential solutions to the '@ai16z/eliza' module issue. The success of this interaction is not explicitly stated, but it provided guidance for troubleshooting.
- loaf helped jmill with understanding how to start from a TypeScript file and load characters in their project by explaining the process and mentioning plans to move away from JSON. This was successful as it clarified the steps needed for jmill's task.

## Action Items
 Technical Tasks:
- Fixing the module import error '@ai16z/eliza' (mentioned by Faith)
- Implementing finetuning on a codebase and knowledge addition (discussed by Ophiuchus)
- Moving away from JSON to another format in future updates, but not yet implemented (loaf mentioned this as a plan)

Documentation Needs:
- No specific documentation needs were explicitly requested.

Feature Requests:
- Implementing finetuning for knowledge addition instead of RAG models (Ophiuchus suggested this idea)
- Removing replies or short ones from Twitter scraper training data to improve results (Ophiuchus mentioned this as a consideration)

Community Tasks:
- Pushing code by the end of the week on the Twitter scraper project (led by Ophiuchus)

