# 💻-coders 2024-11-25

## Summary
 In the discussion, EdwardLazz provided guidance on setting up an endpoint for trust score provider integration in backend systems, while fudme sought assistance with executing swaps via AI agents but was redirected to discuss non-crypto topics by Eliza. HiroP raised questions regarding Twitter's _cookies.json file creation and control mechanisms during user login. Haitianspacestation reported issues running a development script from a fresh clone, seeking help with errors in live load environments. Bellatr!X suggested using Heurist's API as an alternative to OpenAI and shared a referral code for obtaining an instant API key through coinwitch's announcement. Howard0xff ended the conversation by inquiring if anyone had encountered similar issues, highlighting community engagement in troubleshooting technical challenges.

## FAQ
 - How to set up an endpoint for a trust score provider?
  - EdwardLazz: To use the trust score provider effectively, you'll need to create an endpoint in your backend that can handle requests for trust score data. This endpoint should accept necessary parameters and return the trust score based on your logic. If needed, I can help with defining the structure of this endpoint or implementing it in your backend.

- How is the `_cookies.json` file created when a user logs into Twitter?
  - EdwardLazz: The `_cookies.json` file stores session-related information such as authentication tokens, session IDs, and user preferences to maintain the user's session on Twitter. You can control this file by reading, modifying, or deleting cookies in your application, but be cautious with sensitive data.

- Issues running a dev script off a fresh clone?
  - Haitianspacestation: The individual was experiencing errors while trying to develop in a live load environment after cloning the project and reviewing documentation and codebase. EdwardLazz offered assistance if needed, but no specific solution was provided within this conversation snippet.

- What happens when you give it the private key?
  - 1E->100E: The response given by 1E->100E seems to be a joke or non-serious answer ("she will buy some meme"), and no clear explanation was provided for handling private keys.

## Who Helped Who
 - EdwardLazz helped HiroP with understanding how Twitter creates and uses the `_cookies.json` file by explaining its purpose, contents, and control options within an application.
- Bellatr!X helped fudme with configuring fields for a swap operation by suggesting to use Heurist's API as a replacement for OpenAI, which might resolve the issue.
- coinwitch (ai16z intern) helped users interested in obtaining a Heurist.ai API key by providing a referral code and pinning a message with this information on the platform.

## Action Items
 - Technical Tasks
  - Set up an endpoint in the backend for trust score data requests (mentioned by fudme)
- Documentation Needs
  - Define structure and implementation details of the trust score provider's backend endpoint (requested by fudme)
- Feature Requests
  - Use Heurist API as a replacement for OpenAI (suggested by Bellatr!X)
- Community Tasks
  - Pin message with referral code `ai16z` for instant access to heurist.ai api key (led by coinwitch)

