# 💻-coders 2024-11-27

## Summary
The chat focused on technical discussions around modifying Characters.ts to include data from .json files and creating a private Discord server for testing character interactions. Additionally, there was an issue with the dimensions of the Google Gemini model being discussed.

## FAQ
- How do I replicate index.tx and character.ts to create my own copy? What is the best approach for this task? (asked by @crazysailor1000)
- What version of Google Gemini model should be used, considering error: expected dimensions mismatch with v0.1.4-alpha.3 vs v0.1.3? (asked by nomansky)
- How do you get Twitter's V2 API? How is it different than version one and what can I not do on v1 that I could with the new release, like polls? What are some of your thoughts about using goat-x instead for integration purposes? »,   (asked by N00t)
- How to make the bot take action on tweets?
Answer: @redbull.eth - Switch up character file and delete sqlite db, but cache might need updating. (asked by @puremood)
- Are replies connected with post interval or done independently? (asked by @Konstantine)
- How often are the bot's responses generated?
Answer: @Bootoshi - Default is 15 minutes, but it might be wrong. (asked by @puremood)
- What is a good solution for hosting agents? Is Vercel suitable? (asked by Cheelax | zKorp☁)
- Can someone provide an example of the format for Twitter cookies inside character secrets? (asked by NavarroCol / Vicky Dev/ noDMs)
- Is there a comprehensive guide on setting up agents and posting to social media like Twitter? (asked by LargeCryptoDude)
- Did you solve this issue with generating text loops in WSL 2 environment? (asked by Second State)

## Who Helped Who
- @nomansky helped Google Gemini model error issue, suggested trying version alpha.3. with Resolving dimension mismatch in Google Gemini Model by providing @SotoAlt | WAWE
- hosermage helped unknown with Understanding API integration by providing Hosermage provided a link to GitHub issue explaining how an openai key is needed.
- @puremood helped All members in the chat with Switching agent's character file by providing @redbull.eth and others provided advice on switching character files to solve old post issues.
- puremood helped Konstantine with Creating new Discord channels by providing Konstantine received help from puremood regarding the need for a 'Quickstart Help' channel.
- Mfairy and AzFlin helped NavarroCol/VickyDev with Resolving a documentation error by providing NavarroCol / Vicky Dev fixed an issue with missing client information in their character secrets.
- @Artego helped @NavarroCol / VickyDev/nodms (05:34) with AI agent development by providing Vicky Dev provided information about AI Agent picture provision feature during scrapping phase.
- @Kush | Cartman helped @NavarroCol / VickyDev/nodms (05:42) with AI agent development by providing Vicky Dev provided information about potential copyright issues with music covers.
- @hosermage helped @NavarroCol / @VickyDev with Discussed the importance of song quality and catalog diversity, providing feedback on current issues. by providing @DorianD (05:48)
- [juneaucrypto | The Interns AI] (07:23) helped [g] with Learning how to code by providing [RL](06:54) provided advice on learning coding and building small projects
- @puremood helped @Yoni with Understanding model provider flexibility by providing PureMood provided guidance on using any API for text and image generation.

## Action Items

### Technical Tasks
- Modify Characters.ts to include data from .json file (mentioned by crazysailor1000)
- Replace Twitter agent with goat-x for new functions (mentioned by Bootoshi)
- Implement a caching mechanism to prevent double replies (mentioned by puremood)
- Create a 'Quickstart Help' channel for new users setting up character files. (mentioned by puremood)
- Discuss with Vicky Dev to improve music quality (mentioned by @DorianD (05:20))
- Update character JSON file to fix old replies issue (mentioned by @redbull.eth)
- Make perplexity plugin work across different clients, not just terminal (mentioned by [auto troph (06:04)])
- Investigate using different model providers for text generation vs image processing (mentioned by @Yoni)
- Improve memory usage of agent (mentioned by cygaar)
- Replace GPT-4 checkpoint with fine-tuned model by setting OPENAI_BASE_URL to server link for the non OAI model. (mentioned by _Xd9f)

### Documentation Needs
- Create a private Discord server for testing character interactions. (mentioned by crazySailor1000)
- Obtain API key from twitter, avoid v2 integration. (mentioned by Bootoshi)
- Update the banned words list implementation, ensuring it does not affect response generation even if chaos is in prompt. (mentioned by AzFlin)
- Update documentation to include information on replying automatically (mentioned by Konstantine)
- Resolve TypeScript error for 'direct' client assignment (mentioned by [juneaucrypto | The Interns AI](07:23))
- Customize functionalities like replies, system prompts within character files. (mentioned by @crazysailor1000)
- Documentation on setting up Eliza in WSL2 environment. (mentioned by /u/mina)
- Edit packages/core/src/models.ts and change 'endpoint:' key in models to preferred URL for the assigned provider (mentioned by yikesawjeez)

### Feature Requests
- Provide feedback on AI Agent's picture provision feature during scrapping phase. (mentioned by @Artego (05:34))
- Improve song catalog quality, focusing on non-meme songs and genres. (mentioned by @NavarroCol / @VickyDev)