# 💻-coders 2024-11-28

## Summary
Discussion focused on integrating a newly modified 'Twitter-Client' into the codebase. The modification allows for sending tweets and retweets without requiring Twitter API access, running in both browser & server environments.

## FAQ
- Is modified Twitter-client module a replacement for 'Twitter-Client' or the scraper? What is its purpose and how does it differ from original twitter client? (asked by @N00t)
- How to import solanaPlugin into charactor.ts file in agents/index.js. (asked by @hΔrdshell)
- What's @shaw 's YT channel name? (01:55)? (asked by @Jaseem)
- Is there any way I can run models without paying for tests?(02:27) (asked by @jaseem)
- Why is the system trying to use Llama when XAI_MODEL=gpt-4o-mini and with OpenAI key in .env? Who can answer this question? (asked by Whale  🐋 (03:42))
- How do I prevent the agent from responding to past messages after a restart, so it doesn't interact again on Twitter when changes are made and started anew? Who can answer this question? (asked by ray (04:40))
- Issue with not being able to post new tweets after merging specific GitHub pull request. Has anyone else faced the same issue and how did they resolve it? Who can answer this question? (asked by CaptainCool (04:51))
- Can someone recommend a good base model to finetune an agent on, preferably compatible with unsloth 4bit training? Who can answer this question? (asked by Havohej (05:03))
- Why am I facing issues while running Eliza on Windows? What should be the correct Node version to use? (asked by [Tharakesh](05:14, 05:29))
- How can `SupabaseDatabaseAdapter` be used as a `DbCacheAdapter`? Are there any missing methods that need implementation for this purpose? What is your experience with using Supabase and Eliza together? (asked by [AM](05:35))

## Who Helped Who
- @Odilitime helped @N00t with Understanding new twitter client functionality by providing Odilitime helped N00t understand the purpose and usage of modified Twitter-client module.
- @hΔrdshell helped @Odilitime with Understanding the role of ENV variable in loading plugins, clarifying code snippet for plugin inclusion by providing hΔrdshell helped with solanaPlugin configuration and understanding of AgentRuntime
- Everyone in the chat, including @shaw helped @fudme(01:31) with Connecting a bot's actions/functions on server by providing Customizing character and connecting to Discord (🔸 WFB)
- CaptainCool helped All with Resolving Twitter agent client plugin string error in character.json file. by providing DataRelic (04:59) provided the GitHub link for CaptainCool's issue regarding not being able to post new tweets after merging specific changes.
- [Tharakesh](05:16) helped Windows users facing issues with Eliza setup with Provided guidance on Node version and debugging using claude by providing [Radagast](05:32, 05:34)
- [Mina] helped [Citizen1553, Tharakesh] with Technical issue resolution by providing Resolved missing properties in adapter
- [DataRelic] helped [Mina, MrEnjOy_] with Feature implementation by providing Provided Twitter setup instructions for Eliza bot integration.
- [Mina, DataRelic] helped Twitter cookies setup for environment. with  by providing DataRelic helps Mina with adding Twitter client in character JSON file.
- @hΔrdshell helped @radagast with Character Model Loading Issue by providing [Radagast] suggested setting up the trump character on correct model for hΔrdshell's issue with finding models.
- @Alain Schaerer helped @Tharakesh with Explaining the intent of @dexbruce's PR. by providing Understanding pull request purpose

## Action Items

### Technical Tasks
- Update dependencies to use modified Twitter-client module (mentioned by @N00t)
- Implement vercel or replit integration (mentioned by @Odilitime)
- Integrate data with Eliza using a custom plugin (mentioned by @Moudinho3)
- Resolve character.json plugin string issue by modifying the default character in .ts format and starting it successfully. (mentioned by crazysailor1000)
- Update Node version to match Eliza's requirements (mentioned by [Tharakesh](05:18))
- Update PostgresDatabaseAdapter to resolve missing properties error (mentioned by [Citizen1553, Mina])
- Add Twitter client to character JSON file (mentioned by [Mina, DataRelic])
- Load character model correctly (mentioned by [hΔrdshell, Radagast])
- Set API key for Hugging Face endpoints in .env file and index.ts. (mentioned by [Alain Schaerer, Radagast])
- Prevent multiple downloads for localLama model on pnpm build (mentioned by @dexbruce)
- Prepare a new Hugging Face endpoint without requiring explicit CUDA passing, to be compatible with Apple Silicon MacBooks using Metal. (mentioned by @dexbruce)

### Documentation Needs
- Document how agents interact with each other using rooms and actions in the codebase. (mentioned by @razor)
- Configure max response length in the relevant file (mentioned by @Radagast)
- Update README to explain Llama extension of Twitter agent client (mentioned by Bootoshi)
- Use claude for debugging issues on Windows platform with Eliza setup. (mentioned by [Radagast](05:32))
- Login into the twitter account and pull cookie details from browser dev tools for environment setup. (mentioned by DataRelic)
- Simplify system to provide base URL, API key and model name only. (mentioned by @Alain Schaerer)

### Feature Requests
- Ensure domain is whitelisted for OpenAI API key usage or paste the key manually when using it. (mentioned by DataRelic)
- Set up Twitter integration for Eliza bot using environment variables and dry run option. (mentioned by [DataRelic, MrEnjOy_])
- Investigate Dstack TEE integration usage (mentioned by [KarlK | Galadriel])