# 💻-coders 2024-11-29

## Summary
The discussion focused on technical issues related to setting up llama version information in both .env and character files. @TrenchFren suggested using a verified account instead of fresh one for getting the llama working, which was confirmed by others as well (@VI). The conversation also touched upon deploying servers via AWS EC2 Instance (mentioned by @VI) to achieve this setup.

## FAQ
- Do we need llama version information in both .env and character file? Do I deploy to a server using AWS EC2 Instance for this purpose? Or do you have any other suggestions on how can it be achieved? (asked by @jaseem)
- 'For env vars, is the username just name without @ or should we use user id?' (asked by @hΔrdshell)
- How can I configure my Twitter agent to respond when replies? How do you write it while keeping secrets in .env and changing everything necessary for lambda models without having solana set up yet, as well as fixing errors with hijacking OPENAI_BASE_URL & API KEY from the defaultCharacter.ts file? (asked by [SMA])
- When running `pnpm start --character= (asked by [0xcooker])
- Why does Twitter scraper not find all tweets in its search for my account? (asked by [RL])
- Why is the bot not responding? What can be done to fix it? (asked by @hosermage)
- How do I configure my Twitter agent to answer replies or comments on posts/tweets, and where should this configuration reside in codebase? (asked by @Konstantine)
- How can I make my bot detect replies? (05:21)? (asked by @Konstantine)
- Why does the character selection not work as expected and how to resolve 'Creating context' error?(05:23) (asked by AM)
- Why aren't you on stable? (Referring to Ophiuchus project version) (asked by [SMA])

## Who Helped Who
- @TrenchFren helped general discussion group with llama version information setup by providing @TrenchFren suggested using a verified account instead of fresh one to get llama working.
- @DataRelic helped @hΔrdshell with Twitter environment variable configuration by providing @DataRelic provided the correct format for Twitter env vars, which helped @hΔrdshell with his query about rate limiting.
- [st4rgard3n (03:24)] helped Twitter scraper issue with shadowbanning account. with Configure Twitter agent for replies and lambda models without solana setup by providing hΔrdshell provided a solution to bypassing bot checks using real user cookies
- [SMA (04:36)] helped Error with running Lambda model in .env file. with Fixing errors when using lambda models and hijacked OPENAI_BASE_URL & API KEY by providing [Tharakesh] suggested asking Claude or Copilot about the error
- @Tharakesh helped @Teo with Provided steps to clean and reinstall packages. by providing Troubleshooting pnpm installation issues.
- @hosermage helped Discord chat members who experienced bot's lack of response. with Debugging issue causing the bot to not respond by providing hosermage suggested checking debug messages for troubleshooting non-responses
- @0xdexplorer helped @Konstantine with Fetching and updating necessary packages to resolve the problem. by providing @Konstantine asked for help with bot detection issue, @0xdexplorer suggested checking latest version of packages (05:21-05:27).
- @Isk Heiheh helped @AM with Review and correct the character.character.json to resolve model mismatch. by providing AM asked for help with character selection issue, @IskHeiheh suggested reviewing syntax in heheh's character file (05:23-05:41).
- [SMA] helped How do I revert back without messing up my fixes and additions? with Reverting to a previous version of the project by providing [Ophiuchus](05:38)
- @puremood, @Ophiuchus helped @Tharakesh with Connecting Bot with twitter by providing Ophiuchus and puremood helped Tharakesh connect his bot to Twitter using a new version of 'agent-twitter-client' from github.

## Action Items

### Technical Tasks
- Deploy to a server using AWS EC2 Instance (mentioned by @VI)
- Configure Twitter scraper to bypass bot checks using real user cookies (mentioned by [hΔrdshell (03:44)])
- Run stable version releases using code2prompt for Claude. (mentioned by @Ophiuchus)
- Investigate debug messages to identify issues causing non-responses (mentioned by hosermage)
- Update Konstantine's bot to detect replies (mentioned by @Konstantine)
- Resolve issue with character selection in AM's bot using Trump or Tate characters. Investigate the cause of 'Creating context' error and model mismatch. (mentioned by @AM)
- Review syntax for heheh character file, as mentioned by @IskHeiheh to ensure correctness. Investigate the cause of 'model' error and mismatch. (mentioned by @Isk Heiheh)
- Token count & trim message history for debugging (mentioned by [Ophiuchus](05:35))
- Clone eliza repository, checkout v0.1.4-alpha.3 tag (mentioned by @Ophiuchus)
- Connect to Twitter using agent-twitter-client from github repo https://github.com/ai16z/agent-twitter-client/tree/main (mentioned by @puremood and @Ophiuchus)
- Review character JSON file for missing elements (mentioned by [Isk heheh (05:59)])
- Investigate LLM model connection issues with Heurist or similar services. (mentioned by [Isk heheh (05:59)])
- Review manual login process to remove 2FA confirmation code requirement. (mentioned by [Tharakesh (06:04), puremood] [06:05])
- Resolve TS2345 error by adding missing 'agentId' property to object (mentioned by @Ophiuchus)

### Documentation Needs
- Review and optimize token count in message handling process. (mentioned by 0xdexplorer)
- Fetch latest version of packages for Konstantine, as suggested by @0xdexplorer. (mentioned by @0xdexplorer)
- Resolve SqliteError: Vector dimension mismatch error when using fresh sqlite database. (mentioned by @Havohej)

### Feature Requests
- Update permissions for 8bitoracle bot on Discord servers. (mentioned by @hosermage)
- Shorten character style guides, bio and lore temporarily to reduce memory usage. (mentioned by [Ophiuchus](05:35))
- Update Twitter client npm for media support and topic functionality enhancements. (mentioned by [Ophiuchus, puremood] [06:00])