# 💻-coders 2024-12-02

## Summary
The chat focused on technical discussions about hosting Eliza, adjusting the twitter scraper for original tweets only and choosing a character at login. Kanye faced an issue with looping errors while using grok & openai APIs.

## FAQ
- Why is the same tweet being checked over and over again with warning signs still showing? Using grok & openai, but terminal works fine. Any ideas why this happens on Twitter only (00:34)? Answered by:[SotoAlt | WAWE] (asked by [Kanye])
- What's the best Discord channel to find developers looking for work and joining a team? How can I do this without breaking any rules? (asked by @T)
- How does your AWS Lambda worker handle distributed, live responses when needed while keeping wallet access air-gapped with only client DB connection (and possibly an event bus if required)? (asked by :elizasalute:)
- Anybody can help me with this? Stuck here, agent on twitter not responding to replies. Running latest and version 0.1.3. (asked by @kanye (04:42))
- Why does SQLITE throw an error when inputting image? (asked by [VI](05:22))
- Does anyone have a suggestion for how to integrate this into the starter - when I try to download the package from GitHub directly, I get bunch of type and other errors?
Odilitime (05:47): You can runs an agent without any token... Starter relies on npm being at same tag.
꧁Ninja_Dev꧂(05:48): But lets say, I do have a token and its on EVM. Seems like either way the token is separate from the agent?
If so you just tie in the token... Odilitime (05:49)... Jacob (06:12) (asked by @Jacob)
- Does AI16 have support for something like VIRTUALS' Roblox Westwood game? Specifically wondering how their ai agents can make decisions in a seemingly continuous space, such as moving to X location and shooting in Y direction, in real time. Where should I go ask this question or do you have a link to the game? (asked by @Bullish)
- Do you understand my previous query? Do you have any suggestions on how easy it is to build a game integration with AI16's stack, and what documentation/support exists for this process? (asked by @Bullish)
- Can ai16z work for VTuber models as well? Should I use it or stick with the other AI and apply ai16z to socials only? (asked by @sleepysign)
- When will metamike open source integrated version of chatvrm on github, if not already available for users using v0.1.3? (asked by @jin)

## Who Helped Who
- [SotoAlt | WAWE] helped [Kanye (00:34)] with Troubleshooting Twitter API issues by providing Help Kanye with the looping error issue
- @T helped All members with similar issues. with @LaserRiot explained how their AWS Lambda worker operates in a distributed manner while keeping wallet access air-gapped, providing insight to others facing related challenges. Recipients: All interested parties by providing @crazysailor1000 provided a solution to the issue of switching models from OpenAI to Anthropic, which involved deleting db.sqlite and modifying settings for embeddingModel.
- [AIFlow.ML](04:39) helped @kungfumode(05:12) with Resolving agent-twitter client issue by providing wil (04:30) helped Kanye by suggesting to update the model ts file & rebuild.
- [solswappa](04:39) helped [kungfumode(05:12)] with Optimizing agent-twitter client by providing Havohej (05:07) offered to investigate unused checks and functions in the twitter scraper library.
- @Jacob helped @Jacob with Integration of the Eliza Agent in Starter Project by providing @Odilitime provided a solution to integrate Eliza agent into starter by using npm latest version.
- @Odilitime helped  with Inquiry on AI16's capabilities for continuous space decision-making in games. by providing Odilitime provided information about an existing bot integrated online game.
- @AM helped @Kanye with Addressing recurring error message on AI16 platform by providing AM acknowledged Kanye’s issue with a positive response, indicating awareness.
-  helped @sleepysign with Added contributor role and provided link for integrated chatvrm version by providing @jin
- @sleepysign helped @Black with Resolving error with AMD card by providing @Odilitime helped @andy8052 by suggesting to remove 'device: gpu' references for non-AMD GPU compatibility.
- @Odilitime helped @andy8052 with Finding alternative voice solutions by providing @SotoAlt suggested using Vocaloid, specifically Hatsune Miku.

## Action Items

### Technical Tasks
- Host Eliza locally with M1 Pro and 16 GB RAM (mentioned by [Sam (00:23)])
- Choose character at login for AIFlow.ML platform (mentioned by [AIFlow.ML (02:06)])
- Resolve issue related to switching models from OpenAI to Anthropic (mentioned by @crazysailor1000)
- Update model ts file & rebuild to fix issue (mentioned by [wil](04:30))
- Investigate unused checks and functions in agent-twitter-client library for optimization. (mentioned by [Havohej](05:02))
- Modify TwitterPipeline.js to handle replies and the tweets they are responding to. (mentioned by [Havohej](05:39))
- Integrate Eliza agent into starter by using npm latest version (mentioned by Odilitime)
- Investigate Kanye's recurring error with AI16 (mentioned by @Kanye)
- Implement new release for users on v0.1.3 (mentioned by @Bunchu)
- Edit source to remove 'device: gpu' instances for non-AMD GPU compatibility. (mentioned by Odilitime)
- Create a character JSON file to modify prompts (mentioned by Odilitime)

### Documentation Needs
- Find a suitable Discord channel for developers seeking work and joining teams. (mentioned by :elizasalute:)
- Update documentation for createMemoriesFromFiles function in eliza client-github package (mentioned by [PC](05:26))
- Provide documentation and support for game integration stack. (mentioned by @Odilitime)
- Update eliza startr fork to latest version using pull or sync. (mentioned by @BlackJesus)
- Update character file documentation to reflect current system (mentioned by andy8052)

### Feature Requests
- Adjust Twitter scraper to only include original tweets, not replies. (mentioned by [Havohej (00:42)])
- Test the whatsapp plugin to identify build issues. (mentioned by Citizen1553)
- Integrate own voices using Eleven API (mentioned by sleepysign)
- Create custom plugin for Twitter integration with task triggers. (mentioned by Ninja_Dev)