# 💻-coders 2024-12-03

## Summary
The chat focused on technical discussions around the 'processActions' code part and its improvement. AIFlow.ML requested Docker docs, which was provided by Rick (shared via Melted). Kanye asked about potential changes in the code.

## FAQ
- Can you link me the docker documentation? Does it also start the DB ? (asked by @AIFlow.ML)
- is there something that needs to be changed in the code? (asked by @Kanye)
- What should I do...can anyone tell me please?, (asked by Tharakesh)
- is there a way to integrate function calling into the AI model ? (asked by ray)
- anyone able to make the agent create a wallet by their own? (asked by SotoAlt | WAWE)
- Did you already run npm build? If yes, then the dist folder might be your issue. (asked by @CS)
- How can I use this library inside my NestJS project? (asked by @HoneyPotSmoker🐻⛓🍯)
- Where do I find the database? - Answered by @2696 (asked by @vice man)
- When will other plugins be added to NPM branch? (asked by @BlackJesus)
- But ran into some issues while installing the twitter client - it says the package doesn’t exist? did anyone else run into this issue? would love any help here. thanks a lot 🫡 (asked by @allan28)

## Who Helped Who
- @Rick helped @Melted with Finding docker documentation by providing @AIFlow.ML asked for help with Docker docs, @Jacob provided a link
- Nona (ag/acc) helped Tharakesh with Implementing function calls in AI model by providing dievardump provided guidance on integrating action calling within Eliza.
- dievardump helped tybq93 with Resolving library import errors by providing tybq93 asked for help with import error, NestedJS project issue
- @CS helped @HoneyPotSmoker🐻⛓🍯 with Adding to friends list by providing @clover added you as a friend, drop me dm when available.
- @2696 helped [Vice Man] with Database location issue by providing Locating DB within agent folder and data subfolder - Provided by @2696, Elterremoto82
- @allan28 helped @Bill Gains with Provided alternative libraries for Twitter client installation issues by providing @SotoAlt | WAWE
- @Matthias|zKorp ☁ helped git issue with plugin-starknet on v0.1.5-alpha.0 with Technical Tasks by providing @CS helped Matthias | zKorp ☁ by suggesting git checkout stableVersionTag @06:15
- @Konstantine helped solana priorityFee object query with Technical Tasks by providing @Agent Joshua ₱ provided information about TEE feature and Intel TDX Server @06:32
- @Odilitime helped @AIFlow.ML with Add Slack Client File by providing Odilitime helped AIFlow.ML by explaining where and how they should include the slack client in their project, as well as discussing potential improvements to dependency management.
- [Odilitime (08:05)] helped General community members with Documentation update by providing Odilitime offered help with adding steps for the new client in documentation.

## Action Items

### Technical Tasks
- Investigate docker documentation for AIFlow.ML (mentioned by @AIFlow.ML)
- Implement action calling within Eliza similar to 'open ai function calling' (mentioned by dievardump)
- Run npm build (mentioned by @CS)
- Delete db sqlite, rebuild (mentioned by @SotoAlt | WAWE)
- Rebuild project (mentioned by [SotoAlt, Vice man])
- Locate the database within agent folder and data subfolder. (mentioned by [Vice Man, 2696, Elterremoto82])
- Investigate the issue with character file reverting to 'tate'. (mentioned by [Vice Man])
- Investigate issues with installing Twitter client using Eliza framework (mentioned by @allan28)
- Clone repo for agent setup (mentioned by @CS)
- Add slack client file for standalone testing (mentioned by @AIFlow.ML)
- Refactor code for centralization (mentioned by [AIFlow.ML (07:58)])
- Explore modifications to reply regularly on Twitter from a predefined list of accounts. (mentioned by _Xd9f)

### Documentation Needs
- Discuss improvements to 'processActions' code part on GitHub (mentioned by @dievardump)
- Resolve import error for '@ai16z/adapter-postgres', use dynamic import() instead of require in CommonJS modules. (mentioned by tybq93)
- Add you as a friend and drop me a dm when available. (mentioned by @clover)
- Checkout stable version tag in git (mentioned by allan28 @06:15)
- Consider adding configuration files to manage npm dependencies and avoid touching .ts or other moving parts. (mentioned by @Odilitime)
- Create a GitHub issue to discuss refactor plans and get consensus from other developers. (mentioned by [Odilitime (07:59), AIFlow.ML (08:01)])

### Feature Requests
- Research and implement 'create wallet on TEE' feature in the newest Eliza release or find alternative for storing private keys. (mentioned by @SotoAlt | WAWE)
- Investigate separate social accounts for agents (mentioned by _Xd9f)