# 💻-coders 2024-12-04

## Summary
The chat segment focused on technical discussions related to implementing RAG for a bot, streaming audio using 11 labs, setting up image generation with training images and troubleshooting issues in character knowledge processing. RedArcher26 asked about how to implement the Retrieval-Augmented Generation (RAG) model into their Discord Bot so it can answer based on provided documents of knowledge.

## FAQ
- Can someone tell me how to implement RAG for the bot? As in I want to pass a document with knowledge and have the bot answer based on that knowledge. Who can help or provide resources? (asked by RedArcher26)
- When running `pnpm add -D ts-node typescript @types/node --filter '@ai16z/agent'` , it outputs 'No projects matched filters'. What should I do? Thanks! (asked by Harvz)
- Which file should plugins be added to? Is discord voice chat built-in or a plugin, and why is there an error when trying to join the voice chat? (02:05 - 03:19) (asked by Vice man)
- How can browser access be enabled for nodePlugin related queries about internet fetching values? (asked by [AIFlow.ML])
- How should I write the solana plugin correctly for character interaction? What is a correct replacement instead of 'solana' in JSON config file? (asked by @Konstantine (04:51))
- Does Eliza/Spartan have public endpoint which can be used to integrate them into an app? (asked by @Ancosero (05:26))
- How do I change the model being used by Anthropic on Eliza, like switching between sonnet and opus? (asked by @Thebasement (06:14))
- Can we use 'ai package' to add streaming text option? What are the limitations and potential solutions for real-time audio conversation in Discord voice integration or Twitter Spaces? (asked by @Jacob)
-  (asked by @Odilitime)
- Has anyone built RAG with Eliza? Who can help me get started on this project? (asked by @hajmamad)

## Who Helped Who
- izzy3911 helped Tharakesh with Character Knowledge Processing by providing izzy3911 provided a link to YouTube videos that might help Tharakesh with his issue regarding character knowledge processing.
- [AIFlow.ML] helped Vice man with Plugin file addition and discord voice chat setup by providing Client addition and configuration in agent/package.json workspace, index.ts initialization (02:18 - 04:35)
- @Ancosero helped @Everyone with Reminded the group of their common interest in cryptocurrency by providing AIFlow.ML provided context about crypto community (05:26)
- @JJJ helped @Badtech with Provided a solution to chat with custom characters in tweeter mode by providing jjj suggested typing directly into terminal for character interaction (05:51)
- @Bunchu helped @Jacob with API Key Sharing & Resource Recommendation by providing Bunchu offered to share their Tavily API key and recommended attending Agent Dev School for more information.
- @Ladi helped All members with Documentation Needs by providing Fixing missing scripts for @ai16z/plugin-node installation
- @jjj helped @hajmamad with Fixing Solana Crashes by providing Konstantine provided a solution to fix solana crashes by using await in getCachedData function.
- ꧁Ninja_Dev helped hajmamad with Implemented the suggestion and found it helpful. by providing Coelacanth suggested injecting pre-knowledge into character file's system property.
- @W3_Bounty helped @hajmamad with Handling of agents based on query by providing W3_Bounty provided information on using multiple characters with different settings.
- Ξ2T helped props for PR, easy to add Farcaster client and get an agent casting (11:10) with Added the Farcaster Client by providing @sayangel

## Action Items

### Technical Tasks
- Implement RAG for bot to answer based on knowledge document (mentioned by RedArcher26)
- Add client to agent/package.json workspace configuration (mentioned by [AIFlow.ML (02:18)])
- Implement a solana plugin for character interaction (mentioned by @Konstantine (04:51))
- Add streaming text option using 'ai package' (mentioned by @Jacob)
- Investigate race condition when building packages (mentioned by @jjj)
- Improve knowledge section search relevancy (mentioned by Coelacanth)
- Improve knowledge retrieval flexibility (mentioned by @Coelacanth)
- Investigate possible configuration issues causing evm issue (mentioned by @꧁Ninja_Dev꧂)
- Resolve API key errors in agent deployment process (mentioned by hibijibi)
- Fix solana plugin error causing unauthorized access (mentioned by @Bunchu)
- Switch from version v0.1.5 of Eliza codebase to v0.1-alpha3, as it appears more stable. (mentioned by Coelacanth)

### Documentation Needs
- Ensure correct file input in character's knowledge key update process (mentioned by izzy3911)
- Include client addition in index.ts for initialization (mentioned by [AIFlow.ML (02:18)])
- Investigate missing scripts/postinstall.js for @ai16z/plugin-node installation (mentioned by @Ladi)
- Limit context length or include entries with high confidence score in the vectorized search. (mentioned by Coelacanth)
- Document the settings entry for overriding specific provider models in character files. (mentioned by @Coelacanth)

### Feature Requests
- Integrate Eliza/Spartan with public endpoint in app development (mentioned by @Ancosero (05:26))
- Explore DAO.fun API for potential integration. (mentioned by @rckprtr)
- Implement await for getCachedData function to fix Solana crashes. (mentioned by @Konstantine)
- Resolve issue with Twitter client replying to historical interactions on first run in a fresh environment. (mentioned by @Coelacanth)