# 💻-coders 2024-12-05

## Summary
The discussion focused on creating custom plugins, running them from .json files to TS configs. Lambert successfully ran his methods using 'plugins: []' without modifying agent/src/index.ts but with custom clients calling the plugin. Ayvaras mentioned memory consumption issues needing optimization.

## FAQ
- Is there a ts equivalent for running a character from a json file? How to import and use custom plugins in agent/src/index.ts? (asked by [DL])
- How did you solve the memory consumption issue with your uncensored model? (asked by [nylon, nylon])
- What's the difference between Solana plugin and Goat one? How to login with cookies in browser, then copy into .env file following specific syntax mentioned somewhere on README? (asked by [SotoAlt | WAWE])
- Is there any documentation available for applying RAG to Eliza?. (asked by [agu (02:18)])
- Thanks for the recommendation, any specific reason? 🙏 (asked by @agu)
- Why isn't it working in server but works locally? (asked by @ayvaras)
- How can we resolve this issue with the IP changes on our servers? (asked by @Ayvaras)
- Did you use cookies or enabled two-factor authentication (2FA) to log in? (asked by @lambert)
- 'I hope it works' and 'isn't it mandatory?' referring to setting cookies for a software feature. The responses were from lambert at [02:40]. (asked by [Ayvaras (02:36, 02:39)])
- Why am I getting an error when trying to generate a new tweet? What should be in the .env file for it to work correctly? (asked by @Manasvi)

## Who Helped Who
- [DL] helped [dl] with Create a custom plugin for characters and import it into the ts file. by providing Odilitime explained how to set up character object in agent/src/index.ts.
- [coinwitch (ai16z intern)] helped [SotoAlt | WAWE] with Troubleshooting Eliza Agent by providing coinwitch helped with getting the agent working in eliza-starter project.
- @sototal helped @ayvaras with Resolving server IP change issue by providing SotoAlt | WAWE suggested using cookies for login and enabling 2FA as a solution.
- 'Try without' and 'nah my agent doesn't have any', suggesting Ayvaras to test the software feature with cookies disabled. helped [Ayvaras (02:39, 02:41)] with 'Investigate why setting VPN doesn't work' by providing [lambert (02:38, 02:40)]
- @lambert, @Tharakesh helped @Ayvaras with Troubleshooting cookie usage in the application by providing Ayvaras asked for help with cookies and database deletion
- @lambert helped @Manasvi with Troubleshooting error in Eliza project. by providing Provided guidance on checking Twitter API credentials and ensuring correct setup.
- frenchplace helped problem with loading content into memory via API or commands with loading sources for agent's knowledge by providing Robotic Dreams provided a solution on how to specify plugins in character file and set required fields.
- @DL helped @cleverson1 with Resolving Twitter integration issue with @ai16z/plugin-image-generation. by providing DL (@ai16z) provided guidance on using image plugin without specifying plugins field and ensuring correct AI API keys are used.
- [Bunchu] helped [Cleverson1] with Adding web search plugin by providing @bunchu helped @cleverson1 by providing steps to add a plugin and resolve image posting issue.
- kungfumode helped Agent Issue Resolution Successful. with Tweet formatting by providing Ayvaras provided a PR to fix the issue of agents posting multi-line tweets.

## Action Items

### Technical Tasks
- Create a custom plugin for character files (mentioned by [DL, lambert])
- Create a TG token bot (mentioned by [SotoAlt | WAWE])
- Watch Agent Dev School videos for learning (mentioned by @coinwitch)
- Investigate why setting VPN to London doesn't work (mentioned by [Ayvaras (02:36)])
- Check if folder2knowledge requires careful handling of documents or can handle multiple PDF files (mentioned by [Rat King (02:37)])
- Determine the source and purpose of 'Generating' console log messages in folder2knowledge (mentioned by [coinwitch (ai16z intern) (02:37)])
- Test the latest version of an unspecified software without cookies (mentioned by [lambert (02:40)])
- Investigate processing knowledge step issue (mentioned by @Tharakesh)
- Update Twitter API credentials (mentioned by Manasvi)
- Set up image generation with parameters to character file (mentioned by cleverson1)
- Remove the 'plugins' field from character JSON for proper AI API key usage with image plugin (mentioned by @DL)
- Investigate why image posting is not working (mentioned by [DL, Bunchu])
- Fix tweet formatting issue by applying PR #856 (mentioned by Ayvaras)

### Documentation Needs
- Optimize memory consumption of the uncensored model. (mentioned by Ayvaras)
- Fix the issue with `Cannot GET /` error in eliza-starter project. (mentioned by [coinwitch (ai16z intern)])
- Ensure the .env file contains correct Twitter account details. (mentioned by Ayvaras)
- Use pnpm run build for Twitter agent and terminal runtime agent, investigate if possible. (mentioned by Konstantine)
- Create a GitHub issue to address image plugin documentation (mentioned by @coinwitch (ai16z intern))
- Add @ai16z/plugin-web-search to dependencies in package.json and import it into index.ts. (mentioned by [Bunchu])

### Feature Requests
- Resolve server IP change issue by using cookies or enabling two-factor authentication (2FA) (mentioned by @SotoAlt | WAWE)