# 💻-coders 2024-12-07

## Summary
The Discord chat segment focused on technical discussions related to Eliza's capabilities and project setup. Key points included using the latest node version, pnpm for dependency management, investigating independent conversation initiation across different platforms (Twitter, TG, Discord), resolving issues with 'pnpm start --characters', addressing errors during 'pnpm build', preserving memory between runs to avoid repeated responses on Twitter.

## FAQ
- Is Eliza capable of initiating conversation without being mentioned first on Twitter, TG and Discord? Or is it always possible but I missed it before? (asked by [razzzz])
- Why does pnpm start --characters keep trying to use local model when specifying Anthropic as the modelProvider and inputting API in .env files? How can I resolve this? (asked by [gavinlouuu])
- Is there a way for Eliza to preserve memory between runs, so it doesn't re-respond with the same Twitter comments after each restart? How can I achieve this? (asked by [technoir (01:12)])
- Which parts of Nadar’s video on Eliza have been adjusted already to avoid errors during 'pnpm build' using the latest checkout command? Is it .env file, character file or both? (asked by [Robin (01:14)])
- What are the steps required for deploying an agent and how much does it cost? (with Twitter only?) (asked by @Clive0x1)
- I'm getting errors while doing pnpm build. Any ideas? (asked by @Mansi | SuperFunSocial)
- Are you working on video generation with an API? (asked by @umut)
- Are there any sessions planned for learning to navigate the repo? Who can help with character customization and deployment on Eliza platform? What time zone is AIFlow.ML in, Asia or relative Crypto timezone? (asked by Kenk)
- How do I fix this error when launching an agent using your framework: Failed at node_modules/.pnpm/canvas@2.11.2/node_modules/canvas? What's the image model provider being used, core or plugin one? (asked by maimun)
- Is the API endpoint not included in standard package and is a paid feature? Answered by @Bunchu (asked by @jjj)

## Who Helped Who
- [razzzz] helped Eliza development with Project Setup Assistance by providing [SotoAlt | WAWE] provided information on node version and pnpm usage for Eliza project setup
- [razzzz] helped Eliza development with Feature Inquiry Assistance by providing [SotoAlt | WAWE] provided information on investigating independent conversation initiation using Eliza
- [technoir] helped Eliza development with Memory Preservation Inquiry Assistance by providing [SotoAlt | WAWE] provided information on preserving memory between runs for Eliza
- @Robin helped @gavinlouuu with Edit environment variables in project root by providing @N00t was helped by @Robin to edit the .env file for deploying agents.
- AIFlow.ML helped maimun with Resolving Agent Model Loading Issue by providing gavinlouuu provided insight on agent loading a different model despite setting 'anthropic', suggesting an issue with .env file.
- @AIFlow.ML helped @Bunchu with Troubleshooting API Key Issues by providing AIFlow.ML confirmed API key is passed correctly, but Claude might not be the correct image model.
- umut helped maimun and Sam with Improving bot's response mechanism for generating images without user interaction. by providing Provided solution to avoid sending a message back before image generation
- @AIFlow.ML helped @maimun with Successful by providing Resolving permission error when installing dependencies
- @big dookie helped @maimun with Launched Twitter Agent by providing Provided advice on launching the agent and troubleshooting errors
- [@RL] helped [@Lamb] with Resolving Twitter credentials loading errors by providing @RL suggested staying in dev mode to log around error when using .env file. Lamb confirmed the issue and agreed with RL's suggestion.

## Action Items

### Technical Tasks
- Use latest node version (23+) with pnpm clean, install dependencies using 'pnpm i', build project (mentioned by [SotoAlt | WAWE])
- Investigate Eliza's capability to initiate conversation without being mentioned first on Twitter, TG and Discord (mentioned by [razzzz])
- Check if Eliza can reply using the twitter API for independent conversation initiation (PR mentioned by Shaw) (mentioned by [SotoAlt | WAWE])
- Resolve issues with pnpm start --characters using Anthropic modelProvider and API in .env files (mentioned by [gavinlouuu])
- Address errors encountered during 'pnpm build' using Eliza latest checkout command (Nadar’s video) (mentioned by [Mansi | SuperFunSocial])
- Deploy an agent with custom API endpoints (mentioned by @Robin)
- Investigate why agent is loading a different model despite setting 'anthropic' as provider (mentioned by gavinlouuu)
- Investigate API key issues for correct header usage (mentioned by @jjj)
- Consider using PostgreSQL for database needs (mentioned by AIFlow.ML)
- Resolve permission error when installing dependencies (mentioned by @AIFlow.ML)
- Resolve authentication error: DenyLoginSubtask (mentioned by @Lamb)
- Staying in dev mode to log around error when using .env for Twitter credentials (mentioned by [RL, Lamb])

### Documentation Needs
- Preserve memory between runs to avoid re-responding to Twitter comments (mentioned by [technoir, Robin (01:14)])
- Resolve error in discordjs+opus module installation (mentioned by LeEth_James)
- Provide detailed log errors using pnpm dev for troubleshooting. (mentioned by @RL)
- Provide examples of where and how to include `openAISettings` in the codebase. (mentioned by [delegatecall])

### Feature Requests
- Use OLLAMA for local LLM to avoid costs. (mentioned by @N00t)
- Explore alternative methods to send longer tweets without authorization errors. (mentioned by @Bootoshi)
- Update character file to include 'farcaster' in clients. (mentioned by @Sam)
- Clarify the need and purpose of a 25-minute input video (mentioned by @big dookie)