# dev-contributors 2024-11-20

## Summary
 In the Discord chat, Odilitime encountered an SqliteError due to a vector dimension mismatch between two vectors of different dimensions (384 vs 1536) while attempting to search memories by embedding in their system. Despite deleting the db.sqlite file and setting `USE_OPENAI_EMBEDDING=TRUE` as per Loaf's suggestion, Odilitime still faced issues with undefined content errors when sending messages. The team decided to delete other caches located at core/cache and use the environment variable for OpenAI embeddings. Additionally, they discussed GitHub contributor roles, specifically mentioning @jin, @droyster, and @YODȺ26 as potential contributors. Odilitime also announced that version v0.1.3 of their project is working well.

## FAQ
 - What is the error when sending a message due to vector dimension mismatch?
  - Odilitime: The error occurs because the first vector has 384 dimensions while the second one has 1536 dimensions, causing an SqliteError in the searchMemoriesByEmbedding function.

- Who is responsible for handling SQLite vectors and what could be a potential solution?
  - Odilitime: The sqlite vector issue seems to be related to the MessageManager module within the client-discord package. Deleting db.sqlite file didn't resolve it, but setting USE_OPENAI_EMBEDDING=TRUE in the .env file might help.

- What is causing the TypeError: Cannot read properties of undefined (reading 'content') error?
  - Odilitime and loaf: The error occurs when trying to process actions at AgentRuntime or handle a message within MessageManager, possibly due to an issue with caching or database connections. Deleting caches and db.sqlite file might help resolve the problem.

- How can you set up USE_OPENAI_EMBEDDING=TRUE in your environment?
  - Odilitime: You need to add `USE_OPENAI_EMBEDDING=TRUE` as a variable in your .env file, which is used for storing environment variables.

- What are the locations of other caches that might be causing issues with SQLite vectors and TypeError?
  - Odilitime: Other caches can be found within core/cache directory. Deleting these caches may help resolve the issue.

## Who Helped Who
 - Loaf helped Odilitime with resolving a vector dimension mismatch error by suggesting to delete the db.sqlite file, which did not resolve the issue initially but led to further troubleshooting steps.
- Loaf assisted Odilitime in addressing an SQLite vector dimension mismatch and TypeError issues by recommending deletion of caches and using environment variables for OpenAI embeddings.

## Action Items
 Technical Tasks:
- Resolve SqliteError related to vector dimension mismatch issue (mentioned by Odilitime)
  - Investigate the cause of the error and fix it, ensuring that both vectors have matching dimensions before processing them in `searchMemoriesByEmbedding` function.
- Fix TypeError when reading 'content' property from undefined object (mentioned by Odilitime)
  - Debug the code to identify why an undefined object is being accessed for its 'content' property and implement a solution to prevent this error.
- Delete db.sqlite file and recreate it with updated settings (suggested by loaf, agreed upon by Odilitime)
  - Remove the existing `db.sqlite` database file from the project directory and create a new one after setting up the environment variable for using OpenAI embeddings (`USE_OPENAI_EMBEDDING=TRUE`).
- Clear other caches (mentioned by loaf, questioned by Odilitime)
  - Locate and delete any additional cache files that may be causing issues with the application. This includes clearing out the `core/cache` directory mentioned by Odilitime.

Feature Requests:
- Add GitHub contributor roles for @jin, @droyster, and @YODȺ26 (requested by Odilitime)
  - Update the project's repository settings to grant specific permissions or access levels to these users as requested by Odilitime.

