# dev-contributors 2024-11-22

## Summary
 In the recent discussions, Odilitime proposed adding more API endpoints to the client-direct since it already uses port 3000 with CORS enabled in Express server; Jin suggested a non-web accounting framework for bot users to set spend limits on inference and mentioned useful tools he made. They also discussed automating TypeScript comments for better API documentation, considering the repository's size and need for structural coverage through examples. Loaf recommended building out React interfaces directly in the client with runtime running there too. RS1 shared a shell script to provide codebase context, while Jin pointed out temporary issues with Gemini Pro but remained optimistic about future improvements by 2025. Yikesawjeez asked Shannon Code for details on Eliza's capabilities regarding posting videos and handling NFT transactions across different chains.

## FAQ
 - How can we improve the handling communication between React client and runtime?
  - Jin: Adding more API endpoints in the client-side since it already uses port 3000 with CORS enabled express server makes sense. This approach allows for better control over data exchange and reduces dependency on backend services.

- Is there a need for an internal non-web accounting framework within the bot?
  - Odilitime: Yes, having a non-web accounting framework would allow users to set spend limits for inference without relying solely on web client interactions. The web client can still tap into this framework as needed.

- What tools are available for automating TypeScript comments and documentation pipelines?
  - Jin: There is an existing tool called `issues_prs` that helps with fetching issues and pull requests, which could be useful in creating a more comprehensive documentation pipeline. Additionally, exploring other tools like code2prompt might provide further insights into automating TypeScript comments for API docs.

- How can we improve the onboarding process to cover the structure of our large repository?
  - Jin: Focusing on providing examples and demonstrations of how different pieces are being used within the project would be more important than covering every aspect in detail. This approach helps new contributors understand the overall architecture without overwhelming them with information.

- Can Eliza post videos to Twitter, move NFTs, and perform transactions on multiple chains?
  - Odilitime: As of now, there is no evidence that Eliza can post videos to Twitter or interact with wallets for sending transactions and reading balances. However, these features might be added in the future as development progresses.

## Who Helped Who
 - Odilitime helped Jin with setting up a non-web accounting framework by suggesting an internal bot feature for users to set spend limits.
- Jin provided resources and tools useful for documentation pipelines, including links to GitHub repositories and markdown files that automate TypeScript comments for API docs.
- Loaf contributed to the discussion on building out React interfaces and suggested using a direct client as the interface with runtime running in the client.
- RS1 offered assistance by sharing a shell script for codebase context, which helps filter specific files needed for understanding the project structure better.
- Jin mentioned their use of "code2prompt" tool, indicating its effectiveness and temporary nature until bigger context windows are available in 2025.

## Action Items
 - Technical Tasks
  - Implement a non-web accounting framework internal to the bot (mentioned by Odilitime)
  - Automate TypeScript comments for API documentation (requested by jin)
  - Develop tools useful for understanding codebase context, such as filtering certain files in shell scripts (discussed by rs1 and jin)
- Documentation Needs
  - Cover the structure of the repository more importantly with examples and usage details (requested by jin)
- Feature Requests
  - Use direct client interface for running runtime, possibly pushing to have the runtime in the client as well (suggested by loaf)
  - Explore bigger context windows for better understanding of files, potentially using Gemini Pro despite its current issues with Google's UX (discussed by jin and rs1)
- Community Tasks
  - Contribute to @neuraleth on GitHub masquerade feature inquiry (mentioned by yikesawjeez)

