# dev-contributors 2024-11-24

## Summary
 In the Discord chat, participants explored ways to load only desired features in their project, with suggestions including a core client with extensions and npm install @ai16z/eliza as a potential solution. The conversation shifted towards discussing Hats Protocol's DAO operations and philosophy, highlighting its modular runtime approach for advanced users who prefer building on the framework using npx or agent directory to develop plugins/modules. Additionally, there was mention of json configuration (though it may be phased out due to lack of typing) and core code hacking opportunities. Key technical discussions focused on feature loading methods, DAO operations in Hats Protocol, modular runtime customization for advanced users, and potential changes to json configurations.

## FAQ
 - How might people only load the features they want?
  - Shaw: npm install @ai16z/eliza is core; this package provides a minimal installation with essential features for users who prefer not to have all extensions loaded by default.

- What are some ways to customize or extend the platform's functionality beyond the core installation?
  - Odilitime: There’s json if you’re not a dev (though there is talk of it going away because it isn’t typed); npx and then agent directory for building on the framework, such as developing plugins/modules; Agent code controls what plugins/behaviors are enabled.
  - Yikesawjeez: Default eliza can be considered a prefabbed version of a modular runtime, allowing advanced users to have more control over their experience by using the runtime and lego blocks (plugins) to customize it as they see fit.

## Who Helped Who
 - Shaw helped pillhead with finding a core client extension by suggesting "npm install @ai16z/eliza is core" as an option.
- Jin helped yikesawjeez and Odilitime by providing links to discuss Hats Protocol's DAO operations, philosophy, and the scaffolding for building on the framework with npx and agent directory.

## Action Items
 Technical Tasks:
  - Install @ai16z/eliza npm package as core (mentioned by Shaw)
  - Discuss Hats Protocol DAO operations and philosophy on the provided Discord link (led by Jin)
  - Explore a modular runtime for advanced users, allowing them to build with runtime and lego blocks (suggested by yikesawjeez)
  - Review JSON configuration options or alternatives due to potential removal because of lack of typing (mentioned by Odilitime)
  - Build on the framework using scaffolding npx and agent directory for plugin/module development (mentioned by Odilitime)
  - Hack on the core code itself if desired (implied by Odilitime's mention of "core code")

