# dev-contributors 2024-11-25

## Summary
 In the Discord chat, Penguin sought assistance with registering actions for an EVM plugin, leading Ferric to share a potentially outdated but relevant doc link that helped Penguin proceed further. The discussion then shifted towards Eliza's minimum hardware requirements, where Odilitime and James Young provided insights on RAM needs due to playwright usage, with suggestions of using cloud providers for flexibility. Collaboration was proposed by James Young regarding a LangGraph plugin project. Ferric highlighted an engaging thread about enhancing bot personalities, while Odilitime mentioned contributor role assignments in GitHub PRs as a community milestone.

## FAQ
 - How do I register actions and hook them up in an EVM plugin?
  - Ferric: Provided a link to outdated documentation on plugins that might help with understanding the process of adding a plugin (https://ai16z.github.io/eliza/docs/packages/plugins/). Odilitime mentioned Eliza's RAM requirements and offered assistance if needed.

- What is the minimum Mac specification required for running Eliza?
  - Ferric: Mentioned that any Mac would do, as you can use a cloud provider; however, Odilitime specified that Eliza requires about 16GB of RAM due to playwright usage and will idle under 2G.

## Who Helped Who
 - Ferric helped Penguin with registering actions for an EVM plugin by providing a relevant documentation link.
- Odilitime assisted Eliza in determining hardware requirements for running models, specifically mentioning 16GB of RAM and suggesting cloud providers as alternatives to local machines.
- James Young reached out to collaborate on developing a LangGraph plugin for multi-agent supervisors, indicating an offer to work together on the project.

## Action Items
 Technical Tasks:
- Register actions and hook them up with the EVM plugin (mentioned by Penguin)
- Review a potentially outdated documentation link on plugins provided by Ferric | stakeware.xyz
- Determine the lowest Mac possible for Eliza coding, specifically inquiring about memory requirements (initiated by an unnamed user but further discussed by Odilitime and James Young)

Documentation Needs:
- Penguin requested documentation on adding a plugin or assistance in reviewing it to help start testing new actions.

Feature Requests:
- Collaboration on creating a LangGraph plugin for multi-agent supervisor (suggested by James Young)

Community Tasks:
- Ferric | stakeware.xyz shared a thread discussing efforts to make bots have more personality, which could be considered as fostering community engagement and collaboration.

