# dev-contributors 2024-11-29

## Summary
The community discussed several technical topics including Twitter and Telegram integrations for the Eliza project. They identified a need to review, consolidate PRs related to these functionalities while also addressing build issues by potentially enforcing CI passing before merging pull requests.

## FAQ
- Need some things tested and draft PRs finished? What are the specific tasks that need to be done? (asked by @OGs/Core/Partner-Contributor)
- Should we enforce CI passing before merging pull requests due to build issues encountered? (asked by cygaar)
- How do I use turborepo and run it? Is the regular build not working on my MacBook Pro M1, even after pnpm clean/install failed due to missing config.h file? (asked by @yodamaster726)
- Should running `pnpm` commands use turborepo by default? What's causing the errors related to 'node-opus' package, and is it being removed or fixed soon? (asked by @ShakkerNerd)

## Who Helped Who
- [@Shaw, @Cygaar] helped @OGs/Core/Partner-Contributor with Reviewing and consolidating Twitter related PRs by providing @OGs/Core/Partner-Contributor asked for help in reviewing and consolidating Twitter related PRs. The community provided a list of relevant GitHub links.
- @Cygaar helped [@Shaw, @OGs/Core/Partner-Contributor] with Twitter Integration by providing cygaar offered to take a pass at the twitter integration when they get some time.
- @yodamaster726 helped @shaw with Turborepo integration issues resolved, including build problems and 'node-opus' package errors. by providing @ShakkerNerd
- [cygaar](21:25) helped [yikesawjeez](21:30) with Removing redundancies from packages by providing Sort through package dependencies

## Action Items

### Technical Tasks
- Test and finish draft pull requests for Eliza project: https://github.com/ai16z/eliza/pull/391, 405 (mentioned by @OGs/Core/Partner-Contributor)
- Review and merge PR for Telegram functionality: https://github.com/ai16z/eliza/pull/491 (mentioned by @OGs/Core/Partner-Contributor)
- Turborepo integration completed, fixing build issues (mentioned by @ShakkerNerd)
- Sort through package dependencies to remove redundancies (mentioned by [cygaar](21:25))

### Documentation Needs
- Review, consolidate PRs related to Twitter functionality (mentioned by @OGs/Core/Partner-Contributor)
- Support needed for onboarding and maintenance tasks. (mentioned by [yikesawjeez](21:15))

### Feature Requests
- Consider enforcing CI passing before merging pull requests to address build issues. (mentioned by cygaar)
- Prioritize developer experience and bug fixes for the upcoming release. (mentioned by @shaw)