# dev-contributors 2024-12-03

## Summary
The main technical discussion revolved around an `postinstall` script error in the `@ai16z/plugin-node` package. Gita Alekhya faced issues with action registration and processing, despite correct keyword usage. Odilitime suggested debugging plugin examples using a video generation example as reference.

## FAQ
- Why is the bot not calling actions even with correct keywords in description?, (asked by @Gita Alekhya Paul)
- How to debug action prompts and set up plugin examples? (asked by @Odilitime)
- Is the issue related to registration or processing of actions?, (asked by @shaw)
- Should we replace `LLAMALOCAL` as the default model provider in packages
core
src
defaultCharacter.ts? What are some alternatives that allow easier access to API keys and work on any CPU without external dependencies? (asked by @YoungPhlo (11:42))
- Why does the terminal loop when sending first message in v0.1.5-alpha.0? How can we fix it to allow newcomers like Frank to get an Eliza agent up and running quickly? (asked by @YoungPhlo (11:48))
- Should we audit all packages & code in Eliza right now, ensuring no malicious content has been added that could potentially extract private keys from users' wallets? (asked by @Agent Joshua $ (15:15))
- Should we turn off dependency updates? What's the best way to do it? (asked by @ShakkerNerd)
- Who manages our npm? I'm seeing some errors publishing new plugins we made. (asked by @cygaar)
- Shouldn’t the issue be resolved if there are no issues when running against main? (asked by @ShakkerNerd)
- Why did you use version '2.21.53' for `viem`? Is it compatible with `@goat-sdk` using lower versions? How to resolve conflicts between different library versions? (asked by @cygaar)

## Who Helped Who
- @Odilitime helped Gita Alekhya Paul with Action prompt issue resolution by providing Debugging action description, checking for proper setup
- @YoungPhlo helped @cygaar, @Agent Joshua $ with Suggested opening a PR for local llama or updating documentation to improve user experience and performance on any CPU. by providing @Odilitime (13:12)
- @cygaar helped @Sirkitree @ShakkerNerd with Turn off dependency updates, remove Renovate.json file by providing Discussing potential solutions for managing dependencies and security concerns.
- @ShakkerNerd helped @cygaar with Update @solana/web3.js version by providing Merge PR
- @cygaar helped General Discord community members with Resolved plugin publishing errors by providing Identified user error in config modification
- @ShakkerNerd helped @shaker-nerd with Resolving version conflicts between `viem` and `@goat-sdk`. by providing @cygaar
- @cygaar helped @ShakkerNerd with Release workflow initiation by providing Merging pull request #838

## Action Items

### Technical Tasks
- Add a console log statement for action validation (mentioned by @tcm390)
- Open an issue regarding the loop problem when sending first message in terminal for `v0.1.5-alpha.0` (mentioned by @YoungPhlo)
- Audit all packages & code in Eliza to ensure no malicious content has been added, especially concerning private key extraction (mentioned by @Agent Joshua $)
- Turn off dependency updates (mentioned by @ShakkerNerd)
- Update @solana/web3.js version (mentioned by @cygaar)
- Investigate npm management for publishing new plugins (mentioned by @cygaar)
- Comment on the issue at https://github.com/ai16z/eliza/issues/817 and request proper formatting of `character.json` file (mentioned by @ShakkerNerd)
- Investigate compatibility between latest `viem` version (2.21.53) with `@goat-sdk`. (mentioned by @cygaar)
- Merge pull request #838, cut a new GitHub release after CI passes (mentioned by @cygaar)

### Documentation Needs
- Remove docs/api directory modifications in git status. (mentioned by @yodamaster726)
- Remove Renovate.json file to disable automated PR generation. (mentioned by @Sirkitree)
- Handle the next release until a good process is established. (mentioned by @cygaar)
- Update testing suite for Eliza tests on Solana Plugin to check breaking changes. (mentioned by [Agent Joshua $])
- Update package to alpha.3 version and run the release workflow. (mentioned by @ShakkerNerd)

### Feature Requests
- Increase action example count from 10 to 1000 (mentioned by @tcm390)
- Consider replacing `LLAMALOCAL` with an alternative model provider like `ETERNALAI` or `OPENROUTER`, which allows easier access to API keys (mentioned by @YoungPhlo)
- Prepare a PR to the documentation or local llama for better user experience and performance on any CPU, minimizing reliance on external services (mentioned by @Odilitime)
- Review action system and llama model issues. (mentioned by @shaw)