# dev-contributors 2024-12-05

## Summary
The chat segment focused on discussions around implementing a configuration option to allow users to select between small or large models. This was driven by concerns about API costs and flexibility within the system. The team agreed that this should be controlled via config rather than hardcoded, with pull request #853 being reviewed for merging.

## FAQ
- Should small models be a configuration option? Why are API costs for smaller model significantly cheaper than larger ones, and how can users specify the desired size in character cards or similar settings? (asked by @hosermage)
- Is it better to control large/small defaults via config rather than hardcoding? What are your thoughts on this approach for managing model sizes within our system, and how can we implement such a configuration option effectively in the context of pull request #853? (asked by @cygaar)
- Should we use big models for completions? Small ones are dumb but good for frequent/expensive tasks. Is there a bigger question of model providers and customization? (asked by @shaw)
- Would it be nice to have the ability to configure your choice of model provider for specifics task, considering ambiguity in `SMALL`,`MEDIUM` & `LARGE`? (asked by @Agent Joshua $)

## Who Helped Who
- @cygaar helped Odilitime and cygaar with Discussing the default values for model sizes, addressing potential issues with labels in pull request #853 by providing @ShakkerNerd
- dev team helped @Neodotneo with Agent Trading Training by providing @Neodotneo helped with agent trading training
- community member helped general community members with Optimized Dev Script by providing @ShakkerNerd is working on an optimized dev script to disable build for docs in the same PR.

## Action Items

### Technical Tasks
- Review, merge pull request #853 for model size configuration option (mentioned by @ShakkerNerd)
- Configure choice of model provider for tasks (mentioned by @Agent Joshua $)

### Documentation Needs
- Open a PR to address default values and make changes related to the character card feature. (mentioned by @cygaar)
- Optimize dev script to disable build on docs in PR. (mentioned by @ShakkerNerd)