# dev-contributors 2024-12-07

## Summary
The main technical discussion revolved around implementing a generic way to integrate 'langfuse' into various branches. The proposed solution is creating character config files that declare desired plugins, with checks for `environment.ts` file existence in each of them.

## FAQ
- What is the correct syntax for declaring plugins in character config files? Error messages are thrown when an object rather than a string is expected. (asked by @Yoni (09:06))
- Should we have both options of specifying bootstrap and node plugin directly, as well as loading additional ones from configuration? (asked by @Galego)
- Could character config files define the plugins to use? Should there be a function checking these for an `environment.ts` file and variable values within it? (asked by @Agent Joshua ₱ (08:35))

## Who Helped Who
-  helped @Yoni with Discussing the implementation of langfuse integration and plugin configuration by providing @Agent Joshua ₱ (08:35)
- [Galego] helped [cygaar] with Improving plugin specification method by providing Galego provided a suggestion for initializing plugins in runtime files and mapping user inputs.
- [Neodotneo](21:53) helped [Galego](14:20-14:21) with Improving plugin consistency by providing Suggested creating separate file for each action and standardizing input

## Action Items

### Technical Tasks
- Implement langfuse integration as a service (mentioned by @Yoni)
- Implement a better way to specify plugins using JSON files (mentioned by [cygaar, Galego])
- Create separate file for each action with standardized input (mentioned by [Neodotneo](21:53))

### Feature Requests
- Create character config file to declare desired plugins and check for `environment.ts` files. (mentioned by @Agent Joshua ₱)