# dev-vc 2024-11-16

## Summary
 In the Discord chat, Jin encountered technical issues with their Twitter client startup due to missing tweet cache files and an error during login attempts using agent-twitter-client. The server failed to start because of a recursive run failure in ai16z/agent@0.0.1. Meanwhile, Yikesawjeez shared links related to the Qwen2.5 model by mlx-community, creator fund information from Jin's repository, and resources on local development for creating new plugins with Eliza. Additionally, they discussed neurite network developments and a GitHub project called satellitecomponent/neurite.

## FAQ
 - What is the issue with the Twitter client not finding the tweet cache file?
  - Jin: The Tweet Cache File Path points to a non-existent or inaccessible file (/home/jin/repo/eliza/packages/client-twitter/dist/tweetcache/latest_checked_tweet_id.txt). This issue might be resolved by ensuring the correct path is set and that the file exists at that location.

- What does the error message "Incorrect. Please try again." mean when trying to log in using Twitter?
  - Jin: The error code 399 indicates an incorrect login attempt, possibly due to invalid credentials or a temporary issue with the authentication process. It is recommended to double-check the provided credentials and retry logging in after some time if it's a temporary problem.

- What could be causing the Node.js application to fail when starting?
  - Jin: The error message indicates that there was an issue running `tsc && node --loader ts-node/esm src/index.ts "--isRoot" "--characters=./characters/degenspartan.character.json"` command, which is part of the application's startup process. This could be due to a problem with TypeScript compilation or an issue within the specified script file. To resolve this, check for any syntax errors in the code and ensure that all dependencies are correctly installed.

- How can one create a new plugin using Eliza?
  - Jin: The guide on creating a new plugin is available at https://ai16z.github.io/eliza/docs/guides/local-development/#creating-a-new-plugin. This resource provides step-by-step instructions and best practices for developing plugins within the Eliza framework.

## Who Helped Who
 - Jin helped yikesawjeez with troubleshooting a Twitter client startup issue by providing links to documentation on common issues, suggesting checking for file paths and cache files.

- Yikesawjeez sought assistance from Jin regarding an error encountered while running a Node.js application using the agent-twitter-client package. Jin responded with resources related to community support, creator fund information, local development guides, and links to Neurite Network for potential solutions or further help.

## Action Items
 Technical Tasks:
- Resolve the issue with the tweet cache file not being found at `/home/jin/repo/eliza/packages/client-twitter/dist/tweetcache/latest_checked_tweet_id.txt` (mentioned by jin)
- Address the error related to Twitter user authentication, specifically code 399 ("Incorrect. Please try again.") and fix issues in `file:///home/jin/repo/eliza/node_modules/agent-twitter-client/dist/node/esm/index.mjs` (mentioned by jin)

Documentation Needs:
- Jin requested documentation on the community creator fund at https://ai16z.github.io/eliza/docs/community/creator-fund/ (requested by jin)

Feature Requests:
- Jin suggested creating a new plugin and provided guidance for local development, which could be considered as an indirect feature request to improve the platform's extensibility at https://ai16z.github.io/eliza/docs/guides/local-development/#creating-a-new-plugin (suggested by jin)

Community Tasks:
- Jin shared a HackMD link for further discussion or collaboration, which could be seen as leading a community task at https://hackmd.io/LVAwiU0kTMWzoZETA4AkfQ (led by jin)

