---
title: Discord Summarization
---

## About

Overall, the ai16z DAO v2 daily summary initiataive aims to create a more efficient, transparent, and engaging ecosystem by leveraging AI to address information overload and incentivize contributions. By automating key processes and providing meaningful insights, the project seeks to foster a dynamic and truly decentralized organization.

## Why?

Information Overload and Discord Limitations:
- Rapid growth leads to information fatigue, with Discord message volume exceeding 90,000 per day.
- Existing summarization bots require manual triggering and lack persistent logging.
- Discord lacks public indexing, hindering information retrieval and actionability.

![](/img/overload2.jpg)
Chatrooms move too fast for people to keep up with.

## How?

AI-Powered Summarization and Insight Extraction:

Leveraging LLMs (Large Language Models) to summarize daily chat logs per channel, working group, and server.

Extracting insights on:
- Frequently Asked Questions (FAQs)
- Daily progress and milestones
- Key decisions and discussions
- Member contributions and assistance
- Action items and pending tasks
- Potential pain points

## Benefits

Solution: Rebundle via automated summarization using LLMs to extract:
- Keep people updated, we move fast
- Less humans in the loop, use AI
  - Remove human bias and misaligned incentives, adding more transparency and thus more trust into the mix
  - Progressive automation of the DAO towards a truly decentralized and autonomous organization
- Extract contributions happening on Discord
  - Gamify open-source development by leveraging LLM insights to recognize and reward valuable contributions outside of GitHub
  - Use sentiment analysis to determine who is helping and if that help was successful
  - Create a points system based on engagement, assistance, and feedback (e.g., emoji reactions)
  - Develop contributor profile pages similar to MMO stat pages, showcasing contributions and achievements
  - Explore airdrops and other reward mechanisms for active contributors

![](/img/discord_llm_pipeline2.jpg)

## Future Integrations

AI Agents and Future Integrations:

Utilizing AI agents to:
  - Onboard new developers and assist with troubleshooting based on extracted FAQs.
  - Manage project tasks and verify progress.
  - Provide summaries tailored to specific work group interests.
    - "I would imagine we have AI agents that have a set of goals expectations responsibilities and then they can filter the chat logs from that perspective"
- Integrating with Hats Protocol to codify roles and responsibilities.
- Exploring interactive interfaces:
  - AI-powered dashboards and newsfeeds.
  - Virtual show format with an AI anchor broadcasting daily activities.
  - AI-generated podcasts and summaries.

