# stage 2024-12-01

## Summary
During a Discord chat about the upcoming 'DAO Demo Day', participants discussed automation features and confirmed that audio quality was good. Some users experienced issues with screen visibility, which were resolved by confirming it's visible to others.

## FAQ
- Can't see screen, is there a problem with the audio? (11:03-4) (asked by @shaw)
- Is this being recorded? (asked by @Neodotneo)
- Is there a legal team interested in protecting the project and its contributors? How can we ensure good legal design to prevent projects from failing due to poorly designed laws? (asked by [PabloFM | Numinia](11:19, 11:20))
- How/when can users try out the chat summarization feature? Is there a possibility of using 'degenai' for this purpose? (asked by [bp](11:21, 11:22))
- Can you do a quick overview? I was late. (asked by @boom (11:31))
- Do we have any plans for financial and legal teams in our role-playing game simulation? (asked by @PabloFM | Numinia)
- Could I ask a question at some point today please? - This indicates that the user wants to know when they can participate in Q&A sessions. (asked by _Xd9f (12:00))
- What about grok? Is it a good choice for fine-tuning on NSFW content like TOT or Zerebro? What is the difference between them in terms of handling explicit material and how do they achieve this functionality? (asked by @2696)
- How can we add knowledge to contexts within characterfiles for better fine-tuning results on specific dates, instead of receiving data from random ones? (asked by @jjj)
- Is it possible or recommended to directly fine tune Opus models as per current technology? (asked by crazy_coyote_san)

## Who Helped Who
- @cyberWarlock helped @shaw with Troubleshooting visibility issue during DAO Demo Day by providing Cheelax | zKorp confirmed that the screen is visible to others (11:04)
-  helped  with Inquired about the consistency of action items and how they are checked. by providing [Neodotneo](11:23)
- @Neodotneo (11:26) helped @boom with Data processing method by providing Neodotneo provided a solution to process data using FIFO model.
- PabloFM | Numinia helped Robin with Sharing experience on DAO Demo Day: Automation + RPGF. by providing PabloFM | Numinia thanked Robin for his work and expressed interest in sharing experiences.
- @crazy_coyote_san helped @WinS with Understanding fine-tuning models for explicit material by providing @2696 provided information on the differences between TOT, Zerebro and Grok in handling NSFW content.
- [crazy_coyote_san, jin] helped Opus issue resolution advice and roadmap information. with Technical support for Opus installation problem. Provided troubleshooting steps (clear cache/dependencies) and shared project's public roadmap link by providing [N00t]
- [W3_Bounty](13:42) helped [N00t](13:58) with Technical Issue Resolution by providing Discussing node installation issue and potential solutions
- @boyaloxer helped All members affected by the problem. with Fixing a Discord bug by providing Boyaloxer fixed double message issue.
- @yellowfish (14:22) helped @D with Confirmation of screenshare issue resolution by providing Yellowfish confirmed screen share visibility fix worked for them
- @D helped Nicolas (14:40) with Investigate sound issue by providing Sound is gone, possibly a bug or feature.

## Action Items

### Technical Tasks
- Ensure DAO Demo Day presentation includes automation features (mentioned by @jin)
- Investigate the possibility of running a Language Model against chat logs for summarization purposes. (mentioned by [cyberWarlock](11:20))
- Consider implementing a FIFO model for processing data (mentioned by @Neodotneo)
- Deploy on Sepolia with real hats/safes (mentioned by Robin)
- Evaluate Truth Terminal's fine-tuning on CLooI dataset with character 'Andy'. (mentioned by @crazy_coyote_san)
- Implement LLM-based automation for summarizing daily chat logs (mentioned by [crazy_coyote_san, jin])
- Fix node installation issue for eliza project (mentioned by [N00t](13:58))
- Fix double message issue (mentioned by @boyaloxer)
- Check screenshare settings for visibility issues. (mentioned by @ray, @D (multiple times))
- Investigate sound issue on Discord (mentioned by @shaw)
- Explore solutions for DAO landscape issues, specifically weighted voting (mentioned by [0xfabs](15:23))
- Investigate vesting or decay tokenomics for inactivity to prevent hostage situations (mentioned by [0xfabs](15:23))
- Consider implementing Soul tokens despite implementation challenges, as a potential solution to DAO issues (mentioned by [Dragonbutt](15:20))

### Documentation Needs
- Record the DAO demo day for future reference and analysis (mentioned by @Neodotneo)
- Create a working group or channel to support the work mentioned by Robin. (mentioned by PabloFM | Numinia)
- Investigate issues of Truth Terminal providing data from random dates instead of specific ones. (mentioned by @PureSlurp)
- Create a contributor profile page combining GitHub and Discord data (mentioned by [jin])
- Document the discussion on weighted voting and its impact on DAOs, including Soul tokens as a potential solution (mentioned by [Dragonbutt](15:20))

### Feature Requests
- Consider open-sourcing datasets to enable community contributions on personalized interfaces (mentioned by [rubinovitz](11:19))
- Explore podcast-style format like Notebook or 11 Labs to make content more digestible by general audiences. (mentioned by @Danny)