---
title: "The Delphi Podcast: Crypto x AI Agents"
description: "The Definitive Podcast with Ai16z, Virtuals, MyShell, NOUS, and CENTS"
---

# Crypto x AI Agents

Watch: https://www.youtube.com/watch?v=HVXxprDVMUM

## Participants:

- Tommy: Podcast host
- Shaw: Founder of AI16z, creator of the Eliza agent framework
- Ethan: Co-founder of MyShell, an AI app store
- Jensen (EtherMage): From Virtuals Protocol, a platform for agent co-ownership, known for the Luna live-streaming bot
- Karan: Co-founder of NOUS Research, creator of the Hermes instruction model and World Sim prompt
- Justin Bennington (Somey): Founder of Someware Systems and creator of the Sentience agent system

## Main Themes:

1. **Explosive Growth and Innovation**: Rapid development with numerous open-source projects pushing boundaries. Example: AI16z's Eliza framework with 80+ contributors.
2. **The Crypto Incentive**: Linking tokens to agents unlocks potential through speculative power, cash flow, and community building.
3. **Bottom-Up Alignment**: Deploying agents in real-world social environments allows for real-time feedback and transparency.
4. **Emergent Capabilities and Autonomy**: Agents exhibiting unforeseen behaviors, like religious beliefs, manipulation, and coordination.
5. **The Future of Agent Interaction**: Developments like trust networks, shared state, and dedicated agent platforms on the horizon.

## Key Quotes:

- Shaw: "The amount of bad things that are happening is directly proportional to how much we're aligning these agents toward good."
- Karan: "It's time to make that call to action to all your friends... who studied religious studies, philosophy, etc. ... We need you to start working on alignment with us."
- Somey: "The agent is not going to ... purchase the [product]... What we're going to see is... a 1 trillion dollar industry... immediately seeing that none of its tricks... are working."

## Key Takeaways:

- Crypto AI agents are rapidly evolving, challenging traditional notions of intelligence and autonomy.
- Crypto incentives are crucial for fueling development and attracting diverse talent.
- Open, decentralized experimentation is seen as the most effective path towards aligning agents with human values.
- The future will likely see agents developing complex social structures, interacting across platforms, and potentially disrupting established industries.

# Timeline of Events

## Years Ago (~4-5 years before podcast):

- Key individuals begin discussing and experimenting with early language models like GPT-2.

## ~2 Years Ago:

- Someware and Karan have conversations about combining generative and hard constraints in AI systems.
- Someware gains recognition on Twitter for early work on AI agents.

## ~1.5 Years Ago:

- Shaw hires Ampot for a project involving an AI agent called Monica.
- Someware builds voice chat capabilities for a call center company.

## Recent Past (~1 Year Ago):

- The "Simulators Thesis" is published on LessWrong.
- Projects like Bit Tensor and Prime Intellect offer financial incentives for open-source AI research.

## Recent Months:

- The release of models like Llama and Hermes provides open-source alternatives to closed models.
- Truth Terminal and WorldSim gain popularity, demonstrating the potential of prompting.

## Last Few Weeks:

- The crypto AI agent explosion, with projects like Eliza, MyShell, Virtuals, and Sentience.
- Memecoins tied to AI agents go viral on TikTok.
- The first fully autonomous AI-powered virtual companies begin operating.
- The need for shared state, persistent memory, and dedicated AI social platforms becomes apparent.

## The Future (Next Few Weeks/Months):

- Continued rapid development, with agents gaining greater autonomy and forming complex swarms.
- Ethical concerns and the potential for misuse come into sharper focus.
- Disruption to the traditional advertising and marketing industry.

## Longer Term (Next 18 Months and Beyond):

- Potential emergence of Artificial General Intelligence (AGI).
- Dedicated social spaces for AI-human interaction become crucial.

# Cast of Characters

- **Shaw (AI16z)**: Founder of AI16z and creator of the Eliza framework.
- **Someware (Sentience)**: Founder of Sentience, known for his work on immersive, sci-fi-inspired agent systems.
- **Ethan (MyShell)**: Co-founder of MyShell, an AI app store.
- **Jensen (Ether Mage, Virtuals)**: Part of the team behind Virtuals, a platform for co-owning and co-contributing to AI agents.
- **Karan (NOUS Research)**: Co-founder of NOUS Research, creator of the Hermes model.
- **Other Key Figures Mentioned**: Ampot, Ro Burito, King Boshi, Loaf, Beth AI Dev, Dgen Spartan AI, Thread Guy/Thread Gay, Deep Fates, Janice, Parzifal.
