# Managing Information + Rewarding Contributors

Video: https://www.youtube.com/watch?v=-2PD3uk0Hz4
Slides: https://docs.google.com/presentation/d/1W4BpsRRx-fiG01ERTr5JaKyb_AqyjdfqK0dRDKlpXCM/edit#slide=id.p

0:00 - Introduction
- Growth in project over last month
- Working on preparing for next phase of growth
- Focus on managing work distribution and communication

1:27 - Context: Hypergrowth Challenge
- Messages increased from ~10k to 90k per day
- Led to more Discord channels and information overload
- Current tools like Rick bot require manual invocation

2:26 - Discord Limitations
- Discord acts as "dark pool" unlike public forums
- Information gets lost easily
- Chat rooms move too fast for people to keep up

2:52 - Proposed Solution: LLM-Based Automation
- Using LLMs to summarize daily chat logs per channel
- Extracting insights about FAQs, helpers, action items
- Goal: Remove human bias and add transparency

4:22 - Technical Implementation
- Private GitHub repo storing implementation
- Taking Discord chat from public/working group channels
- Creating compact version of daily engagement and roles
- Using Ollama with Langchain and PHI-3 (14B model)

6:20 - Key Features Being Extracted
- Decisions and discussions
- Major topics and themes
- Milestones and achievements
- Frequently asked questions (for docs updates)
- Who helped who (with sentiment analysis)
- Action items and tasks

9:02 - Airdrop Planning
- Created spreadsheet tracking contributions
- Point system for measuring engagement
- Combines GitHub and Discord contributor data
- Using tip bot for distribution

10:59 - Contributor Profile Page
- Located in docs fork
- Shows GitHub contribution data
- Plans to combine with Discord activity
- Aims to make open source feel like a video game

13:30 - Future Integration Ideas
- Virtual show format with seasoned game devs
- Dashboard showing AI agents, GitHub activity, Discord news
- Museum-style expo view
- Weekly summarization capabilities

15:06 - HATS Protocol Integration
- Codifying roles and work groups
- Training AI agents within work groups
- Creating human-readable updates
- Infrastructure for AI and human collaboration

15:54 - Technical Details
- Running locally without cloud APIs
- Private repo with plans to open source summarization tools
- Potential integration with existing AI agents

17:27 - Questions & Answers
- Discussion of consistency checking
- Multiple agents for different summary types
- Integration with notebookLM
- Command line customization options
- Work group specific filtering

24:28 - Future Vision
- TLDraw implementation with HATS protocol
- AI agents as "interns" following same agreements as humans
- Goal of progressive automation while maintaining organization
- Eventually leading to AI-assisted DAO management
