---
sidebar_position: 4
title: "AI Agent Dev School Part 4"
description: "AI Pizza: Hacking Eliza for Domino's Delivery (plus TEE Deep Dive)"
---

# AI Agent Dev School Part 4

**AI Pizza: Hacking Eliza for Domino's Delivery (plus TEE Deep Dive)**

Date: 2024-12-10
YouTube Link: https://www.youtube.com/watch?v=6I9e9pJprDI

## Timestamps

Part 1: Trusted Execution Environments (TEEs) with Agent Joshua
- **00:00:09** - Stream starts, initial setup issues.
- **00:01:58** - Intro to Trusted Execution Environments (TEEs).
- **00:08:03** - Agent Joshua begins explaining TEEs and the Eliza plugin.
- **00:19:15** - Deeper dive into remote attestation.
- **00:24:50** - Discussion of derived keys.
- **00:37:00** - Deploying to a real TEE, Phala Network's TEE cloud.
- **00:50:48** - Q&A with Joshua, contact info, and next steps.

Part 2: Building a Domino's pizza ordering agent
- **01:04:37** - Transition to building a Domino's pizza ordering agent.
- **01:14:20** - Discussion of the pizza ordering agent’s order flow and state machine.
- **01:22:07** - Using Claude to generate a state machine diagram.
- **01:32:17** - Creating the Domino's plugin in Eliza.
- **01:54:15** - Working on the pizza order provider.
- **02:16:46** - Pizza provider code completed.
- **02:28:50** - Discussion of caching customer and order data.
- **03:13:45** - Pushing fixes to main branch and continuing work on the agent.
- **04:24:30** - Discussion of summarizing past agent dev school sessions.
- **05:01:18** - Shaw returns, admits to ordering Domino's manually.
- **05:09:00** - Discussing payment flow and a confirm order action.
- **05:27:17** - Final code push, wrap-up, and end of stream.


## Summary

This is a livestream titled "AI Agent Dev School Part 4" from the ai16z project, featuring Shaw. The stream is divided into two main parts: a technical discussion on Trusted Execution Environments (TEEs) and a coding session where Shaw attempts to build a pizza-ordering agent using the Domino's API.

**Part 1: Trusted Execution Environments (TEEs) with Agent Joshua**

This segment begins with Shaw introducing the concept of TEEs and their importance for running autonomous agents securely. He emphasizes the need to protect private keys and ensure that code execution is tamper-proof. Joshua from the Phala Network is brought on to explain TEEs in more detail and demonstrate how to use the TEE plugin he built for Eliza.

*   **Key Concepts:**
    *   **Trusted Execution Environments (TEEs):** Secure areas within a processor that isolate code and data, protecting them from unauthorized access and tampering.
    *   **Secure Enclave:** A cryptographic primitive that allows data to be encrypted and isolated within a processor.
    *   **Remote Attestation:** A method to verify that a program running inside a TEE is genuine and hasn't been tampered with, providing verifiability to users.
    *   **D-Stack:** An SDK developed in collaboration with Flashbots and Andrew Miller, enabling developers to build and launch Docker containers in TEEs.
    *   **Derived Key Provider:** A component that generates cryptographic keys based on a secret salt, ensuring that private keys are not exposed to humans.

*   **Demonstration:**
    *   Joshua walks through the process of setting up and deploying an Eliza agent in a TEE simulator, demonstrating how to generate remote attestations and derive keys.
    *   He shows how to use the remote attestation explorer to verify the authenticity of the agent running inside the TEE.
    *   He explains how to build a Docker image of the agent and deploy it to the Phala Network's TEE cloud solution.

*   **Use Cases:**
    *   Securely storing private keys for on-chain actions.
    *   Ensuring the integrity of autonomous agents, preventing tampering or unauthorized access.
    *   Providing verifiable execution for users and investors.

*   **Phala Network's TEE Cloud:**
    *   Joshua introduces Phala Network's TEE cloud solution, which allows developers to deploy Docker images and host their agents in a trusted execution environment.
    *   He mentions that the service supports various compute-intensive applications beyond AI agents.
    *   He invites interested developers to contact him on Discord (@hashwarlock) for onboarding and further details.

**Part 2: Building a Pizza Ordering Agent**

In the second part, Shaw transitions to a more lighthearted coding session where he attempts to build an agent that can order a pizza using the Domino's API. He highlights the challenges of handling payments securely and connecting user information to the conversation.

*   **Challenges:**
    *   Securely handling payment information.
    *   Connecting user data to the current conversation.
    *   Defining the order flow using a state machine.

*   **Approach:**
    *   Shaw uses a state machine to model the pizza ordering process, defining different states and transitions based on user input and available information.
    *   He uses Claude (an AI assistant) to generate code snippets and assist with the development process.
    *   He decides to initially focus on a simplified version where the user's payment information is hardcoded in the environment variables, and the agent only needs to collect the user's address.

## Hot Takes

1. **"Maybe we'll mix it on LinkedIn so people can order Domino's on LinkedIn. There you go. Now we're cooking." (00:03:26)** - Shaw's seemingly flippant idea of ordering pizza on LinkedIn highlights the potential for integrating everyday services into unexpected platforms through agents. This sparked discussion about the wider implications for businesses and social media.

2. **"Yeah, it'll probably get drained real quick. These fucking people." (00:28:30)** - Shaw accidentally leaked an API key on stream and expressed frustration with viewers who noticed, exposing the real-world risks of handling sensitive information during development, especially in a live environment.

3. **"The secret to making a billion dollars is to use the existing agent framework to deliver apps to people on social media that they want." (01:09:35)** - Shaw’s strong assertion about focusing on building apps *using* existing frameworks rather than creating new ones is a bold statement about the current agent development landscape, suggesting that innovation lies in application development, not framework creation.

4. **"So those are like, honest to God, if the bots are better than like 70% of tweets on Twitter, they're better than like 99.7 tweets and posts on LinkedIn." (01:39:57)** - This provocative comparison of content quality between Twitter and LinkedIn, suggesting bots surpass most LinkedIn posts, fueled lively debate in the chat and raised questions about the role and value of human-generated content in the age of AI.

5.  **"I subliminally messaged Domino's into my own brain, and now I have to eat it." (05:01:24)** - After hours of working on the pizza bot, Shaw abandoned the live coding attempt and ordered pizza manually, a humorous but relatable moment that highlighted the challenges and frustrations of software development, even when aided by AI.  It also underscores the human desire for immediate gratification, even in the face of a potentially groundbreaking technological advancement.
