---
sidebar_position: 5
title: "What Did You Get Done This Week? #5"
description: "Building the Future: 30+ Developers Share Their AI Agent Progress"
---

# What Did You Get Done This Week? #5

**Building the Future: 30+ Developers Share Their AI Agent Progress**

Date: 2024-12-13
Twitter Spaces: https://x.com/i/spaces/1lDxLlgYjMkxm
YouTube Link: https://www.youtube.com/watch?v=4u8rbjmvWC0

## Timestamps

- **00:01:04** - shawmakesmagic: Introduction and Format Changes for the Space
    - Link: https://www.youtube.com/watch?v=4u8rbjmvWC0&t=64
- **00:02:38** - xsubtropic: Redux project, DaVinci AI
    - Link: https://www.youtube.com/watch?v=4u8rbjmvWC0&t=158
- **00:06:57** - CottenIO: Scripted, AI Summit Recap
    - Link: https://www.youtube.com/watch?v=4u8rbjmvWC0&t=417
- **00:08:58** - HDPbilly: Real Agency HQ, "Sploot" agent
    - Link: https://www.youtube.com/watch?v=4u8rbjmvWC0&t=538
- **00:13:29** - IQ6900: On-chain ASCII art service
    - Link: https://www.youtube.com/watch?v=4u8rbjmvWC0&t=809
- **00:18:50** - frankdegods: Eliza Character Sheet Tweaks
    - Link: https://www.youtube.com/watch?v=4u8rbjmvWC0&t=1130
- **00:20:15** - jamesyoung: AI Agent Starter Kit
    - Link: https://www.youtube.com/watch?v=4u8rbjmvWC0&t=1215
- **00:23:29** - 0xglu: Ducky and Agent Swarms
    - Link: https://www.youtube.com/watch?v=4u8rbjmvWC0&t=1409
- **00:25:30** - chrislatorres: Eliza.gg - Eliza documentation site
    - Link: https://www.youtube.com/watch?v=4u8rbjmvWC0&t=1530
- **00:27:47** - reality_spiral: Self-Improving Agents & Github integration
    - Link: https://www.youtube.com/watch?v=4u8rbjmvWC0&t=1667
- **00:31:43** - robotsreview: Story Protocol plugin and Agentic TCPIP
    - Link: https://www.youtube.com/watch?v=4u8rbjmvWC0&t=1903
- **00:34:19** - shannonNullCode: Emblem Vault & Message Ingestion
    - Link: https://www.youtube.com/watch?v=4u8rbjmvWC0&t=2059
- **00:38:40** - bcsmithx: Agent Tank - Computer use agents
    - Link: https://www.youtube.com/watch?v=4u8rbjmvWC0&t=2320
- **00:41:20** - boyaloxer: Plugin Feel - Emotion-based agent
    - Link: https://www.youtube.com/watch?v=4u8rbjmvWC0&t=2480
- **00:44:09** - JustJamieJoyce: Muse of Truth/Research AI agents
    - Link: https://www.youtube.com/watch?v=4u8rbjmvWC0&t=2649
- **00:46:11** - yikesawjeez: Discord bot & Contribution updates
    - Link: https://www.youtube.com/watch?v=4u8rbjmvWC0&t=2771
- **00:50:56** - RodrigoSotoAlt: Monad, Metaplex Nfts, Solana integrations
    - Link: https://www.youtube.com/watch?v=4u8rbjmvWC0&t=3056
- **00:53:22** - HowieDuhzit: Eliza Character Generator
    - Link: https://www.youtube.com/watch?v=4u8rbjmvWC0&t=3202
- **00:55:57** - xrpublisher: XR Publisher, 3D Social Network on the edge
    - Link: https://www.youtube.com/watch?v=4u8rbjmvWC0&t=3357
- **01:00:57** - BV_Bloom1: 3D Agent Interactions
    - Link: https://www.youtube.com/watch?v=4u8rbjmvWC0&t=3657
- **01:02:57** - nftRanch: Trading Bot and Eliza V2 integrations
    - Link: https://www.youtube.com/watch?v=4u8rbjmvWC0&t=3777
- **01:05:57** - 019ec6e2: Mimetic Platform and Agent Interactions
    - Link: https://www.youtube.com/watch?v=4u8rbjmvWC0&t=3957
- **01:09:17** - jacobmtucker: Agent Transaction Control Protocol
    - Link: https://www.youtube.com/watch?v=4u8rbjmvWC0&t=4157
- **01:12:26** - CurtisLaird5: C-Studio character interface
    - Link: https://www.youtube.com/watch?v=4u8rbjmvWC0&t=4346
- **01:17:13** - unl__cky: Escapism, art generation AI
    - Link: https://www.youtube.com/watch?v=4u8rbjmvWC0&t=4633
- **01:19:17** - Rowdymode: Twin Tone - Interactive Streaming
    - Link: https://www.youtube.com/watch?v=4u8rbjmvWC0&t=4757
- **01:20:29** - mitchcastanet: Binary Star System research with agents
    - Link: https://www.youtube.com/watch?v=4u8rbjmvWC0&t=4829
- **01:23:15** - GoatOfGamblers: Prediction market for meme coins
    - Link: https://www.youtube.com/watch?v=4u8rbjmvWC0&t=4995
- **01:25:27** - JohnNaulty: SWE contributions, plugin working groups
    - Link: https://www.youtube.com/watch?v=4u8rbjmvWC0&t=5127
- **01:29:30** - mayanicks0x: Axie, AI KOL Agent
    - Link: https://www.youtube.com/watch?v=4u8rbjmvWC0&t=5370
- **01:31:30** - wakesync: Eliza Wakes Up, web app updates
    - Link: https://www.youtube.com/watch?v=4u8rbjmvWC0&t=5490
- **01:35:28** - TrenchBuddy: Trading agents and AWS templates
    - Link: https://www.youtube.com/watch?v=4u8rbjmvWC0&t=5728
- **01:38:36** - rakshitaphilip: Brunette token and agent tips on Warpcast
    - Link: https://www.youtube.com/watch?v=4u8rbjmvWC0&t=5916
- **01:44:49** - MbBrainz: Menu Recommendation app
    - Link: https://www.youtube.com/watch?v=4u8rbjmvWC0&t=6289
- **01:46:03** - Hawkeye_Picks: Storytelling bot
    - Link: https://www.youtube.com/watch?v=4u8rbjmvWC0&t=6363
- **01:49:16** - shawmakesmagic: Hiring and Eliza V2
    - Link: https://www.youtube.com/watch?v=4u8rbjmvWC0&t=6556
- **01:54:30** - dankvr: Community updates, tooling
    - Link: https://www.youtube.com/watch?v=4u8rbjmvWC0&t=6870


## Summary

This Twitter Spaces event, hosted by ai16z and titled "What Did You Get Done This Week? #5", was a fast-paced update session focusing on community members' progress on projects related to the Eliza AI framework. It was designed to be more structured, focusing on concrete accomplishments of the week and quickly moving through each speaker. A key aspect was also including updates from people who didn't want to speak directly, by reading their updates from a thread.

**Structure and Goals:**

*   **Focused Updates:** The goal was to have concise updates, with emphasis on what was *actually achieved* during the week rather than broader discussions.
*   **Time Management:** The hosts aimed to keep things moving efficiently and keep the meeting within a target time frame.
*   **Inclusive Updates:** Those who didn't want to speak could post a list of their accomplishments in a reply to a tweet, and those would be read aloud at the end.
*   **Data Capture:** The event aimed to capture updates for transcription, summaries, and later documentation purposes.
*   **Community Coordination:** The updates were seen as a way to help with coordination within the AI 16z community and with future planning.
*   **Working Groups:** There were several mentions of establishing more focused working groups around topics like swarms, plugins, and security.

**Other Notable Points:**

*   **Hiring:** Several speakers mentioned that they were actively hiring for developers.
*   **Open Source:** A consistent theme was the push for open-source development and community contribution.
*   **AI Integration:**  There were many projects that were actively integrating AI agents into different platforms like Twitter, Discord, Telegram, and gaming environments.
*   **Memory and Context:**  A recurring challenge was dealing with memory limitations and ensuring agents had sufficient context for coherent responses.
*   **Iterative Refinement:**  There was a lot of focus on iteratively testing, tweaking, and improving both agent behavior and infrastructure.
*   **Eliza v2:** There was a lot of hype around the upcoming Eliza v2 release, with many teams planning to align their development with the new version.
*   **Rapid Pace:** The rapid pace of development in the Eliza ecosystem was acknowledged, with many feeling like they were "stupidly early."
*   **Community Focus:** There was also recognition of the importance of community collaboration.

Overall, this event showed a vibrant and active community rapidly developing projects using the Eliza framework. It highlighted both the significant progress made in the past week and the challenges being tackled, showcasing the potential for AI agents in diverse real world applications.


## Hot Takes

1.  **"These corporations are going to cease to exist."** - **(00:07:31)** Tim Cotton makes a bold prediction about the future of traditional corporations in the face of AI agent technology. This implies a near-term and disruptive shift.

2.  **"I think I own like all the coins on stage and in the audience."** - **(00:19:25)** Frankdegods makes a boastful claim about his holdings which may ruffle feathers, especially regarding insider trading and ethical issues.

3.  **"I'm pretty sure that's a bug. You should make a PR for that because that should be fixed. That's definitely a bug."** - **(00:11:56)** Shaw quickly calls out the small model being set as default, and pushes for action on it. This could be considered a strong take that implies a sense of urgency to fix the problem.

4.  **"The goal always will be up and running with an agent in three minutes."** - **(00:22:09)** JamesYoung makes a claim about what is achievable with their tooling that may be too simplistic for some devs, and could be hard to reach with all the nuances and API keys they would need.

5.  **"We think that IP is the native asset ingested by and produced by agents like Eliza."** - **(01:10:26)** Jacob Tucker frames intellectual property as the core fuel for AI agents, which is a strong claim with implications about ownership and legal frameworks within AI systems and how that works with open source code.


---


\[00:02:45\] Tropic

- Working on Redux and agent DaVinci AI (fork of Eliza)
- Built streams UI showing DaVinci's thoughts on various topics
- Integrated NASA APIs for deep space photo analysis
- Created review engine for content quality before Twitter posts
- Shipped admin UI for Twitter post management
- Improving docs and refactoring Redux extensions

\[00:07:00\] Tim Cotton

- Spoke at AI Summit NYC about Eliza
- Working on Chad's metacognition loop
- Preparing to contribute to Eliza repo
- Actively hiring TypeScript developers
- Developing two upcoming partner projects

\[00:09:00\] HDP

- Building an agent on Eliza Framework for Real Agency HQ
- Implemented memory summarization system
- Fine-tuned a model for character "Sploots"
- Improved memory handling by summarizing past conversations
- Fixed model size issues in default runtime

\[00:13:45\] IQ6900

- Launching on-chain ASCII art storage service on Solana
- Developed efficient state-based storage solution
- Planning to introduce AI agent named Q
- Working to store Eliza's character file on-chain

\[00:19:15\] Frank

- Working on character sheets for Eliza agents
- Contributing to the community growth
- Focusing on improving agent interactions

\[00:21:40\] James (CollabLand)

- Released AI agent starter kit
- Added support for Telegram integration
- Planning Twitter and Farcaster Frames support
- Implementing Solana support
- Using Lit Protocol for key management

\[00:25:45\] 0xGlue (Duck AI)

- Improved Duck's codebase stability
- Working on hosting solution
- Implemented swarms functionality
- Developed decentralized P2P network for agent communication

\[00:27:35\] Chris Torres

- Created Eliza.gg
- Built documentation gathering system
- Implemented Q&A system for Eliza ecosystem

\[00:30:00\] Reality Spiral

- Working with agents to define their own character files
- Developing GitHub plugin for agent interaction
- Building Coinbase integration features
- Creating self-improving prompts

\[00:36:00\] Jamie

- Developing the Muse system
- Working on Muse of Truth for intelligence assessment
- Creating multiple specialized AI agents

\[00:41:45\] Shannon Code

- Working on Emblem Vault wallet service
- Implemented message ingestion across platforms
- Developed temporal memory system
- Working on agent interoperability

\[00:47:00\] Ben (Agent Tank)

- Launched Agent Tank with 4 computer-use agents
- Added OCR and voice features using 11labs
- Open-sourcing stack as "Tankwork"
- Planning Eliza compatibility

\[00:50:00\] Soto

- Built workshop for Monad developer ecosystem
- Implemented compressed NFTs for Bozo agent
- Working on 3D NFT collection

\[00:52:15\] Howie

- Created Eliza installer
- Built Eliza character generator
- Added OpenRouter API integration
- Implemented character file backup system

\[00:54:40\] Anthony (XR Publisher)

- Developed admin panel in Cloudflare worker
- Implemented edge-based memory system
- Added Discord integration with slash commands
- Working on 3D social network powered by AI

\[01:02:00\] Bloom

- Developed agent communication logic in 3D environment
- Working on character rigging
- Implementing React-based sentiment detection

\[01:04:00\] Ranch (Berkshire Hathaway)

- Fixed Docker issues
- Working on autonomous trading agent
- Implementing risk factor assessment
- Developing yield management system

\[01:05:45\] Unlucky (Escapism)

- Created autonomous art generation AI
- Refined character file with agent's input
- Reduced reply spam and improved engagement
- Building Discord community

\[01:07:25\] Hawkeye

- Working on storytelling bot project
- Developing choose-your-own-adventure system
- Experimenting with Alchemy for video commentary features
- Planning AI-driven talk show format

\[01:09:40\] Trench Buddy

- Creating individualized trading agents
- Modified Eliza framework for multiple agent support
- Built AWS CloudFormation templates
- Implemented Lambda function integration
- Added PostgreSQL database support

\[01:13:00\] Auk

- Working on Brunette token
- Developed agent on Warpcast
- Added MidJourney integration
- Implementing wallet handling and tipping system

\[01:14:45\] Maya

- Launched Axie on PumpFun
- Developing AI clone capabilities for KOLs
- Working with large alpha groups
- Planning integration across platforms

\[01:15:45\] Asimov (Eliza Wakes Up team)

- Implemented persistent web memory
- Added voice input/output using Whisper and 11 Labs
- Created Laura for Eliza with contextual image generation
- Developed conversation sharing system
- Built points system
- Implemented journal entry system every 6 hours
- Working on core memories feature

\[01:18:30\] Shaw (final update)

- Scaling up operations and hiring team members
- Completed foundation formation for Eliza Labs
- Working on value accrual strategies
- Developing partnership with major university for PhD program
- Architecting Eliza V2
- Focus on stability and multimodal capabilities

\[01:19:45\] Jin

- Refined Discord summarization scripts
- Open-sourced Discord summarizer
- Implemented Markdown to JSON conversion
- Created GitHub contributor analysis tools
- Working on AI agent training data systems
- Developing self-aware codebase features
