---
title: Events and Streams
---

# Events and Streams

Stay informed about the latest developments, milestones, and events related to ai16z and the Eliza framework. This page provides a timeline of key updates and announcements.

## Timeline

### October 2024

- **October 25**: Shaw discusses the Eliza framework, its capabilities, and the goal of creating an AI-powered venture capitalist named "AI Marc Andreeson." The framework allows for autonomous execution of on-chain activities.
- **October 27**: AI16Z and DegenAI relationship is clarified. The trust engine mechanics are explained, and the technical infrastructure is discussed. The development status and AI model architecture are also covered.
- **October 29**: The rapid growth of AI agents is discussed, along with the potential for AI to control blockchain keys and wallets. The creation story of ai16z is shared, and the importance of AI/crypto tipping points is emphasized.

### November 2024

- **November 6**: A deep dive into Eliza's architecture is provided, covering core abstractions, advanced usage, character-centric configuration, and action execution flow. Custom actions and limitations of action-only approaches are discussed.
- **November 8**: A comprehensive discussion on the intersection of memes, AI agents, and DAOs takes place. Key topics include trust systems, the relationship between memes and financial incentives, and the future of agent interaction.
- **November 10**: Threadguy interviews Shaw, discussing the development of AI agents on Twitter, the vision for AI-powered trading and investing, and the future of AI in the crypto space.
- **November 15**: The first "What Did You Get Done This Week?" session takes place, with contributors sharing updates on trust marketplace development, EVM wallet integration, AI-centric projects, and more.
- **November 21**: The Delphi Podcast hosts a discussion on crypto and AI agents with representatives from ai16z, Virtuals, MyShell, NOUS, and CENTS. Main themes include explosive growth, the crypto incentive, bottom-up alignment, emergent capabilities, and the future of agent interaction.
- **November 22**: The second "What Did You Get Done This Week?" session occurs, with updates on Eliza framework development, token launches, integration of AI agents into various platforms, and community-driven projects.
- **November 24**: A presentation on the Hats Protocol takes place, discussing its role in solving disorganization in DAOs and potential applications for ai16z, such as creating structured work groups and enabling AI agent integration for automated DAO operations.
- **November 26**: The first AI Agent Dev School session is held, featuring a deep dive into Eliza by Shaw. The session covers development basics, agent concepts, and a Q&A session.
- **November 28**: A discussion on "What Do Machines Dream Of?" takes place, exploring the potential benefits and challenges of AI agents, the importance of open collaboration and transparency, and the impact of AI on privacy and surveillance.
- **November 29**: The third "What Did You Get Done This Week?" session happens, with updates on self-sustaining AI DAOs, Slack and Reddit integrations, dark sun projects, LayerZero integrations, and more.

### December 2024

- **December 1**: Shaw presents on managing information and rewarding contributors within the ai16z community. He discusses using LLMs for automated chat summarization, extracting insights, and planning a retroactive airdrop for contributors.
- **December 3**: The second AI Agent Dev School session focuses on building complex AI agents using actions, providers, and evaluators. Live coding demonstrations and Q&A sessions are included.
- **December 5**: The third AI Agent Dev School session, titled "Form-Filling Frenzy & Eliza's Wild Ride," takes place. It covers building a form-filling agent, deep-diving into evaluators, and using AI for code generation.
- **December 6**: The fourth "What Did You Get Done This Week?" session occurs, with updates on dev school, in-person meetups, project growth, and various AI agent projects. Partnership announcements and discussions on AI's potential impact are also featured.

For more detailed information on each event, please refer to the corresponding stream notes or announcements.

