---
Title: AI Agent Dev School
---

# AI Agent Dev School

Welcome to the AI Agent Dev School series, a comprehensive guide to building intelligent agents using the Eliza framework. Over the course of three in-depth sessions, we cover everything from the basics of TypeScript and plugins to advanced topics like providers, evaluators, and dynamic agent behaviors.

## [Part 1: Introduction and Foundations](./part1.md)

In the first session, we start from the very beginning, assuming no prior knowledge of TypeScript, Git, or AI agent development. We cover:

- Historical context and the evolution of JavaScript and TypeScript
- Setting up your development environment
- Key concepts in Eliza: embedding models, characters, and chat clients
- Basics of working with Git and GitHub

By the end of part 1, you'll have a solid foundation for diving into agent development with Eliza.

## [Part 2: Deep Dive into Actions, Providers, and Evaluators](./part2.md) 

The second session focuses on the core building blocks of agent behavior in Eliza:

- Actions: The tasks and responses that agents can perform
- Providers: Modules that provide information and state to the agent's context
- Evaluators: Modules that analyze situations and agent actions, triggering further actions or modifications

We explore each of these in detail, walking through code examples and common use cases. We also cover how to package actions, providers and evaluators into reusable plugins.

## [Part 3: Building a User Data Extraction Agent](./part3.md)

In the final session, we apply the concepts from parts 1 and 2 to build a practical agentic application - a user data extraction flow. We cover:

- The provider-evaluator loop for gathering information and triggering actions
- Leveraging Eliza's cache manager for efficient storage
- Using AI assistants to aid in code development 
- Testing and debugging agent flows
- Adding dynamic behaviors based on completion state

By the end of part 3, you'll have the skills to build sophisticated, stateful agents that can interact naturally with users to accomplish complex tasks.
