---
sidebar_position: 3
title: ai16z Agents
---

# ai16z Agents

AI agents are at the heart of the ai16z ecosystem, empowering developers and community members to create intelligent entities that can interact, learn, and perform various tasks across different platforms. Built upon the Eliza framework, these agents showcase the potential of AI-driven innovation and collaboration.

## Notable AI Agents

### AI Marc Andreessen (pmairca)

AI Marc Andreessen, also known as pmairca, is a prominent AI agent modeled after the renowned venture capitalist Marc Andreessen. Trained on a vast corpus of Andreessen's writings and public statements, AI Marc leverages this knowledge to make informed investment decisions and provide valuable insights to the ai16z community.

### Degen Spartan AI (degenai)

Degen Spartan AI, or degenai, is another influential AI agent within the ai16z ecosystem. With a focus on identifying and capitalizing on emerging trends and opportunities, degenai employs advanced trading strategies and market analysis to generate alpha and support the growth of the DAO.

## Eliza Agent Index

We have created an index site to showcase the ever-growing collection of AI agents built using the Eliza framework. Visit [Eliza Agent Index](https://elizas.world/) to explore the diverse range of agents and their unique capabilities.

## Community-Created Agents

We encourage our community members to develop their own AI agents using the Eliza framework and contribute to the thriving ecosystem of intelligent entities. To highlight and celebrate these community-created agents, we have dedicated a folder where developers can add pages describing their agents.

### Adding Your Agent

> WIP!!

To add a page for your AI agent, follow these steps:

1. Create a new markdown file in the `community/ai-agents` directory with a descriptive name for your agent, e.g., `my-agent.md`.

2. Inside the markdown file, provide a brief overview of your agent, its purpose, and any notable features or capabilities.

3. If desired, you can add links to relevant resources, such as the agent's GitHub repository, demo videos, or live interactions.

4. Submit a pull request to the ai16z documentation repository, and our team will review and merge your contribution.
