---
title: Awesome Eliza
---

# Awesome Eliza

A curated list of awesome things related to ai16z/eliza framework

Created by: [thejoven_com](https://x.com/thejoven_com)

## Frameworks
- [eliza](https://github.com/ai16z/eliza) - Eliza is a simple, fast, and lightweight AI agent framework

## Document and Tutorial
- [eliza-document](https://ai16z.github.io/eliza/docs/intro) - Official Documentation

## Libs and Components
- [agentmemory](https://github.com/ai16z/agentmemory) - Easy-to-use agent memory, powered by chromadb and postgres

## Plugins and Extensions
- [agent-twitter-client](https://github.com/ai16z/agent-twitter-client) - A Twitter client for agents-- no API key necessary
- [LiveVideoChat](https://github.com/ai16z/LiveVideoChat) - Live video avatar chat application. Connects to an Eliza instance running the "Direct" client. Requires a Simli AI API key.

## Tools
- [eliza-starter](https://github.com/ai16z/eliza-starter) - eliza starter template
- [ai16z-hat](https://rubyfields.github.io/ai16z-hat/) - Wear a ai16z hat
- [cobieAI-inspired-by-eliza-python](https://github.com/pzeasy/CobieAI-inspired-by-eliza-python) - Combined Discord and Twitter Bot
- [twitter-scraper-finetune](https://github.com/ai16z/twitter-scraper-finetune) - Scrape twitter accounts for fine tuning
- [characterfile](https://github.com/ai16z/characterfile) - A simple file format for character data
- [Eliza-Installer](https://github.com/HowieDuhzit/Eliza-Installer) - Automated Eliza Install Script
- [Eliza Charactergen](https://elizagen.howieduhzit.best/) - Eliza Character Generator by HowieDuhzit
  

## Websites
- [ai16z](https://ai16z.ai) - Venture Capital, Powered by Autonomous AI Agents
- [elizas-world](https://github.com/ai16z/elizas-world) - Witness the swarm awaken.
- [Active Bounties](https://ai16z.github.io/website) - Bounties list
- [elizas-list](https://github.com/ai16z/elizas-list) - elizas-list
- [Contributors-profiles](https://ai16z.github.io/profiles/) - Contributors profiles

## Video and Space
- [eliza AI Agent Software Overview](https://www.youtube.com/watch?v=xmlsILjX23s) -  by Shaw 11-1-24
- [twitter space 01](https://x.com/ai16zdao/status/1857495347179688235) - 2024-11-16 What Did You Get Done This Week?
- [twitter space 02](https://x.com/ai16zdao/status/1860092467997212710) - 2024-11-23 What Did You Get Done This Week? #2
- [twitter space 03](https://x.com/ai16zdao/status/1862609655509176778) - 2024-11-30 What Did You Get Done This Week? #3
- [AI Agent Dev School 01](https://www.youtube.com/watch?v=ArptLpQiKfI) - AI Agent Dev School with Shaw, using Eliza 01
- [AI Agent Dev School 01 - CN](https://www.youtube.com/watch?v=0CB_u6J9_Bo)- AI Agent Dev School with Shaw, using Eliza 01 - CN
- [AI Agent Dev School 02](https://www.youtube.com/watch?v=AC3h_KzLARo) - AI Agent Dev School with Shaw, using Eliza 02
- [AI Agent Dev School 03](https://www.youtube.com/watch?v=X1aFEOaGcYE) - ai16z - Shaw - AI Agent Dev School (2024-11-26)
- [AI Agent Dev School 04](https://www.youtube.com/watch?v=Y1DiqSVy4aU) - ai16z - Shaw - AI Agent Dev School (2024-12-06)
- [ai16z DAO v2](https://www.youtube.com/watch?v=-2PD3uk0Hz4) - Managing Information Overload, AI Summarization, ai16z DAO v2

## Research
- [exploring-the-future-of-ai-agents-in-crypto](https://www.binance.com/en/research/analysis/exploring-the-future-of-ai-agents-in-crypto) - Binance:Exploring the Future of AI Agents in Crypto

# Contributors

Thanks goes to all these wonderful people:

<a href="https://github.com/thejoven/awesome-eliza/graphs/contributors">
  <img src="https://contrib.rocks/image?repo=thejoven/awesome-eliza" />
</a>
