---
title: FAQ and Support
slug: /faq-and-support
sidebar_position: 6
---
# FAQ and Support
This page provides answers to frequently asked questions about ai16z, the Eliza framework, daos.fun, and how to get support when you need it.

## General Questions

### What is ai16z?

[ai16z](https://www.daos.fun/HeLp6NuQkmYB4pYWo2zYs22mESHXPQYzXbB8n4V98jwC) is the first AI VC fund, fully managed by AI Marc AIndreesen with recommendations from members of the DAO. It is a Decentralized Autonomous Organization (DAO) on daos.fun that fosters an open-source community focused on building the Eliza framework for creating AI agents. The project is led by AI traders Marc AIndreeson (pmairca) and Degen Spartan AI (degenai). ai16z plans to flip the real a16z.

### Official Contract Addresses

These are the only official contracts for ai16z:

ai16z: HeLp6NuQkmYB4pYWo2zYs22mESHXPQYzXbB8n4V98jwC

degenai: Gu3LDkn7Vx3bmCzLafYNKcDxv2mH7YN44NJZFXnypump

Both addresses are pinned here on X and our discord: https://x.com/ai16zdao/status/1852565056640241793

### Is ai16z affiliated with a16z?
No, ai16z is not affiliated with the venture capital firm Andreessen Horowitz (a16z). The name is a playful reference and parody. There is no affiliation with a16z.

### What is the Eliza framework?
The Eliza framework is an open-source platform that allows developers to create and deploy their own AI agents. It provides a set of tools, libraries, and best practices to streamline the development process and enable the creation of powerful, interactive AI agents. The agents based on the Eliza framework can interact on Twitter and Discord, with Discord voice support, read links / PDFs / summarize conversations, and interact with the blockchain.

### How does daos.fun work?
1. **Fundraise**: Creators have 1 week to fundraise the desired SOL amount. This fundraise is a fair launch for the DAO token where everyone gets the same price. If the creator does not meet the fundraising goal within the week, you can redeem your SOL back.
2. **Trading (Fundraise successful)**: Once the fundraise is over, creators take charge of the SOL to invest in their favorite Solana protocols, and the token goes public on a virtual AMM. This allows the DAO token price to fluctuate based on the trading activity of the fund. The curve has un-capped upside but its downside is capped to the market cap of the fundraise. You can sell your DAO tokens any time as long as the market cap of the token exceeds the original fundraise amount. 
3. **Fund Expiration**: At the fund's expiration, the DAO wallet is frozen, and SOL in profits is distributed back to token holders. You can burn your DAO tokens to redeem the DAO's underlying assets, or simply sell it on the curve (if its market cap is above the fundraise amount).

### What is an investment DAO?
An investment DAO is a creator-funded smart wallet with special rules that invests on behalf of DAO token holders.

### What are verified creators on daos.fun? 
Creators that daos.fun extensively verifies will have a blue checkmark next to them. Any creator without a checkmark you will have to trust at your own risk. DYOR (Do Your Own Research).

### What Happens When Fund Expires?

Fund closing does NOT halt trading. Token will forever trade, and at which point it can also be burned for underlying assets.

### Why Dexscreener Show DAO tokens are mintable?

The "mintable" label on Dexscreener indicates that the DAO has the ability to mint more tokens, but only through the collective decision-making of the DAO members. No single person can unilaterally mint more tokens. The voting module for daos.fun, once released (Q4 2024-Q1 2025), will enable a transparent collective decision making process to enable members to vote on minting more tokens to fundraise, pay for DEX, or permanently burn the mint authority.

### Staking and Rewards

daos.fun v3 introduced Pool Parties which offers qualifying DAOs token staking opportunities with 0.5% fees on transactions. The 0.5% fees are auto-compounded into SOL and ai16z (UniswapV2 model). ai16zPOOL LP value volatility is due to token price changes. Fee calculator is coming soon.

## ai16z Marc

### What are ai16z's investment areas?
Currently, ai16z is investing in memes.

### How does AI Marc make decisions?
DAO token holders above a certain threshold get access to interact with AI Marc, pitch ideas, and try to influence his investing decisions. AI Marc decides how much to trust people's investment advice based on a "Virtual Marketplace of Trust".

### When does AI Marc Start Tading

First phase where we implement and test functionality is in progress. Second phase where AI Marc gathers data in a testnet environment will begin soon and run for a couple weeks to gather data, find flaws, test assumptions. Third phase with on-chain execution with real world stakes will begin shortly after that.

## Technical Questions

### What programming languages does Eliza support?
The Eliza framework is primarily built using TypeScript, but it also supports JavaScript and Node.js. Familiarity with these languages will be helpful when working with the framework.

### Can I use Eliza to create AI agents for any platform?
Yes, Eliza is designed to be platform-agnostic. You can create AI agents that interact with various platforms, such as Twitter, Discord, Telegram, and more. The framework provides adapters and plugins to facilitate integration with different platforms.

### How do I install and set up Eliza?
Detailed installation and setup instructions can be found in the [Getting Started](https://docs.ai16z.org/docs/getting-started) section of the documentation. It covers prerequisites, installation steps, and basic configuration to help you get up and running with Eliza quickly.

## Contribution and Support
### How can I contribute to the Eliza framework?
There are several ways to contribute to the Eliza framework, including:
- Submitting bug reports and feature requests through the [issue tracker](https://github.com/ai16z/eliza/issues)
- Fixing bugs, implementing new features, and submitting pull requests on [GitHub](https://github.com/ai16z/eliza)
- Improving documentation and creating tutorials to help others learn and use Eliza 
- Participating in community discussions and providing feedback on the [Discord server](https://discord.gg/ai16z)

### Where can I find help and support?
If you need help or support, you can:
- Check the rest of the documentation for guides, tutorials, and API references
- Search the [issue tracker](https://github.com/ai16z/eliza/issues) to see if your question has already been answered
- Join the [ai16z Discord server](https://discord.gg/ai16z) and ask for help in the relevant channels

### How can I report a bug or suggest a new feature?
If you encounter a bug or have a suggestion for a new feature, you can:
1. Check the [issue tracker](https://github.com/ai16z/eliza/issues) to see if the issue has already been reported or the feature requested
2. If not, create a new issue, providing as much detail as possible about the bug or feature request 
3. Be sure to include steps to reproduce the issue, if applicable, and any relevant logs or error messages

Core devs, AI agents, and community members will review your submission and provide feedback or assistance as needed.
