# @ai16z/eliza

## Enumerations

- [Clients](enumerations/Clients.md)
- [GoalStatus](enumerations/GoalStatus.md)
- [ModelClass](enumerations/ModelClass.md)
- [ModelProviderName](enumerations/ModelProviderName.md)
- [ServiceType](enumerations/ServiceType.md)

## Classes

- [AgentRuntime](classes/AgentRuntime.md)
- [DatabaseAdapter](classes/DatabaseAdapter.md)
- [MemoryManager](classes/MemoryManager.md)
- [Service](classes/Service.md)

## Interfaces

- [Account](interfaces/Account.md)
- [Action](interfaces/Action.md)
- [ActionExample](interfaces/ActionExample.md)
- [Actor](interfaces/Actor.md)
- [Content](interfaces/Content.md)
- [ConversationExample](interfaces/ConversationExample.md)
- [EvaluationExample](interfaces/EvaluationExample.md)
- [Evaluator](interfaces/Evaluator.md)
- [Goal](interfaces/Goal.md)
- [IAgentRuntime](interfaces/IAgentRuntime.md)
- [IBrowserService](interfaces/IBrowserService.md)
- [IDatabaseAdapter](interfaces/IDatabaseAdapter.md)
- [IImageDescriptionService](interfaces/IImageDescriptionService.md)
- [IMemoryManager](interfaces/IMemoryManager.md)
- [IPdfService](interfaces/IPdfService.md)
- [ISpeechService](interfaces/ISpeechService.md)
- [ITextGenerationService](interfaces/ITextGenerationService.md)
- [ITranscriptionService](interfaces/ITranscriptionService.md)
- [IVideoService](interfaces/IVideoService.md)
- [Memory](interfaces/Memory.md)
- [MessageExample](interfaces/MessageExample.md)
- [Objective](interfaces/Objective.md)
- [Participant](interfaces/Participant.md)
- [Provider](interfaces/Provider.md)
- [Relationship](interfaces/Relationship.md)
- [Room](interfaces/Room.md)
- [State](interfaces/State.md)

## Type Aliases

- [Character](type-aliases/Character.md)
- [Client](type-aliases/Client.md)
- [Handler](type-aliases/Handler.md)
- [HandlerCallback](type-aliases/HandlerCallback.md)
- [Media](type-aliases/Media.md)
- [Model](type-aliases/Model.md)
- [Models](type-aliases/Models.md)
- [Plugin](type-aliases/Plugin.md)
- [UUID](type-aliases/UUID.md)
- [Validator](type-aliases/Validator.md)

## Variables

- [defaultCharacter](variables/defaultCharacter.md)
- [elizaLogger](variables/elizaLogger.md)
- [embeddingDimension](variables/embeddingDimension.md)
- [embeddingZeroVector](variables/embeddingZeroVector.md)
- [evaluationTemplate](variables/evaluationTemplate.md)
- [settings](variables/settings.md)

## Functions

- [addHeader](functions/addHeader.md)
- [composeActionExamples](functions/composeActionExamples.md)
- [composeContext](functions/composeContext.md)
- [createGoal](functions/createGoal.md)
- [createRelationship](functions/createRelationship.md)
- [embed](functions/embed.md)
- [findNearestEnvFile](functions/findNearestEnvFile.md)
- [formatActionNames](functions/formatActionNames.md)
- [formatActions](functions/formatActions.md)
- [formatActors](functions/formatActors.md)
- [formatEvaluatorExampleDescriptions](functions/formatEvaluatorExampleDescriptions.md)
- [formatEvaluatorExamples](functions/formatEvaluatorExamples.md)
- [formatEvaluatorNames](functions/formatEvaluatorNames.md)
- [formatEvaluators](functions/formatEvaluators.md)
- [formatGoalsAsString](functions/formatGoalsAsString.md)
- [formatMessages](functions/formatMessages.md)
- [formatPosts](functions/formatPosts.md)
- [formatRelationships](functions/formatRelationships.md)
- [formatTimestamp](functions/formatTimestamp.md)
- [generateCaption](functions/generateCaption.md)
- [generateImage](functions/generateImage.md)
- [generateMessageResponse](functions/generateMessageResponse.md)
- [generateObject](functions/generateObject.md)
- [generateObjectArray](functions/generateObjectArray.md)
- [generateShouldRespond](functions/generateShouldRespond.md)
- [generateText](functions/generateText.md)
- [generateTextArray](functions/generateTextArray.md)
- [generateTrueOrFalse](functions/generateTrueOrFalse.md)
- [getActorDetails](functions/getActorDetails.md)
- [getEndpoint](functions/getEndpoint.md)
- [getGoals](functions/getGoals.md)
- [getModel](functions/getModel.md)
- [getProviders](functions/getProviders.md)
- [getRelationship](functions/getRelationship.md)
- [getRelationships](functions/getRelationships.md)
- [loadEnvConfig](functions/loadEnvConfig.md)
- [retrieveCachedEmbedding](functions/retrieveCachedEmbedding.md)
- [splitChunks](functions/splitChunks.md)
- [trimTokens](functions/trimTokens.md)
- [updateGoal](functions/updateGoal.md)
