# Contributing to Eliza

First off, thank you for considering contributing to Eliza! We welcome contributions from everyone, regardless of experience level.

## Contribution License Agreement

By contributing to Eliza, you agree that your contributions will be licensed under the MIT License. This means:

1. You grant us (and everyone else) a perpetual, worldwide, non-exclusive, royalty-free license to use your contributions.
2. Your contributions are and will be available as Free and Open Source Software (FOSS).
3. You have the right to submit the work under this license.
4. You understand that your contributions are public and that a record of the contribution is maintained indefinitely.

## The OODA Loop: A Framework for Contribution

We believe in the power of the OODA Loop - a decision-making framework that emphasizes speed and adaptability. OODA stands for:

-   **Observe**: Gather information and insights about the project, the community, and the broader AI ecosystem.
-   **Orient**: Analyze your observations to identify opportunities for contribution and improvement.
-   **Decide**: Choose a course of action based on your analysis. This could be proposing a new feature, fixing a bug, or creating content.
-   **Act**: Execute your decision and share your work with the community.

## How to Contribute

### For Developers

1. **Extend Eliza's Capabilities**

    - Develop new actions, evaluators, and providers
    - Improve existing components and modules

2. **Enhance Infrastructure**

    - Review open issues and submit PRs
    - Test and update documentation
    - Optimize performance
    - Improve deployment solutions

3. Fork the repo and create your branch from `main`.
    1. The name of the branch should start with the issue number and be descriptive of the changes you are making.
    2. Example: 9999--add-test-for-bug-123
3. If you've added code that should be tested, add tests.
4. Ensure the test suite passes.
5. Make sure your code lints.
6. Issue that pull request!

## Styleguides

### Git Commit Messages

-   Use the present tense ("Add feature" not "Added feature")
-   Use the imperative mood ("Move cursor to..." not "Moves cursor to...")
-   Limit the first line to 72 characters or less
-   Reference issues and pull requests liberally after the first line

### JavaScript Styleguide

-   All JavaScript must adhere to [JavaScript Standard Style](https://standardjs.com/).

### TypeScript Styleguide

-   All TypeScript must adhere to [TypeScript Standard Style](https://github.com/standard/ts-standard).

### Documentation Styleguide

-   Use [Markdown](https://daringfireball.net/projects/markdown/) for documentation.

## Additional Notes

### Issue and Pull Request Labels

This section lists the labels we use to help us track and manage issues and pull requests.

-   `bug` - Issues that are bugs.
-   `enhancement` - Issues that are feature requests.
-   `documentation` - Issues or pull requests related to documentation.
-   `good first issue` - Good for newcomers.

## Getting Help

-   Join [Discord](https://discord.gg/ai16z)
-   Check [FAQ](docs/community/faq.md)
-   Create GitHub issues

## Additional Resources

-   [Local Development Guide](docs/guides/local-development.md)
-   [Configuration Guide](docs/guides/configuration.md)
-   [API Documentation](docs/api)

## Contributor Guide

Welcome to the Eliza contributor guide! This document is designed to help you understand how you can be part of building the future of autonomous AI agents, regardless of your technical background.

### Code of Conduct

#### Our Pledge

In the interest of fostering an open and welcoming environment, we as contributors and maintainers pledge to make participation in our project and our community a harassment-free experience for everyone, regardless of age, body size, disability, ethnicity, sex characteristics, gender identity and expression, level of experience, education, socio-economic status, nationality, personal appearance, race, religion, or sexual identity and orientation.

#### Our Standards

Examples of behavior that contributes to creating a positive environment include:

-   Using welcoming and inclusive language
-   Being respectful of differing viewpoints and experiences
-   Gracefully accepting constructive criticism
-   Focusing on what is best for the community
-   Showing empathy towards other community members

Examples of unacceptable behavior include:

-   The use of sexualized language or imagery and unwelcome sexual attention or advances
-   Trolling, insulting/derogatory comments, and personal or political attacks
-   Public or private harassment
-   Publishing others' private information without explicit permission
-   Other conduct which could reasonably be considered inappropriate in a professional setting

#### Our Responsibilities

Project maintainers are responsible for clarifying the standards of acceptable behavior and are expected to take appropriate and fair corrective action in response to any instances of unacceptable behavior.

Project maintainers have the right and responsibility to remove, edit, or reject comments, commits, code, wiki edits, issues, and other contributions that are not aligned to this Code of Conduct, or to ban temporarily or permanently any contributor for other behaviors that they deem inappropriate, threatening, offensive, or harmful.

#### Scope

This Code of Conduct applies both within project spaces and in public spaces when an individual is representing the project or its community. Examples of representing a project or community include using an official project e-mail address, posting via an official social media account, or acting as an appointed representative at an online or offline event.

Thank you for contributing to Eliza and helping build the future of autonomous AI agents! 🎉
