import React from 'react'
import { storiesOf } from '@storybook/react'
import { withInfo } from '@storybook/addon-info'
import { generateLibTree } from '@nivo/generators'
import { BubbleHtml } from '../index'

const commonProperties = {
    width: 900,
    height: 500,
    root: generateLibTree(),
    identity: 'name',
    value: 'loc',
    label: 'name',
    labelSkipRadius: 16,
}

storiesOf('BubbleHtml', module)
    .addDecorator(story => <div className="wrapper">{story()}</div>)
    .add('default', withInfo()(() => <BubbleHtml {...commonProperties} />))
    .add(
        'rendering leaves only',
        withInfo()(() => <BubbleHtml {...commonProperties} leavesOnly={true} />)
    )
    .add(
        'with formatted values',
        withInfo()(() => (
            <BubbleHtml
                {...commonProperties}
                tooltipFormat={value =>
                    `${Number(value).toLocaleString('ru-RU', {
                        minimumFractionDigits: 2,
                    })} ₽`
                }
            />
        ))
    )
    .add(
        'custom tooltip',
        withInfo()(() => (
            <BubbleHtml
                {...commonProperties}
                tooltip={({ id, value, color }) => (
                    <strong style={{ color }}>
                        {id}: {value}
                    </strong>
                )}
                theme={{
                    tooltip: {
                        container: {
                            background: '#333',
                        },
                    },
                }}
            />
        ))
    )
